/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.tree.btree;

import jetbrains.exodus.ByteIterable;
import jetbrains.exodus.log.ByteIteratorWithAddress;
import jetbrains.exodus.log.CompressedUnsignedLongByteIterable;
import jetbrains.exodus.log.RandomAccessLoggable;
import jetbrains.exodus.tree.TreeCursor;
import jetbrains.exodus.tree.btree.BTreeBase;
import jetbrains.exodus.tree.btree.BTreeDupMutable;
import jetbrains.exodus.tree.btree.BTreeTraverser;
import jetbrains.exodus.tree.btree.BasePage;
import jetbrains.exodus.tree.btree.LeafNode;
import jetbrains.exodus.tree.btree.LeafNodeDup;
import org.jetbrains.annotations.NotNull;

final class BTreeDup
extends BTreeBase {
    @NotNull
    final LeafNodeDup leafNodeDup;
    private final ByteIterable leafNodeDupKey;
    private final long startAddress;
    private final int dataOffset;

    BTreeDup(@NotNull BTreeBase mainTree, @NotNull LeafNodeDup leafNodeDup) {
        super(mainTree.getLog(), mainTree.getBalancePolicy(), false, mainTree.getStructureId());
        this.leafNodeDup = leafNodeDup;
        this.leafNodeDupKey = leafNodeDup.getKey();
        ByteIteratorWithAddress iterator = leafNodeDup.getRawValue(0).iterator();
        long l = CompressedUnsignedLongByteIterable.getLong(iterator);
        this.size = l >> 1;
        if ((l & 1L) == 1L) {
            long offset = CompressedUnsignedLongByteIterable.getLong(iterator);
            this.startAddress = leafNodeDup.getAddress() - offset;
            this.dataOffset = CompressedUnsignedLongByteIterable.getCompressedSize(l) + CompressedUnsignedLongByteIterable.getCompressedSize(offset);
        } else {
            this.startAddress = -1L;
            this.dataOffset = CompressedUnsignedLongByteIterable.getCompressedSize(l);
        }
    }

    @Override
    public long getRootAddress() {
        throw new UnsupportedOperationException("BTreeDup has no root in 'Loggable' terms");
    }

    public long getStartAddress() {
        return this.startAddress;
    }

    @Override
    @NotNull
    public BTreeDupMutable getMutableCopy() {
        return new BTreeDupMutable(this, this.leafNodeDupKey);
    }

    @Override
    public TreeCursor openCursor() {
        return new TreeCursor(new BTreeTraverser(this.getRoot()));
    }

    @Override
    @NotNull
    protected BasePage getRoot() {
        return this.loadPage(this.leafNodeDup.getType(), this.leafNodeDup.getRawValue(this.dataOffset));
    }

    @Override
    @NotNull
    protected LeafNode loadLeaf(long address) {
        RandomAccessLoggable loggable = this.getLoggable(address);
        if (loggable.getType() == 11) {
            return new LeafNode(loggable){

                @Override
                @NotNull
                public ByteIterable getValue() {
                    return BTreeDup.this.leafNodeDupKey;
                }

                @Override
                public boolean isDupLeaf() {
                    return true;
                }

                @Override
                public String toString() {
                    return "DLN {key:" + this.getKey().toString() + "} @ " + this.getAddress();
                }
            };
        }
        throw new IllegalArgumentException("Unexpected loggable type " + loggable.getType() + " at address " + loggable.getAddress());
    }

    @Override
    protected boolean isDupKey(long address) {
        return false;
    }
}

