/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.tree.btree;

import jetbrains.exodus.ByteIterable;
import jetbrains.exodus.ByteIterableBase;
import jetbrains.exodus.log.CompressedUnsignedLongByteIterable;
import jetbrains.exodus.tree.ITree;
import jetbrains.exodus.tree.btree.BTreeMutable;
import jetbrains.exodus.tree.btree.BaseLeafNodeMutable;
import jetbrains.exodus.util.LightOutputStream;
import org.jetbrains.annotations.NotNull;

class LeafNodeMutable
extends BaseLeafNodeMutable {
    private long address = -1L;
    private final ByteIterable key;
    private final ByteIterable value;

    LeafNodeMutable(@NotNull ByteIterable key, @NotNull ByteIterable value) {
        this.key = key;
        this.value = value;
    }

    @Override
    @NotNull
    public ByteIterable getKey() {
        return this.key;
    }

    @Override
    @NotNull
    public ByteIterable getValue() {
        return this.value;
    }

    @Override
    public long getAddress() {
        return this.address;
    }

    @Override
    public long save(ITree tree) {
        if (this.address != -1L) {
            throw new IllegalStateException("Leaf already saved");
        }
        int keyLength = this.key.getLength();
        BTreeMutable mutableTree = (BTreeMutable)tree;
        LightOutputStream output = mutableTree.getLeafStream();
        output.clear();
        CompressedUnsignedLongByteIterable.fillBytes(keyLength, output);
        ByteIterableBase.fillBytes((ByteIterable)this.key, (LightOutputStream)output);
        ByteIterableBase.fillBytes((ByteIterable)this.value, (LightOutputStream)output);
        this.address = tree.getLog().write(mutableTree.getLeafType(), tree.getStructureId(), (ByteIterable)output.asArrayByteIterable());
        return this.address;
    }

    @Override
    public boolean delete(ByteIterable value) {
        throw new UnsupportedOperationException("Supported by dup node only");
    }

    @Override
    public String toString() {
        return "LN* {key:" + this.key.toString() + "} @ " + this.address;
    }
}

