/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.services.environment;

import de.iip_ecosphere.platform.services.environment.AbstractRunnablesService;
import de.iip_ecosphere.platform.services.environment.DataIngestor;
import de.iip_ecosphere.platform.services.environment.MonitoringService;
import de.iip_ecosphere.platform.services.environment.ServiceState;
import de.iip_ecosphere.platform.services.environment.YamlProcess;
import de.iip_ecosphere.platform.services.environment.YamlService;
import de.iip_ecosphere.platform.services.environment.metricsProvider.MetricsProvider;
import de.iip_ecosphere.platform.support.CollectionUtils;
import de.iip_ecosphere.platform.support.OsUtils;
import de.iip_ecosphere.platform.support.TimeUtils;
import de.iip_ecosphere.platform.support.logging.LoggerFactory;
import de.iip_ecosphere.platform.support.metrics.Gauge;
import de.iip_ecosphere.platform.support.metrics.MetricsFactory;
import de.iip_ecosphere.platform.support.processInfo.ProcessInfoFactory;
import de.iip_ecosphere.platform.transport.connectors.ReceptionCallback;
import de.iip_ecosphere.platform.transport.serialization.TypeTranslator;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.concurrent.ExecutionException;
import java.util.function.Consumer;
import java.util.function.Function;

public abstract class AbstractProcessService<I, SI, SO, O>
extends AbstractRunnablesService
implements MonitoringService {
    private static boolean inheritIo = false;
    private TypeTranslator<I, String> inTrans;
    private TypeTranslator<String, O> outTrans;
    private Map<Class<?>, List<ReceptionCallback<?>>> callbacks = new HashMap();
    private YamlService serviceSpec;
    private PrintWriter serviceIn;
    private Process proc;
    private ProcessInfoFactory.ProcessInfo osProcess;

    protected AbstractProcessService(TypeTranslator<I, String> inTrans, TypeTranslator<String, O> outTrans, ReceptionCallback<O> callback, YamlService serviceSpec) {
        super(serviceSpec);
        this.inTrans = inTrans;
        this.outTrans = outTrans;
        this.serviceSpec = serviceSpec;
        this.addCallback(callback);
    }

    private void addCallback(ReceptionCallback<?> callback) {
        if (null != callback) {
            Class type = callback.getType();
            List<ReceptionCallback<?>> list = this.callbacks.get(type);
            if (null == list) {
                list = new ArrayList();
                this.callbacks.put(type, list);
            }
            list.add(callback);
        }
    }

    public void processQuiet(I data) {
        try {
            this.process(data);
        }
        catch (IOException e) {
            LoggerFactory.getLogger(this.getClass()).error("Processing failed: " + e.getMessage());
        }
    }

    public <P> void attachIngestor(final Class<P> outCls, final DataIngestor<P> ingestor) {
        this.addCallback(new ReceptionCallback<P>(){

            public void received(P data) {
                ingestor.ingest(data);
            }

            public Class<P> getType() {
                return outCls;
            }
        });
        if (null != this.proc) {
            this.handleInputStream(this.proc.getInputStream());
        }
    }

    public abstract void process(I var1) throws IOException;

    protected YamlService getServiceSpec() {
        return this.serviceSpec;
    }

    protected YamlProcess getProcessSpec() {
        return null == this.serviceSpec ? null : this.serviceSpec.getProcess();
    }

    protected void addProcessSpecCmdArg(List<String> args) {
        YamlProcess pSpec = this.getProcessSpec();
        if (null != pSpec && null != pSpec.getCmdArg()) {
            args.addAll(pSpec.getCmdArg());
        }
    }

    protected <P> void notifyCallbacks(P data) {
        Class<?> cls;
        List<ReceptionCallback<?>> cbs;
        if (data != null && null != (cbs = this.callbacks.get(cls = data.getClass()))) {
            for (int c = 0; c < cbs.size(); ++c) {
                cbs.get(c).received(data);
            }
        }
    }

    protected Iterable<ReceptionCallback<?>> getCallbacks(Class<?> cls) {
        return this.callbacks.get(cls);
    }

    protected TypeTranslator<I, String> getInputTranslator() {
        return this.inTrans;
    }

    protected TypeTranslator<String, O> getOutputTranslator() {
        return this.outTrans;
    }

    public static String getOsArch(boolean name32) {
        String os = "";
        String arch = null;
        if (OsUtils.isWindows()) {
            os = "win";
            String winArch = System.getenv("PROCESSOR_ARCHITECTURE");
            String wow64Arch = System.getenv("PROCESSOR_ARCHITEW6432");
            arch = winArch != null && winArch.endsWith("64") || wow64Arch != null && wow64Arch.endsWith("64") ? "64" : "32";
        } else {
            os = "linux";
        }
        if (null == arch) {
            arch = OsUtils.getOsArch().endsWith("64") ? "64" : "32";
        }
        if (!name32 && "32".equals(arch)) {
            arch = "";
        }
        return os + arch;
    }

    public static String getExecutableSuffix() {
        String result = "";
        if (OsUtils.isWindows()) {
            result = ".exe";
        }
        return result;
    }

    public static String getExecutablePrefix(String program, String version) {
        return AbstractProcessService.getExecutablePrefix(program, version, false);
    }

    public static String getExecutablePrefix(String program, String version, boolean name32) {
        return program + "-" + version + "-" + AbstractProcessService.getOsArch(name32);
    }

    public static String getExecutableName(String program, String version, boolean name32) {
        return AbstractProcessService.getExecutablePrefix(program, version, name32) + AbstractProcessService.getExecutableSuffix();
    }

    public static String getExecutableName(String program, String version) {
        return AbstractProcessService.getExecutableName(program, version, false);
    }

    public static Process createProcess(File exe, boolean byName, File dir, List<String> args) throws IOException {
        return AbstractProcessService.createProcess(exe, byName, dir, args, null);
    }

    public static Process createProcess(File exe, boolean byName, File dir, List<String> args, Consumer<ProcessBuilder> customizer) throws IOException {
        ArrayList<String> tmp = new ArrayList<String>();
        if (byName || !exe.exists()) {
            tmp.add(exe.getName());
        } else {
            tmp.add(exe.getAbsolutePath());
        }
        if (null != args) {
            tmp.addAll(args);
        }
        System.out.println("Cmd line: " + CollectionUtils.toStringSpaceSeparated(tmp) + " in " + String.valueOf(dir));
        ProcessBuilder processBuilder = new ProcessBuilder(tmp);
        processBuilder.directory(dir);
        if (null != customizer) {
            customizer.accept(processBuilder);
        }
        if (inheritIo) {
            processBuilder.inheritIO();
        }
        return processBuilder.start();
    }

    public static boolean setInheritIo(boolean inherit) {
        boolean orig = inheritIo;
        inheritIo = inherit;
        return orig;
    }

    public static RunnableWithStop redirectIO(final InputStream in, final PrintStream dest) {
        RunnableWithStop result = new RunnableWithStop(){
            private boolean cnt = true;

            @Override
            public void run() {
                Scanner sc = new Scanner(in);
                while (this.cnt && sc.hasNextLine()) {
                    String line = sc.nextLine();
                    dest.println(line);
                }
                sc.close();
            }

            @Override
            public void stop() {
                this.cnt = false;
            }
        };
        new Thread(result).start();
        return result;
    }

    public static void waitAndDestroy(Process proc) {
        AbstractProcessService.waitAndDestroy(proc, 200);
    }

    public static void waitAndDestroy(Process proc, int sleepTime) {
        if (null != proc) {
            while (proc.isAlive()) {
                TimeUtils.sleep((int)sleepTime);
            }
            proc.destroyForcibly();
            while (proc.isAlive()) {
                TimeUtils.sleep((int)sleepTime);
            }
        }
    }

    @Override
    protected ServiceState stop() {
        if (null != this.serviceIn) {
            this.serviceIn.flush();
            this.serviceIn = null;
        }
        if (null != this.proc) {
            TimeUtils.sleep((int)Math.max(0, this.getWaitTimeBeforeDestroy()));
            if (null != this.proc) {
                this.proc.destroy();
                AbstractProcessService.waitAndDestroy(this.proc);
                this.proc = null;
                this.osProcess = null;
            }
        }
        return super.stop();
    }

    protected int getWaitTimeBeforeDestroy() {
        return 300;
    }

    protected void handleOutputStream(OutputStream out) {
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(out));
        this.serviceIn = new PrintWriter(writer);
    }

    protected abstract void handleInputStream(InputStream var1);

    protected void handleErrorStream(InputStream err) {
        this.register(AbstractProcessService.redirectIO(err, System.err));
    }

    protected Process createAndConfigureProcess(File exe, boolean byName, File dir, List<String> args) throws ExecutionException {
        try {
            this.proc = AbstractProcessService.createProcess(exe, byName, dir, args, p -> this.configure((ProcessBuilder)p));
            this.handleOutputStream(this.proc.getOutputStream());
            this.handleInputStream(this.proc.getInputStream());
            this.handleErrorStream(this.proc.getErrorStream());
            this.attachProcessInformation();
            Runtime.getRuntime().addShutdownHook(new Thread(() -> this.stop()));
        }
        catch (IOException e) {
            throw new ExecutionException(e);
        }
        return this.proc;
    }

    private void attachProcessInformation() {
        if (null == this.osProcess) {
            this.osProcess = ProcessInfoFactory.getInstance().create(this.proc);
        }
    }

    public long getPid() {
        return AbstractProcessService.getProcessId(this.proc);
    }

    public static long getProcessId(Process proc) {
        return null == proc ? -1L : proc.pid();
    }

    protected void configure(ProcessBuilder builder) {
    }

    protected PrintWriter getServiceIn() {
        return this.serviceIn;
    }

    @Override
    public void attachMetricsProvider(MetricsProvider provider) {
        if (null != provider) {
            ((Gauge.GaugeBuilder)MetricsFactory.buildGauge((String)("service." + this.getId() + ".process.memory.used"), () -> null == this.osProcess ? 0L : this.osProcess.getVirtualSize()).description("Used memory of the attached process")).baseUnit(provider.getMemoryBaseUnit().stringValue()).register(provider.getRegistry());
        }
    }

    protected static <T> T selectNotNull(T value, T dflt) {
        T result = value;
        if (null == result) {
            result = dflt;
        }
        return result;
    }

    protected static <O, T> T selectNotNull(O object, Function<O, T> valueFunc, T dflt) {
        return AbstractProcessService.selectNotNull(object != null ? (T)valueFunc.apply(object) : null, dflt);
    }

    public static interface RunnableWithStop
    extends Runnable {
        public void stop();
    }
}

