/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.services.environment.metricsProvider;

import de.iip_ecosphere.platform.support.FileUtils;
import de.iip_ecosphere.platform.support.TimeUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedDeque;

public class LogRunnable
implements Runnable {
    private Queue<LogRecord> queue = new ConcurrentLinkedDeque<LogRecord>();
    private PrintStream out;
    private boolean run = true;

    public LogRunnable(File file) throws IOException {
        FileUtils.deleteQuietly((File)file);
        this.out = new PrintStream(new FileOutputStream(file));
    }

    @Override
    public void run() {
        while (this.run) {
            LogRecord rec = this.queue.poll();
            if (null != rec) {
                this.out.println(rec.activity + "\t" + rec.duration);
                this.out.flush();
            }
            TimeUtils.sleep((int)2);
        }
    }

    public void log(String activity, long duration) {
        this.queue.add(new LogRecord(activity, duration));
    }

    public void stop() {
        this.run = false;
    }

    private static class LogRecord {
        private String activity;
        private long duration;

        public LogRecord(String activity, long duration) {
            this.activity = activity;
            this.duration = duration;
        }
    }
}

