/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.support.commons;

import de.iip_ecosphere.platform.support.commons.CommonsProviderDescriptor;
import de.iip_ecosphere.platform.support.commons.FileAlterationMonitor;
import de.iip_ecosphere.platform.support.commons.FileAlterationObserver;
import de.iip_ecosphere.platform.support.commons.Tailer;
import de.iip_ecosphere.platform.support.commons.TailerListener;
import de.iip_ecosphere.platform.support.plugins.PluginManager;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.time.Duration;
import java.util.List;
import java.util.concurrent.ExecutionException;

public abstract class Commons {
    public static final String PROP_JAVA_HOME = "java.home";
    public static final String PROP_USER_HOME = "user.home";
    public static final String PROP_TMP_DIR = "java.io.tmpdir";
    public static final String PROP_OS_NAME = "os.name";
    public static final String PROP_OS_ARCH = "os.arch";
    public static final String PROP_JAVA_SPEC_VER = "java.specification.version";
    private static Commons instance = PluginManager.getPluginInstance(Commons.class, CommonsProviderDescriptor.class);

    public static Commons getInstance() {
        return instance;
    }

    public static void setInstance(Commons commons) {
        if (null != commons) {
            instance = commons;
        }
    }

    public abstract void reverse(Object[] var1);

    public abstract void copyFields(Object var1, Object var2) throws ExecutionException;

    public abstract String escapeJava(String var1);

    public abstract String unescapeJava(String var1);

    public abstract String escapeJson(String var1);

    public abstract String unescapeJson(String var1);

    public abstract <T extends CharSequence> T defaultIfBlank(T var1, T var2);

    public abstract <T extends CharSequence> T defaultIfEmpty(T var1, T var2);

    public abstract boolean isBlank(CharSequence var1);

    public abstract boolean isNotBlank(CharSequence var1);

    public abstract String replaceOnce(String var1, String var2, String var3);

    public abstract boolean isEmpty(CharSequence var1);

    public abstract String toString(Object var1);

    public abstract String toStringShortStyle(Object var1);

    public abstract String removeStart(String var1, String var2);

    public abstract String removeEnd(String var1, String var2);

    public String getUserHome() {
        return System.getProperty(PROP_USER_HOME);
    }

    public abstract boolean isWindows();

    public abstract boolean isLinux();

    public abstract boolean isUnix();

    public abstract boolean isMac();

    public abstract boolean isJava1_8();

    public abstract boolean isAtLeastJava9();

    public String getOsName() {
        return System.getProperty(PROP_OS_NAME, "");
    }

    public String getOsArch() {
        return System.getProperty(PROP_OS_ARCH, "");
    }

    public File getJavaHome() {
        return new File(System.getProperty(PROP_JAVA_HOME));
    }

    public String getJavaSpecificationVersion() {
        return System.getProperty(PROP_JAVA_SPEC_VER);
    }

    public abstract boolean isIpV4Addess(String var1);

    public abstract String toString(InputStream var1, Charset var2) throws IOException;

    public abstract List<String> readLines(InputStream var1, Charset var2) throws IOException;

    public abstract byte[] toByteArray(InputStream var1) throws IOException;

    public abstract boolean deleteQuietly(File var1);

    public abstract void forceDelete(File var1) throws IOException;

    public abstract void deleteOnExit(File var1);

    public String getTempDirectoryPath() {
        return System.getProperty(PROP_TMP_DIR);
    }

    public File getTempDirectory() {
        return new File(this.getTempDirectoryPath());
    }

    public File getUserDirectory() {
        return new File(this.getUserDirectoryPath());
    }

    public String getUserDirectoryPath() {
        return System.getProperty(PROP_USER_HOME);
    }

    public abstract String fileToBase64(File var1) throws IOException;

    public abstract void base64ToFile(String var1, File var2) throws IOException;

    public abstract File findFile(File var1, String var2);

    public abstract void write(File var1, CharSequence var2, Charset var3) throws IOException;

    public abstract String readFileToString(File var1) throws IOException;

    public abstract String readFileToString(File var1, Charset var2) throws IOException;

    public abstract void cleanDirectory(File var1) throws IOException;

    public abstract void deleteDirectory(File var1) throws IOException;

    public abstract void copyDirectory(File var1, File var2, FileFilter var3) throws IOException;

    public abstract void copyDirectory(File var1, File var2, FileFilter var3, boolean var4) throws IOException;

    public abstract void copyDirectory(File var1, File var2) throws IOException;

    public abstract void copyFile(File var1, File var2) throws IOException;

    public abstract void writeStringToFile(File var1, String var2) throws IOException;

    public abstract void writeStringToFile(File var1, String var2, Charset var3) throws IOException;

    public abstract byte[] readFileToByteArray(File var1) throws IOException;

    public abstract void writeByteArrayToFile(File var1, byte[] var2) throws IOException;

    public abstract void writeByteArrayToFile(File var1, byte[] var2, boolean var3) throws IOException;

    public abstract void copyInputStreamToFile(InputStream var1, File var2) throws IOException;

    public abstract boolean contentEquals(File var1, File var2) throws IOException;

    public abstract void registerDateConverters();

    public abstract Tailer createTailer(File var1, TailerListener var2, Duration var3, boolean var4);

    public abstract FileAlterationObserver createFileAlterationObserver(String var1, FileFilter var2);

    public abstract FileAlterationMonitor createFileAlterationMonitor(long var1, FileAlterationObserver ... var3);
}

