/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.transport.serialization;

import de.iip_ecosphere.platform.transport.serialization.DefaultQualifiedElement;
import de.iip_ecosphere.platform.transport.serialization.QualifiedElement;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;

public class QualifiedElementFactory {
    private static final Map<Class<?>, Supplier<?>> SUPPLIERS = new HashMap();

    public static void reset() {
        SUPPLIERS.clear();
    }

    public static <T> Supplier<QualifiedElement<T>> getSupplier(Class<T> cls) {
        Supplier<Object> supplier = SUPPLIERS.get(cls);
        if (null == supplier) {
            supplier = () -> new DefaultQualifiedElement();
            SUPPLIERS.put(cls, supplier);
        }
        return supplier;
    }

    public static <T> QualifiedElement<T> createElement(Class<T> cls) {
        return QualifiedElementFactory.getSupplier(cls).get();
    }

    public static <T> void registerElementSupplier(Class<T> cls, Supplier<QualifiedElement<T>> supplier) {
        if (null != cls && null != supplier) {
            SUPPLIERS.put(cls, supplier);
        }
    }
}

