/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.codec.decoder;

import com.hivemq.bootstrap.ClientConnectionContext;
import com.hivemq.codec.decoder.MqttDecoder;
import com.hivemq.configuration.HivemqId;
import com.hivemq.configuration.service.FullConfigurationService;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.extension.sdk.api.annotations.Nullable;
import com.hivemq.mqtt.handler.connack.MqttConnacker;
import com.hivemq.mqtt.message.QoS;
import com.hivemq.mqtt.message.connect.CONNECT;
import com.hivemq.mqtt.message.connect.MqttWillPublish;
import com.hivemq.mqtt.message.reason.Mqtt5ConnAckReasonCode;
import com.hivemq.util.Bytes;
import com.hivemq.util.ClientIds;
import com.hivemq.util.Strings;
import io.netty.buffer.ByteBuf;

public abstract class AbstractMqttConnectDecoder
extends MqttDecoder<CONNECT> {
    protected static final int DISCONNECTED = -1;
    private static final byte VARIABLE_HEADER_LENGTH = 10;
    @NotNull
    protected final MqttConnacker mqttConnacker;
    @NotNull
    protected final ClientIds clientIds;
    protected final long maxSessionExpiryInterval;
    protected final long maxUserPropertiesLength;
    protected final boolean allowAssignedClientId;
    protected final boolean validateUTF8;

    protected AbstractMqttConnectDecoder(@NotNull MqttConnacker mqttConnacker, @NotNull FullConfigurationService configurationService, @NotNull ClientIds clientIds) {
        this.mqttConnacker = mqttConnacker;
        this.clientIds = clientIds;
        this.validateUTF8 = configurationService.securityConfiguration().validateUTF8();
        this.maxUserPropertiesLength = 0x500000L;
        this.maxSessionExpiryInterval = configurationService.mqttConfiguration().maxSessionExpiryInterval();
        this.allowAssignedClientId = configurationService.securityConfiguration().allowServerAssignedClientId();
    }

    protected void disconnectByInvalidFixedHeader(@NotNull ClientConnectionContext clientConnectionContext) {
        this.mqttConnacker.connackError(clientConnectionContext.getChannel(), "A client (IP: {}) connected with an invalid fixed header.", "Invalid CONNECT fixed header", Mqtt5ConnAckReasonCode.MALFORMED_PACKET, "Sent CONNECT with invalid fixed header.");
    }

    protected void disconnectByInvalidHeader(@NotNull ClientConnectionContext clientConnectionContext) {
        this.mqttConnacker.connackError(clientConnectionContext.getChannel(), "A client (ID: {},IP: {}) connected with an invalid CONNECT header.", "Invalid CONNECT header", Mqtt5ConnAckReasonCode.PROTOCOL_ERROR, "Sent CONNECT with invalid variable header. This is a protocol violation.");
    }

    protected boolean validateWill(boolean isWillFlag, boolean isWillRetain, int willQoS, @NotNull ClientConnectionContext clientConnectionContext) {
        boolean valid;
        boolean bl = valid = isWillFlag && willQoS < 3 || !isWillRetain && willQoS == 0;
        if (!valid) {
            this.mqttConnacker.connackError(clientConnectionContext.getChannel(), "A client (IP: {}) connected with an invalid willTopic flag combination. Disconnecting client.", "Invalid will-topic/flag combination", Mqtt5ConnAckReasonCode.MALFORMED_PACKET, "Sent CONNECT with an invalid will-topic/flag combination.");
        }
        return valid;
    }

    protected boolean validateConnectFlagByte(byte connectFlagsByte, @NotNull ClientConnectionContext clientConnectionContext) {
        if (Bytes.isBitSet(connectFlagsByte, 0)) {
            this.mqttConnacker.connackError(clientConnectionContext.getChannel(), "A client (IP: {}) connected with invalid CONNECT flags. Disconnecting client.", "Invalid CONNECT flags", Mqtt5ConnAckReasonCode.MALFORMED_PACKET, "Sent CONNECT with invalid connect flags.");
            return false;
        }
        return true;
    }

    protected boolean validateProtocolName(@NotNull ByteBuf variableHeader, @NotNull ClientConnectionContext clientConnectionContext, @NotNull String protocolName) {
        if (!protocolName.equals(Strings.getPrefixedString(variableHeader))) {
            this.mqttConnacker.connackError(clientConnectionContext.getChannel(), "A client (IP: {}) connected with an invalid protocol name. Disconnecting client.", "Invalid CONNECT protocol name", Mqtt5ConnAckReasonCode.UNSUPPORTED_PROTOCOL_VERSION, "Sent CONNECT with invalid protocol name.");
            variableHeader.clear();
            return false;
        }
        return true;
    }

    protected boolean validateUsernamePassword(boolean isUsernameFlag, boolean isPasswordFlag) {
        return !isPasswordFlag || isUsernameFlag;
    }

    @Nullable
    protected ByteBuf decodeFixedVariableHeaderConnect(@NotNull ClientConnectionContext clientConnectionContext, @NotNull ByteBuf buf) {
        if (buf.readableBytes() >= 10) {
            return buf.readSlice(10);
        }
        this.disconnectByInvalidHeader(clientConnectionContext);
        return null;
    }

    @Nullable
    protected MqttWillPublish readMqtt3WillPublish(@NotNull ClientConnectionContext clientConnectionContext, @NotNull ByteBuf buf, int willQoS, boolean isWillRetain, @NotNull HivemqId hiveMQId) {
        String willTopic;
        int utf8StringLengthWill;
        MqttWillPublish.Mqtt3Builder willBuilder;
        block9: {
            block8: {
                willBuilder = new MqttWillPublish.Mqtt3Builder();
                willBuilder.withQos(QoS.valueOf(willQoS));
                willBuilder.withRetain(isWillRetain);
                if (buf.readableBytes() < 2) break block8;
                utf8StringLengthWill = buf.readUnsignedShort();
                if (buf.readableBytes() >= utf8StringLengthWill) break block9;
            }
            this.mqttConnacker.connackError(clientConnectionContext.getChannel(), "A client (IP: {}) sent a CONNECT with an incorrect will-topic length. Disconnecting client.", "Incorrect CONNECT will-topic length", Mqtt5ConnAckReasonCode.MALFORMED_PACKET, "Incorrect CONNECT will-topic length.");
            return null;
        }
        if (this.validateUTF8) {
            willTopic = Strings.getValidatedPrefixedString(buf, utf8StringLengthWill, true);
            if (willTopic == null) {
                this.mqttConnacker.connackError(clientConnectionContext.getChannel(), "The will-topic of the client (IP: {}) is not well formed. This is not allowed. Disconnecting client.", "Sent CONNECT with bad UTF-8 character", Mqtt5ConnAckReasonCode.MALFORMED_PACKET, "Sent CONNECT with bad UTF-8 character.");
                return null;
            }
        } else {
            willTopic = Strings.getPrefixedString(buf, utf8StringLengthWill);
        }
        if (AbstractMqttConnectDecoder.isInvalidTopic(clientConnectionContext, willTopic)) {
            this.mqttConnacker.connackError(clientConnectionContext.getChannel(), null, "Sent CONNECT with invalid will-topic", Mqtt5ConnAckReasonCode.MALFORMED_PACKET, "Sent CONNECT with invalid will-topic.");
            return null;
        }
        byte[] prefixedBytes = Bytes.getPrefixedBytes(buf);
        byte[] willMessage = prefixedBytes != null ? prefixedBytes : new byte[]{};
        return willBuilder.withPayload(willMessage).withTopic(willTopic).withHivemqId(hiveMQId.get()).build();
    }
}

