/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.codec.decoder;

import com.google.inject.Inject;
import com.hivemq.bootstrap.ClientConnectionContext;
import com.hivemq.bootstrap.ioc.lazysingleton.LazySingleton;
import com.hivemq.codec.decoder.mqtt3.Mqtt311ConnectDecoder;
import com.hivemq.codec.decoder.mqtt3.Mqtt31ConnectDecoder;
import com.hivemq.codec.decoder.mqtt5.Mqtt5ConnectDecoder;
import com.hivemq.configuration.HivemqId;
import com.hivemq.configuration.service.FullConfigurationService;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.extension.sdk.api.annotations.Nullable;
import com.hivemq.mqtt.handler.connack.MqttConnacker;
import com.hivemq.mqtt.message.ProtocolVersion;
import com.hivemq.mqtt.message.connect.CONNECT;
import com.hivemq.mqtt.message.reason.Mqtt5ConnAckReasonCode;
import com.hivemq.util.ClientIds;
import io.netty.buffer.ByteBuf;

@LazySingleton
public class MqttConnectDecoder {
    @NotNull
    private final MqttConnacker mqttConnacker;
    @NotNull
    private final Mqtt5ConnectDecoder mqtt5ConnectDecoder;
    @NotNull
    private final Mqtt311ConnectDecoder mqtt311ConnectDecoder;
    @NotNull
    private final Mqtt31ConnectDecoder mqtt31ConnectDecoder;

    @Inject
    public MqttConnectDecoder(@NotNull MqttConnacker mqttConnacker, @NotNull FullConfigurationService fullConfigurationService, @NotNull HivemqId hiveMQId, @NotNull ClientIds clientIds) {
        this.mqttConnacker = mqttConnacker;
        this.mqtt5ConnectDecoder = new Mqtt5ConnectDecoder(mqttConnacker, hiveMQId, clientIds, fullConfigurationService);
        this.mqtt311ConnectDecoder = new Mqtt311ConnectDecoder(mqttConnacker, clientIds, fullConfigurationService, hiveMQId);
        this.mqtt31ConnectDecoder = new Mqtt31ConnectDecoder(mqttConnacker, clientIds, fullConfigurationService, hiveMQId);
    }

    @Nullable
    public ProtocolVersion decodeProtocolVersion(@NotNull ClientConnectionContext clientConnectionContext, @NotNull ByteBuf buf) {
        ProtocolVersion protocolVersion;
        if (buf.readableBytes() < 2) {
            this.mqttConnacker.connackError(clientConnectionContext.getChannel(), "A client (IP: {}) connected with a packet without protocol version.", "Sent CONNECT without protocol version", Mqtt5ConnAckReasonCode.UNSUPPORTED_PROTOCOL_VERSION, "Sent CONNECT with invalid protocol name.");
            return null;
        }
        ByteBuf lengthLSBBuf = buf.slice(buf.readerIndex() + 1, 1);
        byte lengthLSB = lengthLSBBuf.readByte();
        switch (lengthLSB) {
            case 4: {
                if (buf.readableBytes() < 7) {
                    this.connackInvalidProtocolVersion(clientConnectionContext);
                    return null;
                }
                ByteBuf protocolVersionBuf = buf.slice(buf.readerIndex() + 6, 1);
                byte versionByte = protocolVersionBuf.readByte();
                if (versionByte == 5) {
                    protocolVersion = ProtocolVersion.MQTTv5;
                    break;
                }
                if (versionByte == 4) {
                    protocolVersion = ProtocolVersion.MQTTv3_1_1;
                    break;
                }
                this.connackInvalidProtocolVersion(clientConnectionContext);
                return null;
            }
            case 6: {
                protocolVersion = ProtocolVersion.MQTTv3_1;
                break;
            }
            default: {
                this.connackInvalidProtocolVersion(clientConnectionContext);
                return null;
            }
        }
        clientConnectionContext.setProtocolVersion(protocolVersion);
        clientConnectionContext.setConnectReceivedTimestamp(System.currentTimeMillis());
        return protocolVersion;
    }

    @Nullable
    public CONNECT decode(@NotNull ClientConnectionContext clientConnectionContext, @NotNull ByteBuf buf, byte fixedHeader) {
        ProtocolVersion protocolVersion = this.decodeProtocolVersion(clientConnectionContext, buf);
        if (protocolVersion == null) {
            return null;
        }
        if (protocolVersion == ProtocolVersion.MQTTv5) {
            return this.mqtt5ConnectDecoder.decode(clientConnectionContext, buf, fixedHeader);
        }
        if (protocolVersion == ProtocolVersion.MQTTv3_1_1) {
            return this.mqtt311ConnectDecoder.decode(clientConnectionContext, buf, fixedHeader);
        }
        return this.mqtt31ConnectDecoder.decode(clientConnectionContext, buf, fixedHeader);
    }

    private void connackInvalidProtocolVersion(@NotNull ClientConnectionContext clientConnectionContext) {
        this.mqttConnacker.connackError(clientConnectionContext.getChannel(), "A client (IP: {}) connected with an invalid protocol version.", "Sent CONNECT with an invalid protocol version", Mqtt5ConnAckReasonCode.UNSUPPORTED_PROTOCOL_VERSION, "Sent CONNECT with invalid protocol name.");
    }
}

