/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.codec.decoder;

import com.hivemq.bootstrap.ClientConnectionContext;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.extension.sdk.api.annotations.Nullable;
import com.hivemq.mqtt.message.Message;
import io.netty.buffer.ByteBuf;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class MqttDecoder<T extends Message> {
    private static final Logger log = LoggerFactory.getLogger(MqttDecoder.class);

    @Nullable
    public abstract T decode(@NotNull ClientConnectionContext var1, @NotNull ByteBuf var2, byte var3);

    protected boolean validateHeader(byte header) {
        return (header & 0xF) == 0;
    }

    protected static boolean isInvalidTopic(@NotNull ClientConnectionContext clientConnectionContext, @Nullable String topic) {
        if (topic == null || topic.isEmpty()) {
            if (log.isDebugEnabled()) {
                log.debug("A client (IP: {}) sent an empty topic. This is not allowed. Disconnecting client.", (Object)clientConnectionContext.getChannelIP().orElse("UNKNOWN"));
            }
            return true;
        }
        if (topic.contains("\u0000")) {
            if (log.isDebugEnabled()) {
                log.debug("A client (IP: {}) sent a topic which contained the Unicode null character (U+0000). This is not allowed. Disconnecting client.", (Object)clientConnectionContext.getChannelIP().orElse("UNKNOWN"));
            }
            return true;
        }
        return false;
    }
}

