/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.configuration.info;

import com.google.common.io.Files;
import com.hivemq.HiveMQServer;
import com.hivemq.configuration.info.SystemInformation;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.extension.sdk.api.annotations.Nullable;
import com.hivemq.util.ManifestUtils;
import java.io.File;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import oshi.SystemInfo;

public class SystemInformationImpl
implements SystemInformation {
    private static final Logger log = LoggerFactory.getLogger(SystemInformationImpl.class);
    public static final String DEVELOPMENT_VERSION = "Development Snapshot";
    @NotNull
    private File homeFolder;
    @NotNull
    private File configFolder;
    @NotNull
    private File logFolder;
    @NotNull
    private File dataFolder;
    @NotNull
    private File pluginFolder;
    @NotNull
    private String hivemqVersion;
    private final long runningSince;
    private final boolean embedded;
    private final int processorCount;
    private final boolean usePathOfRunningJar;

    public SystemInformationImpl() {
        this(false);
    }

    public SystemInformationImpl(boolean usePathOfRunningJar) {
        this(usePathOfRunningJar, false, null, null, null);
    }

    public SystemInformationImpl(boolean usePathOfRunningJar, boolean embedded, @Nullable File configFolder, @Nullable File dataFolder, @Nullable File pluginFolder) {
        this.usePathOfRunningJar = usePathOfRunningJar;
        this.embedded = embedded;
        this.configFolder = configFolder;
        this.dataFolder = dataFolder;
        this.pluginFolder = pluginFolder;
        this.runningSince = System.currentTimeMillis();
        this.processorCount = this.getPhysicalProcessorCount();
    }

    @Override
    public void init() {
        this.setHivemqVersion();
        this.setFolders();
    }

    private int getPhysicalProcessorCount() {
        int physicalProcessorCount;
        int runtimeProcessorCount = Runtime.getRuntime().availableProcessors();
        try {
            physicalProcessorCount = new SystemInfo().getHardware().getProcessor().getPhysicalProcessorCount();
        }
        catch (Exception e) {
            log.warn("No able to determine amount of physical cores, using available amount of cores reported by the JVM as fallback");
            if (log.isTraceEnabled()) {
                log.trace("Original Exception: ", (Throwable)e);
            }
            physicalProcessorCount = runtimeProcessorCount;
        }
        return Math.min(physicalProcessorCount, runtimeProcessorCount);
    }

    private void setFolders() {
        this.setHomeFolder();
        this.configFolder = Objects.requireNonNullElseGet(this.configFolder, () -> this.setUpHiveMQFolder("hivemq.config.folder", "HIVEMQ_CONFIG_FOLDER", "conf", false));
        this.logFolder = this.setUpHiveMQFolder("hivemq.log.folder", "HIVEMQ_LOG_FOLDER", "log", !this.embedded);
        System.setProperty("hivemq.log.folder", this.logFolder.getAbsolutePath());
        this.dataFolder = Objects.requireNonNullElseGet(this.dataFolder, () -> this.setUpHiveMQFolder("hivemq.data.folder", "HIVEMQ_DATA_FOLDER", "data", true));
        this.pluginFolder = Objects.requireNonNullElseGet(this.pluginFolder, () -> this.setUpHiveMQFolder("hivemq.extensions.folder", "HIVEMQ_EXTENSION_FOLDER", "extensions", !this.embedded));
    }

    private void setHivemqVersion() {
        this.hivemqVersion = ManifestUtils.getValueFromManifest(HiveMQServer.class, "HiveMQ-Version");
        if (this.hivemqVersion == null || this.hivemqVersion.length() < 1) {
            this.hivemqVersion = DEVELOPMENT_VERSION;
        }
        log.info("HiveMQ version: {}", (Object)this.hivemqVersion);
    }

    public void setHivemqVersion(String hivemqVersion) {
        this.hivemqVersion = hivemqVersion;
    }

    @Override
    @NotNull
    public String getHiveMQVersion() {
        return this.hivemqVersion;
    }

    @Override
    @NotNull
    public File getHiveMQHomeFolder() {
        return this.homeFolder;
    }

    @Override
    @NotNull
    public File getConfigFolder() {
        return this.configFolder;
    }

    @Override
    @NotNull
    public File getLogFolder() {
        return this.logFolder;
    }

    @Override
    @NotNull
    public File getDataFolder() {
        return this.dataFolder;
    }

    @Override
    @NotNull
    public File getExtensionsFolder() {
        return this.pluginFolder;
    }

    @Override
    public long getRunningSince() {
        return this.runningSince;
    }

    @NotNull
    private File findAbsoluteAndRelative(String fileLocation) {
        File file = new File(fileLocation);
        if (file.isAbsolute()) {
            return file;
        }
        return new File(this.getHiveMQHomeFolder(), fileLocation);
    }

    @NotNull
    private File setUpHiveMQFolder(String propertyName, String variableName, String defaultFolder, boolean createFolderIfNotExists) {
        boolean mkdirsResult;
        String folderName = this.getSystemPropertyOrEnvironmentVariable(propertyName, variableName);
        File folder = folderName != null ? this.findAbsoluteAndRelative(folderName) : this.findAbsoluteAndRelative(defaultFolder);
        if (createFolderIfNotExists && !folder.exists() && !(mkdirsResult = folder.mkdirs())) {
            log.warn("Not able to create folder {}, HiveMQ will behave unexpectedly!", (Object)folder);
        }
        return folder;
    }

    @Nullable
    private String getSystemPropertyOrEnvironmentVariable(String propertyName, String variableName) {
        String systemProperty = System.getProperty(propertyName);
        if (systemProperty != null) {
            return systemProperty;
        }
        String environmentVariable = System.getenv().get(variableName);
        return environmentVariable;
    }

    private void setHomeFolder() {
        String home = this.getSystemPropertyOrEnvironmentVariable("hivemq.home", "HIVEMQ_HOME");
        if (home != null) {
            this.homeFolder = this.findAbsoluteAndRelative(home);
            log.info("HiveMQ home directory: {}", (Object)this.homeFolder.getAbsolutePath());
            System.setProperty("hivemq.home", this.homeFolder.getAbsolutePath());
        } else if (this.usePathOfRunningJar) {
            this.usePathOfRunningJarAsHomeFolder();
        } else {
            this.useTemporaryHomeFolder();
        }
    }

    private void useTemporaryHomeFolder() {
        File tempDir = Files.createTempDir();
        tempDir.deleteOnExit();
        log.warn("No {} property or {} environment variable was set. Using a temporary directory ({}) HiveMQ will behave unexpectedly!", new Object[]{"hivemq.home", "HIVEMQ_HOME", tempDir.getAbsolutePath()});
        this.homeFolder = tempDir;
    }

    private void usePathOfRunningJarAsHomeFolder() {
        File pathOfRunningJar = this.getPathOfRunningJar();
        if (!this.embedded) {
            log.warn("No {} property or {} environment variable was set. Using {}", new Object[]{"hivemq.home", "HIVEMQ_HOME", pathOfRunningJar.getAbsolutePath()});
        }
        this.homeFolder = pathOfRunningJar;
    }

    @NotNull
    private File getPathOfRunningJar() {
        String decode = URLDecoder.decode(HiveMQServer.class.getProtectionDomain().getCodeSource().getLocation().getPath(), StandardCharsets.UTF_8);
        String path = decode.substring(0, decode.lastIndexOf(47) + 1);
        return new File(path);
    }

    @Override
    public int getProcessorCount() {
        return this.processorCount;
    }

    @Override
    public boolean isEmbedded() {
        return this.embedded;
    }
}

