/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.configuration.ioc;

import com.hivemq.configuration.info.SystemInformation;
import com.hivemq.configuration.reader.ConfigurationFile;
import java.io.File;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigurationFileProvider {
    private static final Logger log = LoggerFactory.getLogger(ConfigurationFileProvider.class);

    public static ConfigurationFile get(SystemInformation systemInformation) {
        File configFileFolder = systemInformation.getConfigFolder();
        boolean configFolderOk = ConfigurationFileProvider.checkConfigFolder(configFileFolder);
        File configFile = new File(configFileFolder, "config.xml");
        boolean configFileOk = false;
        if (configFolderOk) {
            configFileOk = ConfigurationFileProvider.configFileOk(configFile);
        }
        if (configFolderOk && configFileOk) {
            return new ConfigurationFile(configFile);
        }
        return new ConfigurationFile(null);
    }

    private static boolean configFileOk(File configFile) {
        boolean configFileOk = false;
        if (!configFile.exists()) {
            log.error("The configuration file {} does not exist. Using HiveMQ default config", (Object)configFile.getAbsolutePath());
        } else if (!configFile.isFile()) {
            log.error("The configuration file {} is not file. Using HiveMQ default config", (Object)configFile.getAbsolutePath());
        } else if (!configFile.canRead()) {
            log.error("The configuration file {} cannot be read by HiveMQ. Using HiveMQ default config", (Object)configFile.getAbsolutePath());
        } else {
            configFileOk = true;
            if (!configFile.canWrite()) {
                log.warn("The configuration file {} is read only and cannot be written by HiveMQ.", (Object)configFile.getAbsolutePath());
            }
        }
        return configFileOk;
    }

    private static boolean checkConfigFolder(File configFileFolder) {
        boolean configFolderOk = false;
        if (!configFileFolder.exists()) {
            log.error("The configuration file folder {} does not exist. Using HiveMQ default config", (Object)configFileFolder.getAbsolutePath());
        } else if (!configFileFolder.isDirectory()) {
            log.error("The configuration file folder {} is not a folder. Using HiveMQ default config", (Object)configFileFolder.getAbsolutePath());
        } else if (!configFileFolder.canRead()) {
            log.error("The configuration file folder {} cannot be read by HiveMQ. Using HiveMQ default config", (Object)configFileFolder.getAbsolutePath());
        } else {
            configFolderOk = true;
        }
        return configFolderOk;
    }
}

