/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.configuration.service.entity;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.hivemq.configuration.service.entity.Listener;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.extension.sdk.api.annotations.Nullable;
import java.util.ArrayList;
import java.util.List;

public class WebsocketListener
implements Listener {
    private int port;
    @NotNull
    private final String bindAddress;
    @NotNull
    private final String path;
    private final boolean allowExtensions;
    @NotNull
    private final List<String> subprotocols;
    @NotNull
    private final String name;

    protected WebsocketListener(int port, @NotNull String bindAddress, @NotNull String path, boolean allowExtensions, @NotNull List<String> subprotocols, @NotNull String name) {
        this.port = port;
        this.bindAddress = bindAddress;
        this.path = path;
        this.allowExtensions = allowExtensions;
        this.subprotocols = subprotocols;
        this.name = name;
    }

    @Override
    public int getPort() {
        return this.port;
    }

    @Override
    public void setPort(int port) {
        this.port = port;
    }

    @Override
    @NotNull
    public String getBindAddress() {
        return this.bindAddress;
    }

    @Override
    @NotNull
    public String readableName() {
        return "Websocket Listener";
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @NotNull
    public String getPath() {
        return this.path;
    }

    public boolean getAllowExtensions() {
        return this.allowExtensions;
    }

    @NotNull
    public List<String> getSubprotocols() {
        return this.subprotocols;
    }

    public static class Builder {
        @NotNull
        protected String path = "";
        @NotNull
        protected List<String> subprotocols = new ArrayList<String>();
        @Nullable
        protected String name;
        @Nullable
        protected Integer port;
        @Nullable
        protected String bindAddress;
        protected boolean allowExtensions;

        public Builder() {
            this.subprotocols.add("mqtt");
            this.allowExtensions = false;
        }

        @NotNull
        public Builder from(@NotNull WebsocketListener websocketListener) {
            this.port = websocketListener.getPort();
            this.bindAddress = websocketListener.getBindAddress();
            this.path = websocketListener.getPath();
            this.name = websocketListener.getName();
            this.allowExtensions = websocketListener.getAllowExtensions();
            this.subprotocols = new ArrayList<String>(websocketListener.getSubprotocols());
            return this;
        }

        @NotNull
        public Builder port(int port) {
            this.port = port;
            return this;
        }

        @NotNull
        public Builder bindAddress(@NotNull String bindAddress) {
            Preconditions.checkNotNull((Object)bindAddress);
            this.bindAddress = bindAddress;
            return this;
        }

        @NotNull
        public Builder path(@NotNull String path) {
            Preconditions.checkNotNull((Object)path);
            this.path = path;
            return this;
        }

        @NotNull
        public Builder name(@NotNull String name) {
            Preconditions.checkNotNull((Object)name);
            this.name = name;
            return this;
        }

        @NotNull
        public Builder allowExtensions(boolean allowExtensions) {
            this.allowExtensions = allowExtensions;
            return this;
        }

        @NotNull
        public Builder subprotocols(@NotNull List<String> subprotocols) {
            Preconditions.checkNotNull(subprotocols);
            this.subprotocols = ImmutableList.copyOf(subprotocols);
            return this;
        }

        @NotNull
        public WebsocketListener build() throws IllegalStateException {
            if (this.port == null) {
                throw new IllegalStateException("The port for a Websocket listener was not set.");
            }
            if (this.bindAddress == null) {
                throw new IllegalStateException("The bind address for a Websocket listener was not set.");
            }
            if (this.name == null) {
                this.name = "websocket-listener-" + this.port;
            }
            return new WebsocketListener(this.port, this.bindAddress, this.path, this.allowExtensions, this.subprotocols, this.name);
        }
    }
}

