/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.extensions.auth;

import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.extension.sdk.api.annotations.Nullable;
import com.hivemq.extension.sdk.api.auth.EnhancedAuthenticator;
import com.hivemq.extension.sdk.api.auth.parameter.AuthenticatorProviderInput;
import com.hivemq.extensions.auth.AbstractAuthTask;
import com.hivemq.extensions.auth.AuthOutput;
import com.hivemq.extensions.client.ClientAuthenticators;
import com.hivemq.extensions.executor.task.PluginTaskInput;
import com.hivemq.extensions.services.auth.WrappedAuthenticatorProvider;

abstract class AbstractEnhancedAuthTask<I extends PluginTaskInput, O extends AuthOutput<?>>
extends AbstractAuthTask<I, O> {
    @NotNull
    private final ClientAuthenticators clientAuthenticators;

    AbstractEnhancedAuthTask(@NotNull WrappedAuthenticatorProvider wrappedAuthenticatorProvider, @NotNull AuthenticatorProviderInput authenticatorProviderInput, @NotNull String extensionId, @NotNull ClientAuthenticators clientAuthenticators) {
        super(wrappedAuthenticatorProvider, authenticatorProviderInput, extensionId);
        this.clientAuthenticators = clientAuthenticators;
    }

    @Override
    void call(@NotNull I input, @NotNull O output) {
        EnhancedAuthenticator authenticator = this.updateAndGetAuthenticator();
        if (authenticator != null) {
            ((AuthOutput)output).setAuthenticatorPresent();
            this.call(authenticator, input, output);
        }
    }

    abstract void call(@NotNull EnhancedAuthenticator var1, @NotNull I var2, @NotNull O var3);

    @Nullable
    EnhancedAuthenticator updateAndGetAuthenticator() {
        EnhancedAuthenticator authenticator = this.clientAuthenticators.getAuthenticatorMap().get(this.extensionId);
        if (authenticator != null && authenticator.getClass().getClassLoader().equals(this.wrappedAuthenticatorProvider.getClassLoader())) {
            return authenticator;
        }
        EnhancedAuthenticator newAuthenticator = this.wrappedAuthenticatorProvider.getEnhancedAuthenticator(this.authenticatorProviderInput);
        if (newAuthenticator != null) {
            this.clientAuthenticators.put(this.extensionId, newAuthenticator);
            return newAuthenticator;
        }
        return null;
    }
}

