/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.extensions.client;

import com.google.common.collect.ImmutableMap;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.extension.sdk.api.auth.EnhancedAuthenticator;
import com.hivemq.extensions.ExtensionPriorityComparator;
import com.hivemq.extensions.classloader.IsolatedExtensionClassloader;
import com.hivemq.extensions.client.ClientAuthenticators;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class ClientAuthenticatorsImpl
implements ClientAuthenticators {
    @NotNull
    private final ReadWriteLock authenticatorLock;
    @NotNull
    private final Map<String, EnhancedAuthenticator> enhancedAuthenticatorMap;

    public ClientAuthenticatorsImpl(@NotNull ExtensionPriorityComparator extensionPriorityComparator) {
        this.enhancedAuthenticatorMap = new TreeMap<String, EnhancedAuthenticator>(extensionPriorityComparator);
        this.authenticatorLock = new ReentrantReadWriteLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(@NotNull String pluginId, @NotNull EnhancedAuthenticator authenticator) {
        Lock lock = this.authenticatorLock.writeLock();
        lock.lock();
        try {
            this.enhancedAuthenticatorMap.put(pluginId, authenticator);
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public void removeForExtension(@NotNull IsolatedExtensionClassloader pluginClassLoader) {
        Lock lock = this.authenticatorLock.writeLock();
        lock.lock();
        try {
            this.enhancedAuthenticatorMap.entrySet().removeIf(next -> ((EnhancedAuthenticator)next.getValue()).getClass().getClassLoader().equals(pluginClassLoader));
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    @NotNull
    public Map<String, EnhancedAuthenticator> getAuthenticatorMap() {
        Lock lock = this.authenticatorLock.readLock();
        lock.lock();
        try {
            ImmutableMap immutableMap = ImmutableMap.copyOf(this.enhancedAuthenticatorMap);
            return immutableMap;
        }
        finally {
            lock.unlock();
        }
    }
}

