/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.extensions.events;

import com.hivemq.extension.sdk.api.annotations.Nullable;
import com.hivemq.extension.sdk.api.packets.general.DisconnectedReasonCode;
import com.hivemq.extensions.packets.general.UserPropertiesImpl;
import com.hivemq.mqtt.message.disconnect.DISCONNECT;
import com.hivemq.mqtt.message.mqtt5.Mqtt5UserProperties;
import com.hivemq.mqtt.message.reason.Mqtt5DisconnectReasonCode;

public class OnServerDisconnectEvent {
    @Nullable
    private final DisconnectedReasonCode reasonCode;
    @Nullable
    private final String reasonString;
    @Nullable
    private final UserPropertiesImpl userProperties;

    public OnServerDisconnectEvent(@Nullable DisconnectedReasonCode reasonCode, @Nullable String reasonString, @Nullable Mqtt5UserProperties userProperties) {
        this.reasonCode = reasonCode;
        this.reasonString = reasonString;
        this.userProperties = userProperties == null ? null : UserPropertiesImpl.of(userProperties.asList());
    }

    public OnServerDisconnectEvent(@Nullable DISCONNECT disconnect) {
        if (disconnect != null) {
            this.reasonCode = ((Mqtt5DisconnectReasonCode)disconnect.getReasonCode()).toDisconnectedReasonCode();
            this.reasonString = disconnect.getReasonString();
            this.userProperties = UserPropertiesImpl.of(disconnect.getUserProperties().asList());
        } else {
            this.reasonCode = null;
            this.reasonString = null;
            this.userProperties = null;
        }
    }

    @Nullable
    public DisconnectedReasonCode getReasonCode() {
        return this.reasonCode;
    }

    @Nullable
    public String getReasonString() {
        return this.reasonString;
    }

    @Nullable
    public UserPropertiesImpl getUserProperties() {
        return this.userProperties;
    }
}

