/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.extensions.events.client.parameters;

import com.google.common.collect.ImmutableMap;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.extension.sdk.api.events.client.ClientLifecycleEventListener;
import com.hivemq.extensions.ExtensionPriorityComparator;
import com.hivemq.extensions.HiveMQExtensions;
import com.hivemq.extensions.classloader.IsolatedExtensionClassloader;
import java.util.ArrayList;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class ClientEventListeners {
    @NotNull
    private final Map<String, ClientLifecycleEventListener> pluginEventListenersMap;
    @NotNull
    private final ReadWriteLock readWriteLock;

    public ClientEventListeners(@NotNull HiveMQExtensions hiveMQExtensions) {
        this.pluginEventListenersMap = new TreeMap<String, ClientLifecycleEventListener>(new ExtensionPriorityComparator(hiveMQExtensions));
        this.readWriteLock = new ReentrantReadWriteLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(@NotNull String pluginId, @NotNull ClientLifecycleEventListener eventListener) {
        Lock lock = this.readWriteLock.writeLock();
        lock.lock();
        try {
            this.pluginEventListenersMap.put(pluginId, eventListener);
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeForPlugin(@NotNull IsolatedExtensionClassloader pluginClassLoader) {
        Lock lock = this.readWriteLock.writeLock();
        lock.lock();
        try {
            ArrayList<String> keysToRemove = new ArrayList<String>();
            for (Map.Entry<String, ClientLifecycleEventListener> entry : this.pluginEventListenersMap.entrySet()) {
                if (!entry.getValue().getClass().getClassLoader().equals(pluginClassLoader)) continue;
                keysToRemove.add(entry.getKey());
            }
            for (String key : keysToRemove) {
                this.pluginEventListenersMap.remove(key);
            }
        }
        finally {
            lock.unlock();
        }
    }

    @NotNull
    public Map<String, ClientLifecycleEventListener> getPluginEventListenersMap() {
        Lock lock = this.readWriteLock.readLock();
        lock.lock();
        try {
            ImmutableMap immutableMap = ImmutableMap.copyOf(this.pluginEventListenersMap);
            return immutableMap;
        }
        finally {
            lock.unlock();
        }
    }
}

