/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.extensions.executor.task;

import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.extension.sdk.api.annotations.Nullable;
import com.hivemq.extensions.executor.task.PluginTask;
import com.hivemq.extensions.executor.task.PluginTaskContext;
import com.hivemq.extensions.executor.task.PluginTaskInput;
import com.hivemq.extensions.executor.task.PluginTaskOutput;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;

public class PluginTaskExecution<I extends PluginTaskInput, O extends PluginTaskOutput> {
    @NotNull
    private final PluginTaskContext pluginInOutContext;
    @Nullable
    private final Supplier<I> pluginInputSupplier;
    @Nullable
    private final Supplier<O> pluginOutputSupplier;
    @NotNull
    private final PluginTask pluginTask;
    @Nullable
    private O output;
    @Nullable
    private I input;
    @NotNull
    private final AtomicBoolean async = new AtomicBoolean(false);
    @NotNull
    private final AtomicBoolean done = new AtomicBoolean(false);

    public PluginTaskExecution(@NotNull PluginTaskContext pluginInOutContext, @Nullable Supplier<I> pluginInputSupplier, @Nullable Supplier<O> pluginOutputSupplier, @NotNull PluginTask pluginTask) {
        this.pluginInOutContext = pluginInOutContext;
        this.pluginInputSupplier = pluginInputSupplier;
        this.pluginOutputSupplier = pluginOutputSupplier;
        this.pluginTask = pluginTask;
    }

    @NotNull
    public PluginTaskContext getPluginContext() {
        return this.pluginInOutContext;
    }

    @NotNull
    public PluginTask getPluginTask() {
        return this.pluginTask;
    }

    public boolean isAsync() {
        return this.async.get();
    }

    public boolean isDone() {
        return this.done.get();
    }

    public void markAsAsync() {
        this.async.set(true);
    }

    public void markAsDone() {
        this.done.set(true);
    }

    @Nullable
    public O getOutputObject() {
        if (this.output == null && this.pluginOutputSupplier != null) {
            this.output = (PluginTaskOutput)this.pluginOutputSupplier.get();
        }
        return this.output;
    }

    @Nullable
    public I getInputObject() {
        if (this.input == null && this.pluginInputSupplier != null) {
            this.input = (PluginTaskInput)this.pluginInputSupplier.get();
        }
        return this.input;
    }

    public void setOutputObject(@NotNull O output) {
        this.output = output;
    }
}

