/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.extensions.handler;

import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.SettableFuture;
import com.hivemq.bootstrap.ClientConnection;
import com.hivemq.bootstrap.ClientConnectionContext;
import com.hivemq.configuration.service.InternalConfigurations;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.extension.sdk.api.auth.parameter.AuthorizerProviderInput;
import com.hivemq.extension.sdk.api.client.parameter.ServerInformation;
import com.hivemq.extension.sdk.api.services.auth.provider.AuthorizerProvider;
import com.hivemq.extensions.ExtensionPriorityComparator;
import com.hivemq.extensions.HiveMQExtensions;
import com.hivemq.extensions.auth.parameter.AuthorizerProviderInputImpl;
import com.hivemq.extensions.auth.parameter.PublishAuthorizerInputImpl;
import com.hivemq.extensions.auth.parameter.PublishAuthorizerOutputImpl;
import com.hivemq.extensions.auth.parameter.SubscriptionAuthorizerInputImpl;
import com.hivemq.extensions.auth.parameter.SubscriptionAuthorizerOutputImpl;
import com.hivemq.extensions.client.ClientAuthorizers;
import com.hivemq.extensions.client.ClientAuthorizersImpl;
import com.hivemq.extensions.executor.PluginOutPutAsyncer;
import com.hivemq.extensions.executor.PluginTaskExecutorService;
import com.hivemq.extensions.handler.PluginAuthorizerService;
import com.hivemq.extensions.handler.tasks.AllTopicsProcessedTask;
import com.hivemq.extensions.handler.tasks.PublishAuthorizationProcessedTask;
import com.hivemq.extensions.handler.tasks.PublishAuthorizerContext;
import com.hivemq.extensions.handler.tasks.PublishAuthorizerResult;
import com.hivemq.extensions.handler.tasks.PublishAuthorizerTask;
import com.hivemq.extensions.handler.tasks.SubscriptionAuthorizerContext;
import com.hivemq.extensions.handler.tasks.SubscriptionAuthorizerTask;
import com.hivemq.extensions.handler.tasks.WillPublishAuthorizationProcessedTask;
import com.hivemq.extensions.packets.general.UserPropertiesImpl;
import com.hivemq.extensions.services.auth.Authorizers;
import com.hivemq.mqtt.handler.disconnect.MqttServerDisconnector;
import com.hivemq.mqtt.handler.publish.IncomingPublishService;
import com.hivemq.mqtt.handler.subscribe.IncomingSubscribeService;
import com.hivemq.mqtt.message.connect.CONNECT;
import com.hivemq.mqtt.message.publish.PUBLISH;
import com.hivemq.mqtt.message.reason.Mqtt5DisconnectReasonCode;
import com.hivemq.mqtt.message.subscribe.SUBSCRIBE;
import com.hivemq.mqtt.message.subscribe.Topic;
import com.hivemq.util.Topics;
import io.netty.channel.ChannelHandlerContext;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.Executor;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class PluginAuthorizerServiceImpl
implements PluginAuthorizerService {
    @NotNull
    private final Authorizers authorizers;
    @NotNull
    private final PluginOutPutAsyncer asyncer;
    @NotNull
    private final PluginTaskExecutorService pluginTaskExecutorService;
    @NotNull
    private final ServerInformation serverInformation;
    @NotNull
    private final MqttServerDisconnector mqttServerDisconnector;
    @NotNull
    private final ExtensionPriorityComparator extensionPriorityComparator;
    @NotNull
    private final IncomingPublishService incomingPublishService;
    @NotNull
    private final IncomingSubscribeService incomingSubscribeService;
    private final boolean allowDollarTopics;

    @Inject
    public PluginAuthorizerServiceImpl(@NotNull Authorizers authorizers, @NotNull PluginOutPutAsyncer asyncer, @NotNull PluginTaskExecutorService pluginTaskExecutorService, @NotNull ServerInformation serverInformation, @NotNull HiveMQExtensions hiveMQExtensions, @NotNull MqttServerDisconnector mqttServerDisconnector, @NotNull IncomingPublishService incomingPublishService, @NotNull IncomingSubscribeService incomingSubscribeService) {
        this.authorizers = authorizers;
        this.asyncer = asyncer;
        this.pluginTaskExecutorService = pluginTaskExecutorService;
        this.serverInformation = serverInformation;
        this.incomingPublishService = incomingPublishService;
        this.mqttServerDisconnector = mqttServerDisconnector;
        this.extensionPriorityComparator = new ExtensionPriorityComparator(hiveMQExtensions);
        this.incomingSubscribeService = incomingSubscribeService;
        this.allowDollarTopics = InternalConfigurations.MQTT_ALLOW_DOLLAR_TOPICS.get();
    }

    @Override
    public void authorizePublish(@NotNull ChannelHandlerContext ctx, @NotNull PUBLISH msg) {
        if (!Topics.isValidTopicToPublish(msg.getTopic())) {
            this.disconnectWithReasonCode(ctx, "an invalid topic ('" + msg.getTopic() + "')", "an invalid topic");
            return;
        }
        if (!this.allowDollarTopics && Topics.isDollarTopic(msg.getTopic())) {
            String reason = "a topic that starts with '$'";
            this.disconnectWithReasonCode(ctx, "a topic that starts with '$' ('" + msg.getTopic() + "')", "a topic that starts with '$'");
            return;
        }
        String clientId = ClientConnection.of(ctx.channel()).getClientId();
        if (clientId == null) {
            this.incomingPublishService.processPublish(ctx, msg, null);
            return;
        }
        if (!this.authorizers.areAuthorizersAvailable()) {
            this.incomingPublishService.processPublish(ctx, msg, null);
            return;
        }
        Map<String, AuthorizerProvider> providerMap = this.authorizers.getAuthorizerProviderMap();
        if (providerMap.isEmpty()) {
            this.incomingPublishService.processPublish(ctx, msg, null);
            return;
        }
        ClientAuthorizers clientAuthorizers = this.getClientAuthorizers(ctx);
        AuthorizerProviderInputImpl authorizerProviderInput = new AuthorizerProviderInputImpl(ctx.channel(), this.serverInformation, clientId);
        PublishAuthorizerInputImpl input = new PublishAuthorizerInputImpl(msg, ctx.channel(), clientId);
        PublishAuthorizerOutputImpl output = new PublishAuthorizerOutputImpl(this.asyncer);
        SettableFuture<PublishAuthorizerOutputImpl> publishProcessedFuture = this.executePublishAuthorizer(clientId, providerMap, clientAuthorizers, authorizerProviderInput, input, output, ctx);
        Futures.addCallback(publishProcessedFuture, (FutureCallback)new PublishAuthorizationProcessedTask(msg, ctx, this.mqttServerDisconnector, this.incomingPublishService), (Executor)MoreExecutors.directExecutor());
    }

    @Override
    public void authorizeWillPublish(@NotNull ChannelHandlerContext ctx, @NotNull CONNECT connect) {
        String clientId = ClientConnectionContext.of(ctx.channel()).getClientId();
        if (clientId == null || !ctx.channel().isActive()) {
            return;
        }
        if (!this.authorizers.areAuthorizersAvailable() || connect.getWillPublish() == null) {
            ctx.pipeline().fireUserEventTriggered((Object)new AuthorizeWillResultEvent(connect, new PublishAuthorizerResult(null, null, false)));
            return;
        }
        Map<String, AuthorizerProvider> providerMap = this.authorizers.getAuthorizerProviderMap();
        if (providerMap.isEmpty()) {
            ctx.pipeline().fireUserEventTriggered((Object)new AuthorizeWillResultEvent(connect, new PublishAuthorizerResult(null, null, false)));
            return;
        }
        ClientAuthorizers clientAuthorizers = this.getClientAuthorizers(ctx);
        AuthorizerProviderInputImpl authorizerProviderInput = new AuthorizerProviderInputImpl(ctx.channel(), this.serverInformation, clientId);
        PublishAuthorizerInputImpl input = new PublishAuthorizerInputImpl(connect.getWillPublish(), ctx.channel(), clientId);
        PublishAuthorizerOutputImpl output = new PublishAuthorizerOutputImpl(this.asyncer);
        SettableFuture<PublishAuthorizerOutputImpl> publishProcessedFuture = this.executePublishAuthorizer(clientId, providerMap, clientAuthorizers, authorizerProviderInput, input, output, ctx);
        Futures.addCallback(publishProcessedFuture, (FutureCallback)new WillPublishAuthorizationProcessedTask(connect, ctx), (Executor)MoreExecutors.directExecutor());
    }

    @NotNull
    private SettableFuture<PublishAuthorizerOutputImpl> executePublishAuthorizer(@NotNull String clientId, @NotNull Map<String, AuthorizerProvider> providerMap, @NotNull ClientAuthorizers clientAuthorizers, @NotNull AuthorizerProviderInput authorizerProviderInput, @NotNull PublishAuthorizerInputImpl input, @NotNull PublishAuthorizerOutputImpl output, @NotNull ChannelHandlerContext ctx) {
        SettableFuture publishProcessedFuture = SettableFuture.create();
        PublishAuthorizerContext context = new PublishAuthorizerContext(clientId, output, (SettableFuture<PublishAuthorizerOutputImpl>)publishProcessedFuture, providerMap.size(), ctx);
        for (Map.Entry<String, AuthorizerProvider> entry : providerMap.entrySet()) {
            PublishAuthorizerTask task = new PublishAuthorizerTask(entry.getValue(), entry.getKey(), authorizerProviderInput, clientAuthorizers, ctx);
            this.pluginTaskExecutorService.handlePluginInOutTaskExecution(context, input, output, task);
        }
        return publishProcessedFuture;
    }

    @Override
    public void authorizeSubscriptions(@NotNull ChannelHandlerContext ctx, @NotNull SUBSCRIBE msg) {
        ClientConnectionContext clientConnectionContext = ClientConnectionContext.of(ctx.channel());
        String clientId = clientConnectionContext.getClientId();
        if (clientId == null || !ctx.channel().isActive()) {
            return;
        }
        if (!this.authorizers.areAuthorizersAvailable()) {
            this.incomingSubscribeService.processSubscribe(ctx, msg, false);
            return;
        }
        Map<String, AuthorizerProvider> providerMap = this.authorizers.getAuthorizerProviderMap();
        if (providerMap.isEmpty()) {
            this.incomingSubscribeService.processSubscribe(ctx, msg, false);
            return;
        }
        ClientAuthorizers clientAuthorizers = this.getClientAuthorizers(ctx);
        ArrayList<ListenableFuture<SubscriptionAuthorizerOutputImpl>> listenableFutures = new ArrayList<ListenableFuture<SubscriptionAuthorizerOutputImpl>>();
        AuthorizerProviderInputImpl authorizerProviderInput = new AuthorizerProviderInputImpl(ctx.channel(), this.serverInformation, clientId);
        for (Topic topic : msg.getTopics()) {
            SubscriptionAuthorizerInputImpl input = new SubscriptionAuthorizerInputImpl(UserPropertiesImpl.of(msg.getUserProperties().asList()), topic, ctx.channel(), clientId);
            SubscriptionAuthorizerOutputImpl output = new SubscriptionAuthorizerOutputImpl(this.asyncer);
            SettableFuture topicProcessedFuture = SettableFuture.create();
            listenableFutures.add((ListenableFuture<SubscriptionAuthorizerOutputImpl>)topicProcessedFuture);
            SubscriptionAuthorizerContext context = new SubscriptionAuthorizerContext(clientId, output, (SettableFuture<SubscriptionAuthorizerOutputImpl>)topicProcessedFuture, providerMap.size());
            for (Map.Entry<String, AuthorizerProvider> entry : providerMap.entrySet()) {
                SubscriptionAuthorizerTask task = new SubscriptionAuthorizerTask(entry.getValue(), entry.getKey(), authorizerProviderInput, clientAuthorizers);
                this.pluginTaskExecutorService.handlePluginInOutTaskExecution(context, input, output, task);
            }
        }
        AllTopicsProcessedTask allTopicsProcessedTask = new AllTopicsProcessedTask(msg, listenableFutures, ctx, this.mqttServerDisconnector, this.incomingSubscribeService);
        Futures.whenAllComplete(listenableFutures).run((Runnable)allTopicsProcessedTask, MoreExecutors.directExecutor());
    }

    @NotNull
    private ClientAuthorizers getClientAuthorizers(@NotNull ChannelHandlerContext ctx) {
        ClientConnectionContext clientConnectionContext = ClientConnectionContext.of(ctx.channel());
        if (clientConnectionContext.getExtensionClientAuthorizers() == null) {
            clientConnectionContext.setExtensionClientAuthorizers(new ClientAuthorizersImpl(this.extensionPriorityComparator));
        }
        return clientConnectionContext.getExtensionClientAuthorizers();
    }

    private void disconnectWithReasonCode(@NotNull ChannelHandlerContext ctx, @NotNull String logReason, @NotNull String reasonString) {
        if (ctx.channel().isActive()) {
            String logMessage = "Client (IP: {}) sent PUBLISH for " + logReason + ". This is not allowed. Disconnecting client.";
            String reasonMessage = "Sent PUBLISH for " + reasonString;
            this.mqttServerDisconnector.disconnect(ctx.channel(), logMessage, reasonMessage, Mqtt5DisconnectReasonCode.PROTOCOL_ERROR, reasonMessage);
            ctx.close();
        }
    }

    public static class AuthorizeWillResultEvent {
        @NotNull
        private final CONNECT connect;
        @NotNull
        private final PublishAuthorizerResult result;

        public AuthorizeWillResultEvent(@NotNull CONNECT connect, @NotNull PublishAuthorizerResult result) {
            this.connect = connect;
            this.result = result;
        }

        @NotNull
        public CONNECT getConnect() {
            return this.connect;
        }

        @NotNull
        public PublishAuthorizerResult getResult() {
            return this.result;
        }
    }
}

