/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.extensions.handler;

import com.hivemq.bootstrap.ClientConnection;
import com.hivemq.configuration.service.FullConfigurationService;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.extension.sdk.api.client.parameter.ClientInformation;
import com.hivemq.extension.sdk.api.client.parameter.ConnectionInformation;
import com.hivemq.extension.sdk.api.interceptor.pubrel.PubrelInboundInterceptor;
import com.hivemq.extension.sdk.api.interceptor.pubrel.PubrelOutboundInterceptor;
import com.hivemq.extension.sdk.api.interceptor.pubrel.parameter.PubrelInboundInput;
import com.hivemq.extension.sdk.api.interceptor.pubrel.parameter.PubrelInboundOutput;
import com.hivemq.extension.sdk.api.interceptor.pubrel.parameter.PubrelOutboundInput;
import com.hivemq.extension.sdk.api.interceptor.pubrel.parameter.PubrelOutboundOutput;
import com.hivemq.extensions.ExtensionInformationUtil;
import com.hivemq.extensions.HiveMQExtension;
import com.hivemq.extensions.HiveMQExtensions;
import com.hivemq.extensions.client.ClientContextImpl;
import com.hivemq.extensions.executor.PluginOutPutAsyncer;
import com.hivemq.extensions.executor.PluginTaskExecutorService;
import com.hivemq.extensions.executor.task.PluginInOutTask;
import com.hivemq.extensions.executor.task.PluginInOutTaskContext;
import com.hivemq.extensions.handler.ExtensionParameterHolder;
import com.hivemq.extensions.interceptor.pubrel.parameter.PubrelInboundInputImpl;
import com.hivemq.extensions.interceptor.pubrel.parameter.PubrelInboundOutputImpl;
import com.hivemq.extensions.interceptor.pubrel.parameter.PubrelOutboundInputImpl;
import com.hivemq.extensions.interceptor.pubrel.parameter.PubrelOutboundOutputImpl;
import com.hivemq.extensions.packets.pubrel.ModifiablePubrelPacketImpl;
import com.hivemq.extensions.packets.pubrel.PubrelPacketImpl;
import com.hivemq.mqtt.message.pubrel.PUBREL;
import com.hivemq.util.Exceptions;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class PubrelInterceptorHandler {
    private static final Logger log = LoggerFactory.getLogger(PubrelInterceptorHandler.class);
    @NotNull
    private final FullConfigurationService configurationService;
    @NotNull
    private final PluginOutPutAsyncer asyncer;
    @NotNull
    private final HiveMQExtensions hiveMQExtensions;
    @NotNull
    private final PluginTaskExecutorService executorService;

    @Inject
    public PubrelInterceptorHandler(@NotNull FullConfigurationService configurationService, @NotNull PluginOutPutAsyncer asyncer, @NotNull HiveMQExtensions hiveMQExtensions, @NotNull PluginTaskExecutorService executorService) {
        this.configurationService = configurationService;
        this.asyncer = asyncer;
        this.hiveMQExtensions = hiveMQExtensions;
        this.executorService = executorService;
    }

    public void handleInboundPubrel(@NotNull ChannelHandlerContext ctx, @NotNull PUBREL pubrel) {
        Channel channel = ctx.channel();
        ClientConnection clientConnection = ClientConnection.of(channel);
        String clientId = clientConnection.getClientId();
        if (clientId == null) {
            return;
        }
        ClientContextImpl clientContext = clientConnection.getExtensionClientContext();
        if (clientContext == null) {
            ctx.fireChannelRead((Object)pubrel);
            return;
        }
        List<PubrelInboundInterceptor> interceptors = clientContext.getPubrelInboundInterceptors();
        if (interceptors.isEmpty()) {
            ctx.fireChannelRead((Object)pubrel);
            return;
        }
        ClientInformation clientInfo = ExtensionInformationUtil.getAndSetClientInformation(channel, clientId);
        ConnectionInformation connectionInfo = ExtensionInformationUtil.getAndSetConnectionInformation(channel);
        PubrelPacketImpl packet = new PubrelPacketImpl(pubrel);
        PubrelInboundInputImpl input = new PubrelInboundInputImpl(clientInfo, connectionInfo, packet);
        ExtensionParameterHolder<PubrelInboundInputImpl> inputHolder = new ExtensionParameterHolder<PubrelInboundInputImpl>(input);
        ModifiablePubrelPacketImpl modifiablePacket = new ModifiablePubrelPacketImpl(packet, this.configurationService);
        PubrelInboundOutputImpl output = new PubrelInboundOutputImpl(this.asyncer, modifiablePacket);
        ExtensionParameterHolder<PubrelInboundOutputImpl> outputHolder = new ExtensionParameterHolder<PubrelInboundOutputImpl>(output);
        PubrelInboundInterceptorContext context = new PubrelInboundInterceptorContext(clientId, interceptors.size(), ctx, inputHolder, outputHolder);
        for (PubrelInboundInterceptor interceptor : interceptors) {
            HiveMQExtension extension = this.hiveMQExtensions.getExtensionForClassloader(interceptor.getClass().getClassLoader());
            if (extension == null) {
                context.finishInterceptor();
                continue;
            }
            PubrelInboundInterceptorTask task = new PubrelInboundInterceptorTask(interceptor, extension.getId());
            this.executorService.handlePluginInOutTaskExecution(context, inputHolder, outputHolder, task);
        }
    }

    public void handleOutboundPubrel(@NotNull ChannelHandlerContext ctx, @NotNull PUBREL pubrel, @NotNull ChannelPromise promise) {
        Channel channel = ctx.channel();
        ClientConnection clientConnection = ClientConnection.of(channel);
        String clientId = clientConnection.getClientId();
        if (clientId == null) {
            return;
        }
        ClientContextImpl clientContext = clientConnection.getExtensionClientContext();
        if (clientContext == null) {
            ctx.write((Object)pubrel, promise);
            return;
        }
        List<PubrelOutboundInterceptor> interceptors = clientContext.getPubrelOutboundInterceptors();
        if (interceptors.isEmpty()) {
            ctx.write((Object)pubrel, promise);
            return;
        }
        ClientInformation clientInfo = ExtensionInformationUtil.getAndSetClientInformation(channel, clientId);
        ConnectionInformation connectionInfo = ExtensionInformationUtil.getAndSetConnectionInformation(channel);
        PubrelPacketImpl packet = new PubrelPacketImpl(pubrel);
        PubrelOutboundInputImpl input = new PubrelOutboundInputImpl(clientInfo, connectionInfo, packet);
        ExtensionParameterHolder<PubrelOutboundInputImpl> inputHolder = new ExtensionParameterHolder<PubrelOutboundInputImpl>(input);
        ModifiablePubrelPacketImpl modifiablePacket = new ModifiablePubrelPacketImpl(packet, this.configurationService);
        PubrelOutboundOutputImpl output = new PubrelOutboundOutputImpl(this.asyncer, modifiablePacket);
        ExtensionParameterHolder<PubrelOutboundOutputImpl> outputHolder = new ExtensionParameterHolder<PubrelOutboundOutputImpl>(output);
        PubrelOutboundInterceptorContext context = new PubrelOutboundInterceptorContext(clientId, interceptors.size(), ctx, promise, inputHolder, outputHolder);
        for (PubrelOutboundInterceptor interceptor : interceptors) {
            HiveMQExtension extension = this.hiveMQExtensions.getExtensionForClassloader(interceptor.getClass().getClassLoader());
            if (extension == null) {
                context.finishInterceptor();
                continue;
            }
            PubrelOutboundInterceptorTask task = new PubrelOutboundInterceptorTask(interceptor, extension.getId());
            this.executorService.handlePluginInOutTaskExecution(context, inputHolder, outputHolder, task);
        }
    }

    private static class PubrelOutboundInterceptorTask
    implements PluginInOutTask<PubrelOutboundInputImpl, PubrelOutboundOutputImpl> {
        @NotNull
        private final PubrelOutboundInterceptor interceptor;
        @NotNull
        private final String extensionId;

        PubrelOutboundInterceptorTask(@NotNull PubrelOutboundInterceptor interceptor, @NotNull String extensionId) {
            this.interceptor = interceptor;
            this.extensionId = extensionId;
        }

        @Override
        @NotNull
        public PubrelOutboundOutputImpl apply(@NotNull PubrelOutboundInputImpl input, @NotNull PubrelOutboundOutputImpl output) {
            try {
                this.interceptor.onOutboundPubrel((PubrelOutboundInput)input, (PubrelOutboundOutput)output);
            }
            catch (Throwable e) {
                log.warn("Uncaught exception was thrown from extension with id \"{}\" on outbound PUBREL interception. Extensions are responsible for their own exception handling.", (Object)this.extensionId, (Object)e);
                output.markAsFailed();
                Exceptions.rethrowError(e);
            }
            return output;
        }

        @Override
        @NotNull
        public ClassLoader getPluginClassLoader() {
            return this.interceptor.getClass().getClassLoader();
        }
    }

    private static class PubrelOutboundInterceptorContext
    extends PluginInOutTaskContext<PubrelOutboundOutputImpl>
    implements Runnable {
        private final int interceptorCount;
        @NotNull
        private final AtomicInteger counter;
        @NotNull
        private final ChannelHandlerContext ctx;
        @NotNull
        private final ChannelPromise promise;
        @NotNull
        private final ExtensionParameterHolder<PubrelOutboundInputImpl> inputHolder;
        @NotNull
        private final ExtensionParameterHolder<PubrelOutboundOutputImpl> outputHolder;

        PubrelOutboundInterceptorContext(@NotNull String clientId, int interceptorCount, @NotNull ChannelHandlerContext ctx, @NotNull ChannelPromise promise, @NotNull ExtensionParameterHolder<PubrelOutboundInputImpl> inputHolder, @NotNull ExtensionParameterHolder<PubrelOutboundOutputImpl> outputHolder) {
            super(clientId);
            this.interceptorCount = interceptorCount;
            this.counter = new AtomicInteger(0);
            this.ctx = ctx;
            this.promise = promise;
            this.inputHolder = inputHolder;
            this.outputHolder = outputHolder;
        }

        @Override
        public void pluginPost(@NotNull PubrelOutboundOutputImpl output) {
            if (output.isTimedOut()) {
                log.debug("Async timeout on outbound PUBREL interception. Discarding changes made by the interceptor.");
            } else if (output.isFailed()) {
                log.debug("Exception on outbound PUBREL interception. Discarding changes made by the interceptor.");
            } else if (output.getPubrelPacket().isModified()) {
                this.inputHolder.set(this.inputHolder.get().update(output));
            }
            if (!this.finishInterceptor()) {
                this.outputHolder.set(output.update(this.inputHolder.get()));
            }
        }

        public boolean finishInterceptor() {
            if (this.counter.incrementAndGet() == this.interceptorCount) {
                this.ctx.executor().execute((Runnable)this);
                return true;
            }
            return false;
        }

        @Override
        public void run() {
            this.ctx.writeAndFlush((Object)PUBREL.from(this.inputHolder.get().getPubrelPacket()), this.promise);
        }
    }

    private static class PubrelInboundInterceptorTask
    implements PluginInOutTask<PubrelInboundInputImpl, PubrelInboundOutputImpl> {
        @NotNull
        private final PubrelInboundInterceptor interceptor;
        @NotNull
        private final String extensionId;

        PubrelInboundInterceptorTask(@NotNull PubrelInboundInterceptor interceptor, @NotNull String extensionId) {
            this.interceptor = interceptor;
            this.extensionId = extensionId;
        }

        @Override
        @NotNull
        public PubrelInboundOutputImpl apply(@NotNull PubrelInboundInputImpl input, @NotNull PubrelInboundOutputImpl output) {
            try {
                this.interceptor.onInboundPubrel((PubrelInboundInput)input, (PubrelInboundOutput)output);
            }
            catch (Throwable e) {
                log.warn("Uncaught exception was thrown from extension with id \"{}\" on inbound PUBREL interception. Extensions are responsible for their own exception handling.", (Object)this.extensionId, (Object)e);
                output.markAsFailed();
                Exceptions.rethrowError(e);
            }
            return output;
        }

        @Override
        @NotNull
        public ClassLoader getPluginClassLoader() {
            return this.interceptor.getClass().getClassLoader();
        }
    }

    private static class PubrelInboundInterceptorContext
    extends PluginInOutTaskContext<PubrelInboundOutputImpl>
    implements Runnable {
        private final int interceptorCount;
        @NotNull
        private final AtomicInteger counter;
        @NotNull
        private final ChannelHandlerContext ctx;
        @NotNull
        private final ExtensionParameterHolder<PubrelInboundInputImpl> inputHolder;
        @NotNull
        private final ExtensionParameterHolder<PubrelInboundOutputImpl> outputHolder;

        PubrelInboundInterceptorContext(@NotNull String clientId, int interceptorCount, @NotNull ChannelHandlerContext ctx, @NotNull ExtensionParameterHolder<PubrelInboundInputImpl> inputHolder, @NotNull ExtensionParameterHolder<PubrelInboundOutputImpl> outputHolder) {
            super(clientId);
            this.interceptorCount = interceptorCount;
            this.counter = new AtomicInteger(0);
            this.ctx = ctx;
            this.inputHolder = inputHolder;
            this.outputHolder = outputHolder;
        }

        @Override
        public void pluginPost(@NotNull PubrelInboundOutputImpl output) {
            if (output.isTimedOut()) {
                log.debug("Async timeout on inbound PUBREL interception. Discarding changes made by the interceptor.");
            } else if (output.isFailed()) {
                log.debug("Exception on inbound PUBREL interception. Discarding changes made by the interceptor.");
            } else if (output.getPubrelPacket().isModified()) {
                this.inputHolder.set(this.inputHolder.get().update(output));
            }
            if (!this.finishInterceptor()) {
                this.outputHolder.set(output.update(this.inputHolder.get()));
            }
        }

        public boolean finishInterceptor() {
            if (this.counter.incrementAndGet() == this.interceptorCount) {
                this.ctx.executor().execute((Runnable)this);
                return true;
            }
            return false;
        }

        @Override
        public void run() {
            this.ctx.fireChannelRead((Object)PUBREL.from(this.inputHolder.get().getPubrelPacket()));
        }
    }
}

