/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.extensions.handler.tasks;

import com.google.common.util.concurrent.FutureCallback;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.extension.sdk.api.annotations.Nullable;
import com.hivemq.extension.sdk.api.packets.publish.AckReasonCode;
import com.hivemq.extensions.auth.parameter.PublishAuthorizerOutputImpl;
import com.hivemq.extensions.handler.tasks.PublishAuthorizerResult;
import com.hivemq.mqtt.handler.disconnect.MqttServerDisconnector;
import com.hivemq.mqtt.handler.publish.IncomingPublishService;
import com.hivemq.mqtt.message.publish.PUBLISH;
import com.hivemq.mqtt.message.reason.Mqtt5DisconnectReasonCode;
import com.hivemq.util.Exceptions;
import io.netty.channel.ChannelHandlerContext;

public class PublishAuthorizationProcessedTask
implements FutureCallback<PublishAuthorizerOutputImpl> {
    @NotNull
    private final PUBLISH publish;
    @NotNull
    private final ChannelHandlerContext ctx;
    @NotNull
    private final MqttServerDisconnector mqttServerDisconnector;
    @NotNull
    private final IncomingPublishService incomingPublishService;

    public PublishAuthorizationProcessedTask(@NotNull PUBLISH publish, @NotNull ChannelHandlerContext ctx, @NotNull MqttServerDisconnector mqttServerDisconnector, @NotNull IncomingPublishService incomingPublishService) {
        this.publish = publish;
        this.ctx = ctx;
        this.mqttServerDisconnector = mqttServerDisconnector;
        this.incomingPublishService = incomingPublishService;
    }

    public void onSuccess(@Nullable PublishAuthorizerOutputImpl output) {
        if (output == null) {
            return;
        }
        AckReasonCode reasonCode = null;
        String reasonString = null;
        switch (output.getAuthorizationState()) {
            case DISCONNECT: {
                this.disconnectClient(output);
                return;
            }
            case FAIL: {
                reasonCode = output.getAckReasonCode() != null ? output.getAckReasonCode() : AckReasonCode.NOT_AUTHORIZED;
                reasonString = output.getReasonString() != null ? output.getReasonString() : this.getReasonString(this.publish);
                break;
            }
            case UNDECIDED: {
                if (!output.isAuthorizerPresent()) break;
                reasonCode = AckReasonCode.NOT_AUTHORIZED;
                reasonString = this.getReasonString(this.publish);
                break;
            }
            case SUCCESS: {
                reasonCode = AckReasonCode.SUCCESS;
                break;
            }
            case CONTINUE: {
                break;
            }
            default: {
                throw new IllegalStateException("Unknown type");
            }
        }
        AckReasonCode finalReasonCode = reasonCode;
        String finalReasonString = reasonString;
        this.ctx.executor().execute(() -> this.incomingPublishService.processPublish(this.ctx, this.publish, new PublishAuthorizerResult(finalReasonCode, finalReasonString, output.isAuthorizerPresent(), output.getDisconnectReasonCode())));
    }

    public void onFailure(@NotNull Throwable t) {
        Exceptions.rethrowError("Exception at PublishAuthorization", t);
        this.disconnectClient(null);
    }

    private void disconnectClient(@Nullable PublishAuthorizerOutputImpl output) {
        String logMessage = "A client (IP: {}) sent a PUBLISH to an unauthorized topic '" + this.publish.getTopic() + "'. Disconnecting client from extension.";
        String eventLogMessage = "Sent a PUBLISH to an unauthorized topic '" + this.publish.getTopic() + "', extension requested disconnect";
        this.ctx.channel().eventLoop().execute(() -> this.mqttServerDisconnector.disconnect(this.ctx.channel(), logMessage, eventLogMessage, output != null ? Mqtt5DisconnectReasonCode.from(output.getDisconnectReasonCode()) : Mqtt5DisconnectReasonCode.NOT_AUTHORIZED, output != null ? output.getReasonString() : null));
    }

    private String getReasonString(@NotNull PUBLISH publish) {
        return "Not authorized to publish on topic '" + publish.getTopic() + "' with QoS '" + publish.getQoS().getQosNumber() + "' and retain '" + publish.isRetain() + "'";
    }
}

