/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.extensions.handler.tasks;

import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.extension.sdk.api.annotations.Nullable;
import com.hivemq.extension.sdk.api.auth.Authorizer;
import com.hivemq.extension.sdk.api.auth.SubscriptionAuthorizer;
import com.hivemq.extension.sdk.api.auth.parameter.AuthorizerProviderInput;
import com.hivemq.extension.sdk.api.auth.parameter.SubscriptionAuthorizerInput;
import com.hivemq.extension.sdk.api.auth.parameter.SubscriptionAuthorizerOutput;
import com.hivemq.extension.sdk.api.services.auth.provider.AuthorizerProvider;
import com.hivemq.extensions.auth.parameter.SubscriptionAuthorizerInputImpl;
import com.hivemq.extensions.auth.parameter.SubscriptionAuthorizerOutputImpl;
import com.hivemq.extensions.client.ClientAuthorizers;
import com.hivemq.extensions.executor.task.PluginInOutTask;
import com.hivemq.util.Exceptions;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubscriptionAuthorizerTask
implements PluginInOutTask<SubscriptionAuthorizerInputImpl, SubscriptionAuthorizerOutputImpl> {
    private static final Logger log = LoggerFactory.getLogger(SubscriptionAuthorizerTask.class);
    @NotNull
    private final AuthorizerProvider authorizerProvider;
    @NotNull
    private final AuthorizerProviderInput authorizerProviderInput;
    @NotNull
    private final String pluginId;
    @NotNull
    private final ClientAuthorizers clientAuthorizers;

    public SubscriptionAuthorizerTask(@NotNull AuthorizerProvider authorizerProvider, @NotNull String pluginId, @NotNull AuthorizerProviderInput input, @NotNull ClientAuthorizers clientAuthorizers) {
        this.authorizerProvider = authorizerProvider;
        this.pluginId = pluginId;
        this.authorizerProviderInput = input;
        this.clientAuthorizers = clientAuthorizers;
    }

    @Override
    @NotNull
    public SubscriptionAuthorizerOutputImpl apply(@NotNull SubscriptionAuthorizerInputImpl input, @NotNull SubscriptionAuthorizerOutputImpl output) {
        if (output.isCompleted()) {
            return output;
        }
        SubscriptionAuthorizer authorizer = this.updateAndGetAuthorizer();
        if (authorizer == null) {
            return output;
        }
        try {
            output.authorizerPresent();
            authorizer.authorizeSubscribe((SubscriptionAuthorizerInput)input, (SubscriptionAuthorizerOutput)output);
        }
        catch (Throwable e) {
            log.warn("Uncaught exception was thrown from extension with id \"{}\" at subscription authorization. Extensions are responsible on their own to handle exceptions.", (Object)this.pluginId, (Object)e);
            Exceptions.rethrowError(e);
        }
        return output;
    }

    @Nullable
    private SubscriptionAuthorizer updateAndGetAuthorizer() {
        SubscriptionAuthorizer authorizer = null;
        for (Map.Entry<String, SubscriptionAuthorizer> authorizerEntry : this.clientAuthorizers.getSubscriptionAuthorizersMap().entrySet()) {
            String pluginId = authorizerEntry.getKey();
            SubscriptionAuthorizer subscriptionAuthorizer = authorizerEntry.getValue();
            if (!subscriptionAuthorizer.getClass().getClassLoader().equals(this.authorizerProvider.getClass().getClassLoader()) || !pluginId.equals(this.pluginId)) continue;
            authorizer = subscriptionAuthorizer;
        }
        if (authorizer == null) {
            try {
                Authorizer authorizerProvided = this.authorizerProvider.getAuthorizer(this.authorizerProviderInput);
                if (authorizerProvided instanceof SubscriptionAuthorizer) {
                    authorizer = (SubscriptionAuthorizer)authorizerProvided;
                    this.clientAuthorizers.put(this.pluginId, (Authorizer)authorizer);
                }
            }
            catch (Throwable t) {
                log.warn("Uncaught exception was thrown from extension with id \"{}\" in authorizer provider. Extensions are responsible on their own to handle exceptions.", (Object)this.pluginId, (Object)t);
                Exceptions.rethrowError(t);
            }
        }
        return authorizer;
    }

    @Override
    @NotNull
    public ClassLoader getPluginClassLoader() {
        return this.authorizerProvider.getClass().getClassLoader();
    }
}

