/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.extensions.loader;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.extensions.HiveMQExtensionEvent;
import com.hivemq.extensions.HiveMQExtensions;
import com.hivemq.extensions.ioc.annotation.PluginStartStop;
import com.hivemq.extensions.loader.ExtensionLifecycleHandler;
import java.util.Comparator;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class ExtensionLifecycleHandlerImpl
implements ExtensionLifecycleHandler {
    private static final Logger log = LoggerFactory.getLogger(ExtensionLifecycleHandlerImpl.class);
    @NotNull
    private final HiveMQExtensions hiveMQExtensions;
    @NotNull
    private final ExecutorService pluginStartStopExecutor;

    @Inject
    @VisibleForTesting
    public ExtensionLifecycleHandlerImpl(@NotNull HiveMQExtensions hiveMQExtensions, @PluginStartStop @NotNull ExecutorService pluginStartStopExecutor) {
        this.hiveMQExtensions = hiveMQExtensions;
        this.pluginStartStopExecutor = pluginStartStopExecutor;
    }

    @Override
    @NotNull
    public CompletableFuture<Void> handleExtensionEvents(ImmutableCollection<HiveMQExtensionEvent> hiveMQExtensionEvents) {
        ImmutableList<HiveMQExtensionEvent> sorted = this.analyzePluginEvents(hiveMQExtensionEvents);
        CompletionStage<Object> returnFuture = CompletableFuture.completedFuture(null);
        for (HiveMQExtensionEvent hiveMQExtensionEvent : sorted) {
            returnFuture = ((CompletableFuture)returnFuture.thenComposeAsync(v -> this.handlePluginEvent(hiveMQExtensionEvent), (Executor)this.pluginStartStopExecutor)).handle((v, t) -> {
                if (t != null) {
                    log.debug("Exception during Extension Lifecycle event handling", t);
                }
                return null;
            });
        }
        return returnFuture;
    }

    @NotNull
    private CompletableFuture<Boolean> handlePluginEvent(@NotNull HiveMQExtensionEvent hiveMQExtensionEvent) {
        switch (hiveMQExtensionEvent.getChange()) {
            case ENABLE: {
                return this.startPlugin(hiveMQExtensionEvent);
            }
            case DISABLE: {
                return this.stopPlugin(hiveMQExtensionEvent.getExtensionId(), hiveMQExtensionEvent.isEmbedded());
            }
        }
        return CompletableFuture.completedFuture(false);
    }

    @NotNull
    private CompletableFuture<Boolean> startPlugin(@NotNull HiveMQExtensionEvent pluginEvent) {
        String pluginId = pluginEvent.getExtensionId();
        log.debug("Starting {}extension with id \"{}\" at {}", new Object[]{pluginEvent.isEmbedded() ? "embedded " : "", pluginId, pluginEvent.getExtensionFolder()});
        return CompletableFuture.supplyAsync(() -> this.hiveMQExtensions.extensionStart(pluginId), this.pluginStartStopExecutor);
    }

    @NotNull
    private CompletableFuture<Boolean> stopPlugin(@NotNull String pluginId, boolean embedded) {
        log.debug("Stopping {}extension with id {}", (Object)(embedded ? "embedded " : ""), (Object)pluginId);
        return CompletableFuture.supplyAsync(() -> this.hiveMQExtensions.extensionStop(pluginId, false), this.pluginStartStopExecutor);
    }

    @NotNull
    private ImmutableList<HiveMQExtensionEvent> analyzePluginEvents(ImmutableCollection<HiveMQExtensionEvent> hiveMQExtensionEvents) {
        return ImmutableList.sortedCopyOf(Comparator.comparingInt(HiveMQExtensionEvent::getPriority).reversed(), hiveMQExtensionEvents);
    }
}

