/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.extensions.packets.connack;

import com.google.common.base.Preconditions;
import com.hivemq.configuration.service.FullConfigurationService;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.extension.sdk.api.annotations.Nullable;
import com.hivemq.extension.sdk.api.annotations.ThreadSafe;
import com.hivemq.extension.sdk.api.packets.connack.ModifiableConnackPacket;
import com.hivemq.extension.sdk.api.packets.connect.ConnackReasonCode;
import com.hivemq.extension.sdk.api.packets.general.Qos;
import com.hivemq.extensions.packets.connack.ConnackPacketImpl;
import com.hivemq.extensions.packets.general.ModifiableUserPropertiesImpl;
import com.hivemq.extensions.services.builder.PluginBuilderUtil;
import java.nio.ByteBuffer;
import java.util.Objects;
import java.util.Optional;

@ThreadSafe
public class ModifiableConnackPacketImpl
implements ModifiableConnackPacket {
    @NotNull
    private ConnackReasonCode reasonCode;
    private boolean sessionPresent;
    private final long sessionExpiryInterval;
    private final int serverKeepAlive;
    @Nullable
    private String assignedClientId;
    @Nullable
    private final String authenticationMethod;
    @Nullable
    private final ByteBuffer authenticationData;
    private final int receiveMaximum;
    private final int maximumPacketSize;
    private final int topicAliasMaximum;
    @Nullable
    private final Qos maximumQos;
    private final boolean retainAvailable;
    private final boolean wildCardSubscriptionAvailable;
    private final boolean sharedSubscriptionsAvailable;
    private final boolean subscriptionIdentifiersAvailable;
    @Nullable
    private String responseInformation;
    @Nullable
    private String serverReference;
    @Nullable
    private String reasonString;
    @NotNull
    private final ModifiableUserPropertiesImpl userProperties;
    @NotNull
    private final FullConfigurationService configurationService;
    private final boolean requestResponseInformation;
    private boolean modified = false;

    public ModifiableConnackPacketImpl(@NotNull ConnackPacketImpl packet, @NotNull FullConfigurationService configurationService, boolean requestResponseInformation) {
        this.reasonCode = packet.reasonCode;
        this.sessionPresent = packet.sessionPresent;
        this.sessionExpiryInterval = packet.sessionExpiryInterval;
        this.serverKeepAlive = packet.serverKeepAlive;
        this.assignedClientId = packet.assignedClientId;
        this.authenticationMethod = packet.authenticationMethod;
        this.authenticationData = packet.authenticationData;
        this.receiveMaximum = packet.receiveMaximum;
        this.maximumPacketSize = packet.maximumPacketSize;
        this.topicAliasMaximum = packet.topicAliasMaximum;
        this.maximumQos = packet.maximumQos;
        this.retainAvailable = packet.retainAvailable;
        this.wildCardSubscriptionAvailable = packet.wildCardSubscriptionAvailable;
        this.sharedSubscriptionsAvailable = packet.sharedSubscriptionsAvailable;
        this.subscriptionIdentifiersAvailable = packet.subscriptionIdentifiersAvailable;
        this.responseInformation = packet.responseInformation;
        this.serverReference = packet.serverReference;
        this.reasonString = packet.reasonString;
        this.userProperties = new ModifiableUserPropertiesImpl(packet.userProperties.asInternalList(), configurationService.securityConfiguration().validateUTF8());
        this.configurationService = configurationService;
        this.requestResponseInformation = requestResponseInformation;
    }

    @NotNull
    public ConnackReasonCode getReasonCode() {
        return this.reasonCode;
    }

    public void setReasonCode(@NotNull ConnackReasonCode reasonCode) {
        Preconditions.checkNotNull((Object)reasonCode, (Object)"Reason code must never be null");
        boolean switched = reasonCode == ConnackReasonCode.SUCCESS && this.reasonCode != ConnackReasonCode.SUCCESS || reasonCode != ConnackReasonCode.SUCCESS && this.reasonCode == ConnackReasonCode.SUCCESS;
        Preconditions.checkState((!switched ? 1 : 0) != 0, (Object)"Reason code must not switch from successful to unsuccessful or vice versa");
        if (this.reasonCode == reasonCode) {
            return;
        }
        this.reasonCode = reasonCode;
        this.modified = true;
    }

    public boolean getSessionPresent() {
        return this.sessionPresent;
    }

    @NotNull
    public Optional<Long> getSessionExpiryInterval() {
        if (this.sessionExpiryInterval == Long.MAX_VALUE) {
            return Optional.empty();
        }
        return Optional.of(this.sessionExpiryInterval);
    }

    @NotNull
    public Optional<Integer> getServerKeepAlive() {
        if (this.serverKeepAlive == -1) {
            return Optional.empty();
        }
        return Optional.of(this.serverKeepAlive);
    }

    @NotNull
    public Optional<String> getAssignedClientIdentifier() {
        return Optional.ofNullable(this.assignedClientId);
    }

    public void setAssignedClientIdentifier(@Nullable String assignedClientIdentifier) {
        PluginBuilderUtil.checkClientIdentifier(assignedClientIdentifier, this.configurationService.securityConfiguration().validateUTF8());
        if (Objects.equals(this.assignedClientId, assignedClientIdentifier)) {
            return;
        }
        this.assignedClientId = assignedClientIdentifier;
        this.modified = true;
    }

    public void setSessionPresent(boolean sessionPresent) {
        if (Objects.equals(this.sessionPresent, sessionPresent)) {
            return;
        }
        this.sessionPresent = sessionPresent;
        this.modified = true;
    }

    @NotNull
    public Optional<String> getAuthenticationMethod() {
        return Optional.ofNullable(this.authenticationMethod);
    }

    @NotNull
    public Optional<ByteBuffer> getAuthenticationData() {
        return this.authenticationData == null ? Optional.empty() : Optional.of(this.authenticationData.asReadOnlyBuffer());
    }

    public int getReceiveMaximum() {
        return this.receiveMaximum;
    }

    public int getMaximumPacketSize() {
        return this.maximumPacketSize;
    }

    public int getTopicAliasMaximum() {
        return this.topicAliasMaximum;
    }

    @NotNull
    public Optional<Qos> getMaximumQoS() {
        return Optional.ofNullable(this.maximumQos);
    }

    public boolean getRetainAvailable() {
        return this.retainAvailable;
    }

    public boolean getWildCardSubscriptionAvailable() {
        return this.wildCardSubscriptionAvailable;
    }

    public boolean getSharedSubscriptionsAvailable() {
        return this.sharedSubscriptionsAvailable;
    }

    public boolean getSubscriptionIdentifiersAvailable() {
        return this.subscriptionIdentifiersAvailable;
    }

    @NotNull
    public Optional<String> getResponseInformation() {
        return Optional.ofNullable(this.responseInformation);
    }

    public void setResponseInformation(@Nullable String responseInformation) {
        PluginBuilderUtil.checkResponseInformation(responseInformation, this.requestResponseInformation, this.configurationService.securityConfiguration().validateUTF8());
        if (Objects.equals(this.responseInformation, responseInformation)) {
            return;
        }
        this.responseInformation = responseInformation;
        this.modified = true;
    }

    @NotNull
    public Optional<String> getServerReference() {
        return Optional.ofNullable(this.serverReference);
    }

    public void setServerReference(@Nullable String serverReference) {
        PluginBuilderUtil.checkServerReference(serverReference, this.configurationService.securityConfiguration().validateUTF8());
        if (Objects.equals(this.serverReference, serverReference)) {
            return;
        }
        this.serverReference = serverReference;
        this.modified = true;
    }

    @NotNull
    public Optional<String> getReasonString() {
        return Optional.ofNullable(this.reasonString);
    }

    public void setReasonString(@Nullable String reasonString) {
        if (reasonString != null) {
            Preconditions.checkState((this.reasonCode != ConnackReasonCode.SUCCESS ? 1 : 0) != 0, (Object)"Reason string must not be set when reason code is successful");
        }
        PluginBuilderUtil.checkReasonString(reasonString, this.configurationService.securityConfiguration().validateUTF8());
        if (Objects.equals(this.reasonString, reasonString)) {
            return;
        }
        this.reasonString = reasonString;
        this.modified = true;
    }

    @NotNull
    public ModifiableUserPropertiesImpl getUserProperties() {
        return this.userProperties;
    }

    public boolean isModified() {
        return this.modified || this.userProperties.isModified();
    }

    @NotNull
    public ConnackPacketImpl copy() {
        return new ConnackPacketImpl(this.reasonCode, this.sessionPresent, this.sessionExpiryInterval, this.serverKeepAlive, this.assignedClientId, this.authenticationMethod, this.authenticationData, this.receiveMaximum, this.maximumPacketSize, this.topicAliasMaximum, this.maximumQos, this.retainAvailable, this.wildCardSubscriptionAvailable, this.sharedSubscriptionsAvailable, this.subscriptionIdentifiersAvailable, this.responseInformation, this.serverReference, this.reasonString, this.userProperties.copy());
    }

    @NotNull
    public ModifiableConnackPacketImpl update(@NotNull ConnackPacketImpl packet) {
        return new ModifiableConnackPacketImpl(packet, this.configurationService, this.requestResponseInformation);
    }
}

