/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.extensions.packets.puback;

import com.google.common.base.Preconditions;
import com.hivemq.configuration.service.FullConfigurationService;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.extension.sdk.api.annotations.Nullable;
import com.hivemq.extension.sdk.api.packets.puback.ModifiablePubackPacket;
import com.hivemq.extension.sdk.api.packets.publish.AckReasonCode;
import com.hivemq.extensions.packets.general.ModifiableUserPropertiesImpl;
import com.hivemq.extensions.packets.puback.PubackPacketImpl;
import com.hivemq.extensions.services.builder.PluginBuilderUtil;
import com.hivemq.mqtt.message.reason.Mqtt5PubAckReasonCode;
import java.util.Objects;
import java.util.Optional;

public class ModifiablePubackPacketImpl
implements ModifiablePubackPacket {
    private final int packetIdentifier;
    @NotNull
    private AckReasonCode reasonCode;
    @Nullable
    private String reasonString;
    @NotNull
    private final ModifiableUserPropertiesImpl userProperties;
    @NotNull
    private final FullConfigurationService configurationService;
    private boolean modified = false;

    public ModifiablePubackPacketImpl(@NotNull PubackPacketImpl packet, @NotNull FullConfigurationService configurationService) {
        this.packetIdentifier = packet.packetIdentifier;
        this.reasonCode = packet.reasonCode;
        this.reasonString = packet.reasonString;
        this.userProperties = new ModifiableUserPropertiesImpl(packet.userProperties.asInternalList(), configurationService.securityConfiguration().validateUTF8());
        this.configurationService = configurationService;
    }

    public int getPacketIdentifier() {
        return this.packetIdentifier;
    }

    @NotNull
    public AckReasonCode getReasonCode() {
        return this.reasonCode;
    }

    public void setReasonCode(@NotNull AckReasonCode reasonCode) {
        Preconditions.checkNotNull((Object)reasonCode, (Object)"Reason code must never be null");
        if (this.reasonCode == reasonCode) {
            return;
        }
        Mqtt5PubAckReasonCode newReasonCode = Mqtt5PubAckReasonCode.from(reasonCode);
        Mqtt5PubAckReasonCode oldReasonCode = Mqtt5PubAckReasonCode.from(this.reasonCode);
        boolean switched = newReasonCode.isError() != oldReasonCode.isError();
        Preconditions.checkState((!switched ? 1 : 0) != 0, (Object)"Reason code must not switch from successful to unsuccessful or vice versa");
        this.reasonCode = reasonCode;
        this.modified = true;
    }

    @NotNull
    public Optional<String> getReasonString() {
        return Optional.ofNullable(this.reasonString);
    }

    public void setReasonString(@Nullable String reasonString) {
        PluginBuilderUtil.checkReasonString(reasonString, this.configurationService.securityConfiguration().validateUTF8());
        if (Objects.equals(this.reasonString, reasonString)) {
            return;
        }
        this.reasonString = reasonString;
        this.modified = true;
    }

    @NotNull
    public ModifiableUserPropertiesImpl getUserProperties() {
        return this.userProperties;
    }

    public boolean isModified() {
        return this.modified || this.userProperties.isModified();
    }

    @NotNull
    public PubackPacketImpl copy() {
        return new PubackPacketImpl(this.packetIdentifier, this.reasonCode, this.reasonString, this.userProperties.copy());
    }

    @NotNull
    public ModifiablePubackPacketImpl update(@NotNull PubackPacketImpl packet) {
        return new ModifiablePubackPacketImpl(packet, this.configurationService);
    }
}

