/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.extensions.packets.publish;

import com.google.common.base.Preconditions;
import com.google.common.primitives.ImmutableIntArray;
import com.hivemq.configuration.service.FullConfigurationService;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.extension.sdk.api.annotations.Nullable;
import com.hivemq.extension.sdk.api.annotations.ThreadSafe;
import com.hivemq.extension.sdk.api.packets.general.Qos;
import com.hivemq.extension.sdk.api.packets.publish.ModifiableOutboundPublish;
import com.hivemq.extension.sdk.api.packets.publish.PayloadFormatIndicator;
import com.hivemq.extensions.packets.general.ModifiableUserPropertiesImpl;
import com.hivemq.extensions.packets.publish.PublishPacketImpl;
import com.hivemq.extensions.services.builder.PluginBuilderUtil;
import com.hivemq.util.Topics;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

@ThreadSafe
public class ModifiableOutboundPublishImpl
implements ModifiableOutboundPublish {
    @NotNull
    private String topic;
    @NotNull
    private final Qos qos;
    @NotNull
    private final Qos onwardQos;
    private final int packetId;
    private final boolean dupFlag;
    @Nullable
    private ByteBuffer payload;
    private boolean retain;
    private long messageExpiryInterval;
    @Nullable
    private PayloadFormatIndicator payloadFormatIndicator;
    @Nullable
    private String contentType;
    @Nullable
    private String responseTopic;
    @Nullable
    private ByteBuffer correlationData;
    @NotNull
    private ImmutableIntArray subscriptionIdentifiers;
    @NotNull
    private final ModifiableUserPropertiesImpl userProperties;
    private final long timestamp;
    @NotNull
    private final FullConfigurationService configurationService;
    private boolean modified = false;

    public ModifiableOutboundPublishImpl(@NotNull PublishPacketImpl packet, @NotNull FullConfigurationService configurationService) {
        this.topic = packet.topic;
        this.qos = packet.qos;
        this.onwardQos = packet.onwardQos;
        this.packetId = packet.packetId;
        this.dupFlag = packet.dupFlag;
        this.payload = packet.payload;
        this.retain = packet.retain;
        this.messageExpiryInterval = packet.messageExpiryInterval;
        this.payloadFormatIndicator = packet.payloadFormatIndicator;
        this.contentType = packet.contentType;
        this.responseTopic = packet.responseTopic;
        this.correlationData = packet.correlationData;
        this.subscriptionIdentifiers = packet.subscriptionIdentifiers;
        this.userProperties = new ModifiableUserPropertiesImpl(packet.userProperties.asInternalList(), configurationService.securityConfiguration().validateUTF8());
        this.timestamp = packet.timestamp;
        this.configurationService = configurationService;
    }

    @NotNull
    public String getTopic() {
        return this.topic;
    }

    public void setTopic(@NotNull String topic) {
        Preconditions.checkNotNull((Object)topic, (Object)"Topic must not be null");
        Preconditions.checkArgument((topic.length() <= this.configurationService.restrictionsConfiguration().maxTopicLength() ? 1 : 0) != 0, (Object)("Topic filter length must not exceed '" + this.configurationService.restrictionsConfiguration().maxTopicLength() + "' characters, but has '" + topic.length() + "' characters"));
        if (!Topics.isValidTopicToPublish(topic)) {
            throw new IllegalArgumentException("The topic (" + topic + ") is invalid for PUBLISH messages");
        }
        if (!PluginBuilderUtil.isValidUtf8String(topic, this.configurationService.securityConfiguration().validateUTF8())) {
            throw new IllegalArgumentException("The topic (" + topic + ") is UTF-8 malformed");
        }
        if (topic.equals(this.topic)) {
            return;
        }
        this.topic = topic;
        this.modified = true;
    }

    @NotNull
    public Qos getQos() {
        return this.qos;
    }

    public int getPacketId() {
        return this.packetId;
    }

    public boolean getDupFlag() {
        return this.dupFlag;
    }

    @NotNull
    public Optional<ByteBuffer> getPayload() {
        return this.payload == null ? Optional.empty() : Optional.of(this.payload.asReadOnlyBuffer());
    }

    public void setPayload(@NotNull ByteBuffer payload) {
        Preconditions.checkNotNull((Object)payload, (Object)"Payload must never be null");
        if (payload.equals(this.payload)) {
            return;
        }
        this.payload = payload;
        this.modified = true;
    }

    public boolean getRetain() {
        return this.retain;
    }

    public void setRetain(boolean retain) {
        if (this.retain == retain) {
            return;
        }
        this.retain = retain;
        this.modified = true;
    }

    @NotNull
    public Optional<Long> getMessageExpiryInterval() {
        return Optional.of(this.messageExpiryInterval);
    }

    public void setMessageExpiryInterval(long messageExpiryInterval) {
        PluginBuilderUtil.checkMessageExpiryInterval(messageExpiryInterval, this.configurationService.mqttConfiguration().maxMessageExpiryInterval());
        if (this.messageExpiryInterval == messageExpiryInterval) {
            return;
        }
        this.messageExpiryInterval = messageExpiryInterval;
        this.modified = true;
    }

    @NotNull
    public Optional<PayloadFormatIndicator> getPayloadFormatIndicator() {
        return Optional.ofNullable(this.payloadFormatIndicator);
    }

    public void setPayloadFormatIndicator(@Nullable PayloadFormatIndicator payloadFormatIndicator) {
        if (this.payloadFormatIndicator == payloadFormatIndicator) {
            return;
        }
        this.payloadFormatIndicator = payloadFormatIndicator;
        this.modified = true;
    }

    @NotNull
    public Optional<String> getContentType() {
        return Optional.ofNullable(this.contentType);
    }

    public void setContentType(@Nullable String contentType) {
        PluginBuilderUtil.checkContentType(contentType, this.configurationService.securityConfiguration().validateUTF8());
        if (Objects.equals(this.contentType, contentType)) {
            return;
        }
        this.contentType = contentType;
        this.modified = true;
    }

    @NotNull
    public Optional<String> getResponseTopic() {
        return Optional.ofNullable(this.responseTopic);
    }

    public void setResponseTopic(@Nullable String responseTopic) {
        PluginBuilderUtil.checkResponseTopic(responseTopic, this.configurationService.securityConfiguration().validateUTF8());
        if (Objects.equals(this.responseTopic, responseTopic)) {
            return;
        }
        this.responseTopic = responseTopic;
        this.modified = true;
    }

    @NotNull
    public Optional<ByteBuffer> getCorrelationData() {
        return this.correlationData == null ? Optional.empty() : Optional.of(this.correlationData.asReadOnlyBuffer());
    }

    public void setCorrelationData(@Nullable ByteBuffer correlationData) {
        if (Objects.equals(this.correlationData, correlationData)) {
            return;
        }
        this.correlationData = correlationData;
        this.modified = true;
    }

    @NotNull
    public List<Integer> getSubscriptionIdentifiers() {
        return this.subscriptionIdentifiers.asList();
    }

    public void setSubscriptionIdentifiers(@NotNull @NotNull List<@NotNull Integer> subscriptionIdentifiers) {
        Preconditions.checkNotNull(subscriptionIdentifiers, (Object)"Subscription identifiers must not be null null");
        for (Integer subscriptionIdentifier : subscriptionIdentifiers) {
            Preconditions.checkNotNull((Object)subscriptionIdentifier, (Object)"At least one element of the subscription identifiers was null");
        }
        ImmutableIntArray immutableIntArray = ImmutableIntArray.copyOf(subscriptionIdentifiers);
        if (this.subscriptionIdentifiers.equals((Object)immutableIntArray)) {
            return;
        }
        this.subscriptionIdentifiers = immutableIntArray;
        this.modified = true;
    }

    @NotNull
    public ModifiableUserPropertiesImpl getUserProperties() {
        return this.userProperties;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public boolean isModified() {
        return this.modified || this.userProperties.isModified();
    }

    @NotNull
    public PublishPacketImpl copy() {
        return new PublishPacketImpl(this.topic, this.qos, this.onwardQos, this.packetId, this.dupFlag, this.payload, this.retain, this.messageExpiryInterval, this.payloadFormatIndicator, this.contentType, this.responseTopic, this.correlationData, this.subscriptionIdentifiers, this.userProperties.copy(), this.timestamp);
    }

    @NotNull
    public ModifiableOutboundPublishImpl update(@NotNull PublishPacketImpl packet) {
        return new ModifiableOutboundPublishImpl(packet, this.configurationService);
    }
}

