/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.extensions.services.session;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import com.hivemq.bootstrap.ioc.lazysingleton.LazySingleton;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.extension.sdk.api.annotations.Nullable;
import com.hivemq.extension.sdk.api.packets.disconnect.DisconnectReasonCode;
import com.hivemq.extension.sdk.api.services.exception.NoSuchClientIdException;
import com.hivemq.extension.sdk.api.services.general.IterationCallback;
import com.hivemq.extension.sdk.api.services.session.ClientService;
import com.hivemq.extension.sdk.api.services.session.SessionInformation;
import com.hivemq.extensions.ListenableFutureConverter;
import com.hivemq.extensions.iteration.AllItemsFetchCallback;
import com.hivemq.extensions.iteration.AllItemsItemCallback;
import com.hivemq.extensions.iteration.AsyncIterator;
import com.hivemq.extensions.iteration.AsyncIteratorFactory;
import com.hivemq.extensions.iteration.ChunkCursor;
import com.hivemq.extensions.iteration.MultipleChunkResult;
import com.hivemq.extensions.services.PluginServiceRateLimitService;
import com.hivemq.extensions.services.executor.GlobalManagedExtensionExecutorService;
import com.hivemq.extensions.services.session.SessionInformationImpl;
import com.hivemq.mqtt.message.reason.Mqtt5DisconnectReasonCode;
import com.hivemq.persistence.clientsession.ClientSession;
import com.hivemq.persistence.clientsession.ClientSessionPersistence;
import com.hivemq.persistence.clientsession.ClientSessionPersistenceImpl;
import com.hivemq.util.Exceptions;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import javax.inject.Inject;

@LazySingleton
public class ClientServiceImpl
implements ClientService {
    @NotNull
    private final PluginServiceRateLimitService pluginServiceRateLimitService;
    @NotNull
    private final ClientSessionPersistence clientSessionPersistence;
    @NotNull
    private final GlobalManagedExtensionExecutorService managedExtensionExecutorService;
    @NotNull
    private final AsyncIteratorFactory asyncIteratorFactory;

    @Inject
    public ClientServiceImpl(@NotNull PluginServiceRateLimitService pluginServiceRateLimitService, @NotNull ClientSessionPersistence clientSessionPersistence, @NotNull GlobalManagedExtensionExecutorService managedExtensionExecutorService, @NotNull AsyncIteratorFactory asyncIteratorFactory) {
        this.pluginServiceRateLimitService = pluginServiceRateLimitService;
        this.clientSessionPersistence = clientSessionPersistence;
        this.managedExtensionExecutorService = managedExtensionExecutorService;
        this.asyncIteratorFactory = asyncIteratorFactory;
    }

    @NotNull
    public CompletableFuture<Boolean> isClientConnected(@NotNull String clientId) {
        Preconditions.checkNotNull((Object)clientId, (Object)"A client id must never be null");
        if (this.pluginServiceRateLimitService.rateLimitExceeded()) {
            return CompletableFuture.failedFuture((Throwable)PluginServiceRateLimitService.RATE_LIMIT_EXCEEDED_EXCEPTION);
        }
        ClientSession session = this.clientSessionPersistence.getSession(clientId, false);
        if (session == null) {
            return CompletableFuture.completedFuture(false);
        }
        return CompletableFuture.completedFuture(session.isConnected());
    }

    @NotNull
    public CompletableFuture<Optional<SessionInformation>> getSession(@NotNull String clientId) {
        Preconditions.checkNotNull((Object)clientId, (Object)"A client id must never be null");
        if (this.pluginServiceRateLimitService.rateLimitExceeded()) {
            return CompletableFuture.failedFuture((Throwable)PluginServiceRateLimitService.RATE_LIMIT_EXCEEDED_EXCEPTION);
        }
        ClientSession session = this.clientSessionPersistence.getSession(clientId, false);
        if (session == null) {
            return CompletableFuture.completedFuture(Optional.empty());
        }
        return CompletableFuture.completedFuture(Optional.of(new SessionInformationImpl(clientId, session.getSessionExpiryIntervalSec(), session.isConnected())));
    }

    @NotNull
    public CompletableFuture<Boolean> disconnectClient(@NotNull String clientId) {
        return this.disconnectClient(clientId, false);
    }

    @NotNull
    public CompletableFuture<Boolean> disconnectClient(@NotNull String clientId, boolean preventWillMessage) {
        return this.disconnectClient(clientId, preventWillMessage, null, null);
    }

    @NotNull
    public CompletableFuture<Boolean> disconnectClient(@NotNull String clientId, boolean preventWillMessage, @Nullable DisconnectReasonCode reasonCode, @Nullable String reasonString) {
        Preconditions.checkNotNull((Object)clientId, (Object)"A client id must never be null");
        if (reasonCode != null) {
            Preconditions.checkArgument((reasonCode != DisconnectReasonCode.CLIENT_IDENTIFIER_NOT_VALID ? 1 : 0) != 0, (String)"Reason code %s must not be used for disconnect packets.", (Object)reasonCode);
            Preconditions.checkArgument((boolean)Mqtt5DisconnectReasonCode.from(reasonCode).canBeSentByServer(), (String)"Reason code %s must not be used for outbound disconnect packets from the server to a client.", (Object)reasonCode);
        }
        if (this.pluginServiceRateLimitService.rateLimitExceeded()) {
            return CompletableFuture.failedFuture((Throwable)PluginServiceRateLimitService.RATE_LIMIT_EXCEEDED_EXCEPTION);
        }
        Mqtt5DisconnectReasonCode disconnectReasonCode = reasonCode != null ? Mqtt5DisconnectReasonCode.valueOf(reasonCode.name()) : null;
        ListenableFuture<Boolean> disconnectFuture = this.clientSessionPersistence.forceDisconnectClient(clientId, preventWillMessage, ClientSessionPersistenceImpl.DisconnectSource.EXTENSION, disconnectReasonCode, reasonString);
        return ListenableFutureConverter.toCompletable(disconnectFuture, this.managedExtensionExecutorService);
    }

    @NotNull
    public CompletableFuture<Boolean> invalidateSession(final @NotNull String clientId) {
        Preconditions.checkNotNull((Object)clientId, (Object)"A client id must never be null");
        if (this.pluginServiceRateLimitService.rateLimitExceeded()) {
            return CompletableFuture.failedFuture((Throwable)PluginServiceRateLimitService.RATE_LIMIT_EXCEEDED_EXCEPTION);
        }
        final SettableFuture setSessionSettableFuture = SettableFuture.create();
        ListenableFuture<Boolean> setSessionFuture = this.clientSessionPersistence.invalidateSession(clientId, ClientSessionPersistenceImpl.DisconnectSource.EXTENSION);
        Futures.addCallback(setSessionFuture, (FutureCallback)new FutureCallback<Boolean>(){

            public void onSuccess(@Nullable Boolean disconnected) {
                if (disconnected == null) {
                    setSessionSettableFuture.setException((Throwable)new NoSuchClientIdException(clientId));
                } else {
                    setSessionSettableFuture.set((Object)disconnected);
                }
            }

            public void onFailure(@NotNull Throwable t) {
                Exceptions.rethrowError(t);
                setSessionSettableFuture.setException(t);
            }
        }, (Executor)this.managedExtensionExecutorService);
        return ListenableFutureConverter.toCompletable(setSessionSettableFuture, this.managedExtensionExecutorService);
    }

    @NotNull
    public CompletableFuture<Void> iterateAllClients(@NotNull IterationCallback<SessionInformation> callback) {
        return this.iterateAllClients(callback, this.managedExtensionExecutorService);
    }

    @NotNull
    public CompletableFuture<Void> iterateAllClients(@NotNull IterationCallback<SessionInformation> callback, @NotNull Executor callbackExecutor) {
        Preconditions.checkNotNull(callback, (Object)"Callback cannot be null");
        Preconditions.checkNotNull((Object)callbackExecutor, (Object)"Callback executor cannot be null");
        if (this.pluginServiceRateLimitService.rateLimitExceeded()) {
            return CompletableFuture.failedFuture((Throwable)PluginServiceRateLimitService.RATE_LIMIT_EXCEEDED_EXCEPTION);
        }
        AllClientsFetchCallback fetchCallback = new AllClientsFetchCallback(this.clientSessionPersistence);
        AsyncIterator<SessionInformation> asyncIterator = this.asyncIteratorFactory.createIterator(fetchCallback, new AllItemsItemCallback<SessionInformation>(callbackExecutor, callback));
        asyncIterator.fetchAndIterate();
        SettableFuture settableFuture = SettableFuture.create();
        asyncIterator.getFinishedFuture().whenComplete((aVoid, throwable) -> {
            if (throwable != null) {
                settableFuture.setException(throwable);
            } else {
                settableFuture.set(null);
            }
        });
        return ListenableFutureConverter.toCompletable(settableFuture, this.managedExtensionExecutorService);
    }

    static class AllClientsFetchCallback
    extends AllItemsFetchCallback<SessionInformation, Map<String, ClientSession>> {
        @NotNull
        private final ClientSessionPersistence clientSessionPersistence;

        AllClientsFetchCallback(@NotNull ClientSessionPersistence clientSessionPersistence) {
            this.clientSessionPersistence = clientSessionPersistence;
        }

        @Override
        @NotNull
        protected ListenableFuture<MultipleChunkResult<Map<String, ClientSession>>> persistenceCall(@NotNull ChunkCursor chunkCursor) {
            return this.clientSessionPersistence.getAllLocalClientsChunk(chunkCursor);
        }

        @Override
        @NotNull
        protected Collection<SessionInformation> transform(@NotNull Map<String, ClientSession> stringClientSessionMap) {
            return stringClientSessionMap.entrySet().stream().map(entry -> new SessionInformationImpl((String)entry.getKey(), ((ClientSession)entry.getValue()).getSessionExpiryIntervalSec(), ((ClientSession)entry.getValue()).isConnected())).collect(Collectors.toUnmodifiableList());
        }
    }
}

