/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.metrics.ioc;

import com.codahale.metrics.MetricRegistry;
import com.google.inject.Injector;
import com.hivemq.bootstrap.ioc.SingletonModule;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.metrics.MetricsHolder;
import com.hivemq.metrics.MetricsShutdownHook;
import com.hivemq.metrics.gauges.OpenConnectionsGauge;
import com.hivemq.metrics.gauges.RetainedMessagesGauge;
import com.hivemq.metrics.gauges.SessionsGauge;
import com.hivemq.metrics.ioc.provider.OpenConnectionsGaugeProvider;
import com.hivemq.metrics.ioc.provider.RetainedMessagesGaugeProvider;
import com.hivemq.metrics.ioc.provider.SessionsGaugeProvider;
import com.hivemq.metrics.jmx.JmxReporterBootstrap;

public class MetricsModule
extends SingletonModule<Class<MetricsModule>> {
    @NotNull
    private final MetricRegistry metricRegistry;
    @NotNull
    private final Injector persistenceInjector;

    public MetricsModule(@NotNull MetricRegistry metricRegistry, @NotNull Injector persistenceInjector) {
        super(MetricsModule.class);
        this.metricRegistry = metricRegistry;
        this.persistenceInjector = persistenceInjector;
    }

    protected void configure() {
        this.bind(MetricRegistry.class).toInstance((Object)this.metricRegistry);
        this.bind(MetricsHolder.class).toInstance((Object)((MetricsHolder)this.persistenceInjector.getInstance(MetricsHolder.class)));
        this.bind(SessionsGauge.class).toProvider(SessionsGaugeProvider.class).asEagerSingleton();
        this.bind(OpenConnectionsGauge.class).toProvider(OpenConnectionsGaugeProvider.class).asEagerSingleton();
        this.bind(RetainedMessagesGauge.class).toProvider(RetainedMessagesGaugeProvider.class).asEagerSingleton();
        this.bind(JmxReporterBootstrap.class).asEagerSingleton();
        this.bind(MetricsShutdownHook.class).asEagerSingleton();
    }
}

