/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.mqtt.handler.publish;

import com.google.common.util.concurrent.SettableFuture;
import com.google.inject.Inject;
import com.hivemq.bootstrap.ClientConnectionContext;
import com.hivemq.bootstrap.ioc.lazysingleton.LazySingleton;
import com.hivemq.configuration.service.InternalConfigurations;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.mqtt.handler.publish.PublishStatus;
import com.hivemq.mqtt.message.QoS;
import com.hivemq.mqtt.message.dropping.MessageDroppedService;
import com.hivemq.mqtt.message.publish.PUBLISH;
import com.hivemq.mqtt.message.publish.PublishWithFuture;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@LazySingleton
public class DropOutgoingPublishesHandler {
    private static final Logger log = LoggerFactory.getLogger(DropOutgoingPublishesHandler.class);
    @NotNull
    private final AtomicInteger notWritableMessages = new AtomicInteger();
    @NotNull
    private final DecrementCounterListener decrementCounterListener = new DecrementCounterListener();
    @NotNull
    private final MessageDroppedService messageDroppedService;
    private final int notWritableQueueSize;

    @Inject
    public DropOutgoingPublishesHandler(@NotNull MessageDroppedService messageDroppedService) {
        this.messageDroppedService = messageDroppedService;
        this.notWritableQueueSize = InternalConfigurations.NOT_WRITABLE_QUEUE_SIZE.get();
    }

    public boolean checkChannelNotWritable(ChannelHandlerContext ctx, @NotNull Object msg, @NotNull ChannelPromise promise) {
        if (!ctx.channel().isWritable() && msg instanceof PUBLISH) {
            if (this.notWritableMessages.get() < this.notWritableQueueSize) {
                this.notWritableMessages.incrementAndGet();
                promise.addListeners(new GenericFutureListener[]{this.decrementCounterListener});
                return false;
            }
            PUBLISH publish = (PUBLISH)msg;
            if (publish.getQoS() == QoS.AT_MOST_ONCE) {
                if (msg instanceof PublishWithFuture) {
                    SettableFuture<PublishStatus> future = ((PublishWithFuture)msg).getFuture();
                    future.set((Object)PublishStatus.CHANNEL_NOT_WRITABLE);
                }
                String clientId = ClientConnectionContext.of(ctx.channel()).getClientId();
                log.trace("Dropped qos 0 message for client {} on topic {} because the channel was not writable", (Object)clientId, (Object)publish.getTopic());
                this.messageDroppedService.notWritable(clientId, publish.getTopic(), publish.getQoS().getQosNumber());
                promise.setSuccess();
                return true;
            }
        }
        return false;
    }

    private class DecrementCounterListener
    implements GenericFutureListener<Future<? super Void>> {
        private DecrementCounterListener() {
        }

        public void operationComplete(@NotNull Future<? super Void> future) {
            DropOutgoingPublishesHandler.this.notWritableMessages.decrementAndGet();
        }
    }
}

