/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.mqtt.handler.publish;

import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.hivemq.bootstrap.ClientConnection;
import com.hivemq.configuration.service.MqttConfigurationService;
import com.hivemq.configuration.service.RestrictionsConfigurationService;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.extension.sdk.api.annotations.Nullable;
import com.hivemq.extension.sdk.api.packets.auth.DefaultAuthorizationBehaviour;
import com.hivemq.extension.sdk.api.packets.auth.ModifiableDefaultPermissions;
import com.hivemq.extension.sdk.api.packets.publish.AckReasonCode;
import com.hivemq.extensions.handler.tasks.PublishAuthorizerResult;
import com.hivemq.extensions.packets.general.ModifiableDefaultPermissionsImpl;
import com.hivemq.mqtt.handler.disconnect.MqttServerDisconnector;
import com.hivemq.mqtt.handler.publish.DefaultPermissionsEvaluator;
import com.hivemq.mqtt.handler.publish.PublishReturnCode;
import com.hivemq.mqtt.message.ProtocolVersion;
import com.hivemq.mqtt.message.mqtt5.Mqtt5UserProperties;
import com.hivemq.mqtt.message.puback.PUBACK;
import com.hivemq.mqtt.message.publish.PUBLISH;
import com.hivemq.mqtt.message.pubrec.PUBREC;
import com.hivemq.mqtt.message.reason.Mqtt5DisconnectReasonCode;
import com.hivemq.mqtt.message.reason.Mqtt5PubAckReasonCode;
import com.hivemq.mqtt.message.reason.Mqtt5PubRecReasonCode;
import com.hivemq.mqtt.services.InternalPublishService;
import io.netty.channel.ChannelHandlerContext;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class IncomingPublishService {
    @NotNull
    private final InternalPublishService publishService;
    @NotNull
    private final MqttConfigurationService mqttConfigurationService;
    @NotNull
    private final RestrictionsConfigurationService restrictionsConfigurationService;
    @NotNull
    private final MqttServerDisconnector mqttServerDisconnector;

    @Inject
    IncomingPublishService(@NotNull InternalPublishService publishService, @NotNull MqttConfigurationService mqttConfigurationService, @NotNull RestrictionsConfigurationService restrictionsConfigurationService, @NotNull MqttServerDisconnector mqttServerDisconnector) {
        this.publishService = publishService;
        this.mqttConfigurationService = mqttConfigurationService;
        this.restrictionsConfigurationService = restrictionsConfigurationService;
        this.mqttServerDisconnector = mqttServerDisconnector;
    }

    public void processPublish(@NotNull ChannelHandlerContext ctx, @NotNull PUBLISH publish, @Nullable PublishAuthorizerResult authorizerResult) {
        Long maxPublishSize;
        ClientConnection clientConnection = ClientConnection.of(ctx.channel());
        ProtocolVersion protocolVersion = clientConnection.getProtocolVersion();
        int maxQos = this.mqttConfigurationService.maximumQos().getQosNumber();
        int qos = publish.getQoS().getQosNumber();
        if (qos > maxQos) {
            String clientId = clientConnection.getClientId();
            this.mqttServerDisconnector.disconnect(ctx.channel(), "Client '" + clientId + "' (IP: {}) sent a PUBLISH with QoS exceeding the maximum configured QoS. Got QoS " + publish.getQoS() + ", maximum: " + this.mqttConfigurationService.maximumQos() + ". Disconnecting client.", "Sent PUBLISH with QoS (" + qos + ") higher than the allowed maximum (" + maxQos + ")", Mqtt5DisconnectReasonCode.QOS_NOT_SUPPORTED, String.format("Quality of service level of PUBLISH exceeds maximum allowed QoS. QoS used: %s. Maximum allowed QoS: %s.", qos, maxQos));
            return;
        }
        String topic = publish.getTopic();
        int maxTopicLength = this.restrictionsConfigurationService.maxTopicLength();
        if (topic.length() > maxTopicLength) {
            String clientId = clientConnection.getClientId();
            String logMessage = "Client '" + clientId + "' (IP: {}) sent a PUBLISH with a topic that exceeds the maximum configured length of '" + maxTopicLength + "' . Disconnecting client.";
            this.mqttServerDisconnector.disconnect(ctx.channel(), logMessage, "Sent PUBLISH for a topic that exceeds maximum topic length", Mqtt5DisconnectReasonCode.TOPIC_NAME_INVALID, "Maximum topic length configured at the broker exceeded.");
            return;
        }
        if (!(ProtocolVersion.MQTTv3_1 != protocolVersion && ProtocolVersion.MQTTv3_1_1 != protocolVersion || this.isMessageSizeAllowed(maxPublishSize = clientConnection.getMaxPacketSizeSend(), publish))) {
            String clientId = clientConnection.getClientId();
            String logMessage = "Client '" + clientId + "' (IP: {}) sent a PUBLISH with " + publish.getPayload().length + " bytes payload its max allowed size is " + maxPublishSize + " bytes. Disconnecting client.";
            String reason = "Sent PUBLISH with a payload that is bigger than the allowed message size";
            this.mqttServerDisconnector.disconnect(ctx.channel(), logMessage, "Sent PUBLISH with a payload that is bigger than the allowed message size", Mqtt5DisconnectReasonCode.PACKET_TOO_LARGE, "Sent PUBLISH with a payload that is bigger than the allowed message size");
            return;
        }
        this.authorizePublish(ctx, publish, authorizerResult);
    }

    private void authorizePublish(@NotNull ChannelHandlerContext ctx, @NotNull PUBLISH publish, @Nullable PublishAuthorizerResult authorizerResult) {
        ClientConnection clientConnection = ClientConnection.of(ctx.channel());
        if (authorizerResult != null && authorizerResult.getAckReasonCode() != null) {
            if (clientConnection.isIncomingPublishesDefaultFailedSkipRest()) {
                this.finishUnauthorizedPublish(ctx, publish, null, null);
            } else if (authorizerResult.getAckReasonCode() == AckReasonCode.SUCCESS) {
                this.publishMessage(ctx, publish);
            } else {
                this.finishUnauthorizedPublish(ctx, publish, authorizerResult.getAckReasonCode(), authorizerResult.getReasonString());
            }
            return;
        }
        ModifiableDefaultPermissions permissions = clientConnection.getAuthPermissions();
        ModifiableDefaultPermissionsImpl defaultPermissions = (ModifiableDefaultPermissionsImpl)permissions;
        if (authorizerResult != null && authorizerResult.isAuthorizerPresent() && (defaultPermissions == null || defaultPermissions.asList().size() < 1 && defaultPermissions.getDefaultBehaviour() == DefaultAuthorizationBehaviour.ALLOW && !defaultPermissions.isDefaultAuthorizationBehaviourOverridden())) {
            this.finishUnauthorizedPublish(ctx, publish, null, null);
            return;
        }
        if (DefaultPermissionsEvaluator.checkPublish(permissions, publish)) {
            this.publishMessage(ctx, publish);
        } else {
            this.finishUnauthorizedPublish(ctx, publish, null, null);
        }
    }

    private void finishUnauthorizedPublish(@NotNull ChannelHandlerContext ctx, @NotNull PUBLISH publish, @Nullable AckReasonCode reasonCode, @Nullable String reasonString) {
        ClientConnection clientConnection = ClientConnection.of(ctx.channel());
        clientConnection.setIncomingPublishesDefaultFailedSkipRest(true);
        if (!ctx.channel().isActive()) {
            return;
        }
        String reason = "Not authorized to publish on topic '" + publish.getTopic() + "' with QoS '" + publish.getQoS().getQosNumber() + "' and retain '" + publish.isRetain() + "'";
        if (clientConnection.getProtocolVersion() != ProtocolVersion.MQTTv5) {
            String clientId = clientConnection.getClientId();
            this.mqttServerDisconnector.disconnect(ctx.channel(), "Client '" + clientId + "' (IP: {}) is not authorized to publish on topic '" + publish.getTopic() + "' with QoS '" + publish.getQoS().getQosNumber() + "' and retain '" + publish.isRetain() + "'. Disconnecting client.", reason, Mqtt5DisconnectReasonCode.NOT_AUTHORIZED, reason);
            return;
        }
        switch (publish.getQoS()) {
            case AT_MOST_ONCE: {
                break;
            }
            case AT_LEAST_ONCE: {
                PUBACK puback = new PUBACK(publish.getPacketIdentifier(), reasonCode != null ? Mqtt5PubAckReasonCode.from(reasonCode) : Mqtt5PubAckReasonCode.NOT_AUTHORIZED, (String)(reasonString != null ? reasonString : reason), Mqtt5UserProperties.NO_USER_PROPERTIES);
                ctx.pipeline().writeAndFlush((Object)puback);
                break;
            }
            case EXACTLY_ONCE: {
                PUBREC pubrec = new PUBREC(publish.getPacketIdentifier(), reasonCode != null ? Mqtt5PubRecReasonCode.from(reasonCode) : Mqtt5PubRecReasonCode.NOT_AUTHORIZED, (String)(reasonString != null ? reasonString : reason), Mqtt5UserProperties.NO_USER_PROPERTIES);
                ctx.pipeline().writeAndFlush((Object)pubrec);
            }
        }
        String clientId = clientConnection.getClientId();
        this.mqttServerDisconnector.disconnect(ctx.channel(), "Client '" + clientId + "' (IP: {}) is not authorized to publish on topic '" + publish.getTopic() + "' with QoS '" + publish.getQoS().getQosNumber() + "' and retain '" + publish.isRetain() + "'. Disconnecting client.", reason, Mqtt5DisconnectReasonCode.NOT_AUTHORIZED, reason);
    }

    private void publishMessage(final ChannelHandlerContext ctx, final @NotNull PUBLISH publish) {
        ClientConnection clientConnection = ClientConnection.of(ctx.channel());
        String clientId = clientConnection.getClientId();
        ListenableFuture<PublishReturnCode> publishFinishedFuture = this.publishService.publish(publish, (ExecutorService)ctx.channel().eventLoop(), clientId);
        Futures.addCallback(publishFinishedFuture, (FutureCallback)new FutureCallback<PublishReturnCode>(){

            public void onSuccess(@Nullable PublishReturnCode result) {
                IncomingPublishService.this.sendAck(ctx, publish, result);
            }

            public void onFailure(@NotNull Throwable t) {
                IncomingPublishService.this.sendAck(ctx, publish, PublishReturnCode.FAILED);
            }
        }, (Executor)ctx.channel().eventLoop());
    }

    private void sendAck(@NotNull ChannelHandlerContext ctx, PUBLISH publish, @Nullable PublishReturnCode publishReturnCode) {
        switch (publish.getQoS()) {
            case AT_MOST_ONCE: {
                break;
            }
            case AT_LEAST_ONCE: {
                if (publishReturnCode == PublishReturnCode.NO_MATCHING_SUBSCRIBERS) {
                    ctx.pipeline().writeAndFlush((Object)new PUBACK(publish.getPacketIdentifier(), Mqtt5PubAckReasonCode.NO_MATCHING_SUBSCRIBERS, null, Mqtt5UserProperties.NO_USER_PROPERTIES));
                    break;
                }
                ctx.pipeline().writeAndFlush((Object)new PUBACK(publish.getPacketIdentifier()));
                break;
            }
            case EXACTLY_ONCE: {
                if (publishReturnCode == PublishReturnCode.NO_MATCHING_SUBSCRIBERS) {
                    ctx.pipeline().writeAndFlush((Object)new PUBREC(publish.getPacketIdentifier(), Mqtt5PubRecReasonCode.NO_MATCHING_SUBSCRIBERS, null, Mqtt5UserProperties.NO_USER_PROPERTIES));
                    break;
                }
                ctx.pipeline().writeAndFlush((Object)new PUBREC(publish.getPacketIdentifier()));
            }
        }
    }

    private boolean isMessageSizeAllowed(@Nullable Long maxPublishSize, @NotNull PUBLISH publish) {
        return maxPublishSize == null || publish.getPayload() == null || maxPublishSize >= (long)publish.getPayload().length;
    }
}

