/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.mqtt.message.disconnect;

import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.extension.sdk.api.annotations.Nullable;
import com.hivemq.extensions.packets.disconnect.DisconnectPacketImpl;
import com.hivemq.mqtt.message.MessageType;
import com.hivemq.mqtt.message.disconnect.Mqtt3DISCONNECT;
import com.hivemq.mqtt.message.disconnect.Mqtt5DISCONNECT;
import com.hivemq.mqtt.message.mqtt5.Mqtt5UserProperties;
import com.hivemq.mqtt.message.mqtt5.MqttMessageWithUserProperties;
import com.hivemq.mqtt.message.reason.Mqtt5DisconnectReasonCode;

public class DISCONNECT
extends MqttMessageWithUserProperties.MqttMessageWithReasonCode<Mqtt5DisconnectReasonCode>
implements Mqtt3DISCONNECT,
Mqtt5DISCONNECT {
    public static final long SESSION_EXPIRY_NOT_SET = Long.MAX_VALUE;
    @Nullable
    private final String serverReference;
    private final long sessionExpiryInterval;

    public DISCONNECT() {
        super(Mqtt5DisconnectReasonCode.NORMAL_DISCONNECTION, null, Mqtt5UserProperties.NO_USER_PROPERTIES);
        this.sessionExpiryInterval = Long.MAX_VALUE;
        this.serverReference = null;
    }

    public DISCONNECT(@NotNull Mqtt5DisconnectReasonCode reasonCode, @Nullable String reasonString, @NotNull Mqtt5UserProperties userProperties, @Nullable String serverReference, long sessionExpiryInterval) {
        super(reasonCode, reasonString, userProperties);
        this.serverReference = serverReference;
        this.sessionExpiryInterval = sessionExpiryInterval;
    }

    @Override
    public long getSessionExpiryInterval() {
        return this.sessionExpiryInterval;
    }

    @Override
    @Nullable
    public String getServerReference() {
        return this.serverReference;
    }

    @Override
    @NotNull
    public MessageType getType() {
        return MessageType.DISCONNECT;
    }

    @NotNull
    public static DISCONNECT from(@NotNull DisconnectPacketImpl packet) {
        return new DISCONNECT(Mqtt5DisconnectReasonCode.from(packet.getReasonCode()), packet.getReasonString().orElse(null), Mqtt5UserProperties.of(packet.getUserProperties().asInternalList()), packet.getServerReference().orElse(null), packet.getSessionExpiryInterval().orElse(Long.MAX_VALUE));
    }
}

