/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.mqtt.topic;

import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.mqtt.topic.InvalidTopicException;

public final class PermissionTopicMatcherUtils {
    private PermissionTopicMatcherUtils() {
    }

    public static boolean matches(@NotNull String permissionTopic, @NotNull String[] splitPermissionTopic, boolean nonWildCard, boolean endsWithWildCard, boolean rootWildCard, @NotNull String actualTopic, @NotNull String[] splitActualTopic) throws InvalidTopicException {
        if (nonWildCard) {
            return permissionTopic.equals(actualTopic);
        }
        return PermissionTopicMatcherUtils.matchesWildcards(permissionTopic, splitPermissionTopic, endsWithWildCard, rootWildCard, splitActualTopic);
    }

    private static boolean matchesWildcards(@NotNull String permissionTopic, @NotNull @NotNull String @NotNull [] splitPermissionTopic, boolean endsWithWildCard, boolean rootWildCard, @NotNull @NotNull String @NotNull [] splitActualTopic) {
        if (rootWildCard && !endsWithWildCard && permissionTopic.length() > 1) {
            return false;
        }
        int smallest = Math.min(splitPermissionTopic.length, splitActualTopic.length);
        block8: for (int i = 0; i < smallest; ++i) {
            String sub = splitPermissionTopic[i];
            String t = splitActualTopic[i];
            if (sub.equals(t)) continue;
            switch (sub) {
                case "#": {
                    return true;
                }
                case "+": {
                    continue block8;
                }
                default: {
                    return false;
                }
            }
        }
        return splitPermissionTopic.length == splitActualTopic.length || splitPermissionTopic.length - splitActualTopic.length == 1 && "#".equals(splitPermissionTopic[splitPermissionTopic.length - 1]);
    }
}

