/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.persistence.clientqueue;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.primitives.ImmutableIntArray;
import com.hivemq.bootstrap.ioc.lazysingleton.LazySingleton;
import com.hivemq.configuration.service.InternalConfigurations;
import com.hivemq.configuration.service.MqttConfigurationService;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.extension.sdk.api.annotations.Nullable;
import com.hivemq.mqtt.message.MessageWithID;
import com.hivemq.mqtt.message.QoS;
import com.hivemq.mqtt.message.dropping.MessageDroppedService;
import com.hivemq.mqtt.message.publish.PUBLISH;
import com.hivemq.mqtt.message.pubrel.PUBREL;
import com.hivemq.persistence.PersistenceStartup;
import com.hivemq.persistence.clientqueue.ClientQueueEntry;
import com.hivemq.persistence.clientqueue.ClientQueueLocalPersistence;
import com.hivemq.persistence.clientqueue.ClientQueuePersistenceImpl;
import com.hivemq.persistence.clientqueue.ClientQueuePersistenceSerializer;
import com.hivemq.persistence.local.xodus.EnvironmentUtil;
import com.hivemq.persistence.local.xodus.TransactionCommitActions;
import com.hivemq.persistence.local.xodus.XodusLocalPersistence;
import com.hivemq.persistence.local.xodus.bucket.Bucket;
import com.hivemq.persistence.local.xodus.bucket.BucketUtils;
import com.hivemq.persistence.payload.PublishPayloadPersistence;
import com.hivemq.util.LocalPersistenceFileUtil;
import com.hivemq.util.Strings;
import com.hivemq.util.ThreadPreConditions;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import jetbrains.exodus.ByteIterable;
import jetbrains.exodus.env.Cursor;
import jetbrains.exodus.env.StoreConfig;
import jetbrains.exodus.env.Transaction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@LazySingleton
public class ClientQueueXodusLocalPersistence
extends XodusLocalPersistence
implements ClientQueueLocalPersistence {
    @NotNull
    private static final Logger log = LoggerFactory.getLogger(ClientQueueXodusLocalPersistence.class);
    @NotNull
    public static final String PERSISTENCE_NAME = "client_queue";
    @NotNull
    public static final String PERSISTENCE_VERSION = "040500";
    private static final int LINKED_LIST_NODE_OVERHEAD = 24;
    @NotNull
    private final ClientQueuePersistenceSerializer serializer;
    @NotNull
    private final MessageDroppedService messageDroppedService;
    @NotNull
    private final ConcurrentHashMap<Integer, Map<ClientQueuePersistenceImpl.Key, AtomicInteger>> queueSizeBuckets;
    @NotNull
    private final ConcurrentHashMap<Integer, Map<ClientQueuePersistenceImpl.Key, AtomicInteger>> retainedQueueSizeBuckets;
    private final int retainedMessageMax;
    @NotNull
    private final PublishPayloadPersistence payloadPersistence;
    @NotNull
    private final ConcurrentHashMap<Integer, Map<ClientQueuePersistenceImpl.Key, LinkedList<PublishWithRetained>>> qos0MessageBuckets;
    @NotNull
    private final AtomicLong qos0MessagesMemory = new AtomicLong();
    private final long qos0MemoryLimit;
    private final int qos0ClientMemoryLimit;
    @NotNull
    private final ConcurrentHashMap<String, AtomicInteger> clientQos0MemoryMap;
    @VisibleForTesting
    @NotNull
    final Cache<String, Long> sharedSubLastPacketWithoutIdCache;

    @Inject
    ClientQueueXodusLocalPersistence(@NotNull PublishPayloadPersistence payloadPersistence, @NotNull EnvironmentUtil environmentUtil, @NotNull LocalPersistenceFileUtil localPersistenceFileUtil, @NotNull PersistenceStartup persistenceStartup, @NotNull MessageDroppedService messageDroppedService) {
        super(environmentUtil, localPersistenceFileUtil, persistenceStartup, InternalConfigurations.PERSISTENCE_BUCKET_COUNT.get(), true);
        this.retainedMessageMax = InternalConfigurations.RETAINED_MESSAGE_QUEUE_SIZE.get();
        this.qos0ClientMemoryLimit = InternalConfigurations.QOS_0_MEMORY_LIMIT_PER_CLIENT_BYTES.get();
        this.serializer = new ClientQueuePersistenceSerializer();
        this.messageDroppedService = messageDroppedService;
        this.queueSizeBuckets = new ConcurrentHashMap();
        this.retainedQueueSizeBuckets = new ConcurrentHashMap();
        this.payloadPersistence = payloadPersistence;
        this.qos0MessageBuckets = new ConcurrentHashMap();
        this.qos0MemoryLimit = ClientQueueXodusLocalPersistence.getQos0MemoryLimit();
        this.clientQos0MemoryMap = new ConcurrentHashMap();
        this.sharedSubLastPacketWithoutIdCache = CacheBuilder.newBuilder().maximumSize((long)InternalConfigurations.SHARED_SUBSCRIPTION_WITHOUT_PACKET_ID_CACHE_MAX_SIZE_ENTRIES.get()).expireAfterAccess(60L, TimeUnit.SECONDS).build();
    }

    private static long getQos0MemoryLimit() {
        long maxHeap = Runtime.getRuntime().maxMemory();
        int hardLimitDivisor = InternalConfigurations.QOS_0_MEMORY_HARD_LIMIT_DIVISOR.get();
        long maxHardLimit = hardLimitDivisor < 1 ? maxHeap / 4L : maxHeap / (long)hardLimitDivisor;
        log.debug("{} allocated for qos 0 inflight messages", (Object)Strings.convertBytes(maxHardLimit));
        return maxHardLimit;
    }

    @Override
    @NotNull
    protected String getName() {
        return PERSISTENCE_NAME;
    }

    @Override
    @NotNull
    protected String getVersion() {
        return PERSISTENCE_VERSION;
    }

    @Override
    @NotNull
    protected StoreConfig getStoreConfig() {
        return StoreConfig.WITHOUT_DUPLICATES_WITH_PREFIXING;
    }

    @Override
    @NotNull
    protected Logger getLogger() {
        return log;
    }

    @Override
    @PostConstruct
    protected void postConstruct() {
        super.postConstruct();
    }

    @Override
    protected void init() {
        log.debug("Initializing payload reference count and queue sizes for {} persistence.", (Object)PERSISTENCE_NAME);
        Preconditions.checkNotNull((Object)this.buckets, (Object)"Buckets must be initialized at this point");
        for (int i = 0; i < this.buckets.length; ++i) {
            this.qos0MessageBuckets.put(i, new ConcurrentHashMap());
            this.queueSizeBuckets.put(i, new ConcurrentSkipListMap());
            this.retainedQueueSizeBuckets.put(i, new ConcurrentHashMap());
        }
        AtomicLong nextMessageIndex = new AtomicLong(0x3FFFFFFFFFFFFFFFL);
        for (Bucket bucket : this.buckets) {
            bucket.getEnvironment().executeInReadonlyTransaction(txn -> {
                try (Cursor cursor = bucket.getStore().openCursor(txn);){
                    ClientQueuePersistenceImpl.Key currentKey = null;
                    int queueSize = 0;
                    int retainedSize = 0;
                    while (cursor.getNext()) {
                        ClientQueuePersistenceImpl.Key key = this.serializer.deserializeKeyId(cursor.getKey());
                        if (!key.equals(currentKey)) {
                            if (currentKey != null && queueSize != 0) {
                                this.queueSizeBuckets.get(BucketUtils.getBucket(currentKey.getQueueId(), this.getBucketCount())).put(currentKey, new AtomicInteger(queueSize));
                                if (retainedSize != 0) {
                                    this.retainedQueueSizeBuckets.get(BucketUtils.getBucket(currentKey.getQueueId(), this.getBucketCount())).put(currentKey, new AtomicInteger(retainedSize));
                                }
                            }
                            queueSize = 0;
                            retainedSize = 0;
                        }
                        currentKey = key;
                        MessageWithID messageWithID = this.serializer.deserializeValue(cursor.getValue());
                        if (messageWithID instanceof PUBLISH) {
                            long deserializeIndex = this.serializer.deserializeIndex(cursor.getKey());
                            if (nextMessageIndex.get() <= deserializeIndex) {
                                nextMessageIndex.set(deserializeIndex + 1L);
                            }
                            PUBLISH publish = (PUBLISH)messageWithID;
                            this.payloadPersistence.incrementReferenceCounterOnBootstrap(publish.getPublishId());
                        }
                        ++queueSize;
                        if (!this.serializer.deserializeRetained(cursor.getValue())) continue;
                        ++retainedSize;
                    }
                    if (currentKey != null) {
                        if (this.queueSizeBuckets.get(BucketUtils.getBucket(currentKey.getQueueId(), this.getBucketCount())).get(currentKey) == null) {
                            this.queueSizeBuckets.get(BucketUtils.getBucket(currentKey.getQueueId(), this.getBucketCount())).put(currentKey, new AtomicInteger(queueSize));
                        }
                        if (this.retainedQueueSizeBuckets.get(BucketUtils.getBucket(currentKey.getQueueId(), this.getBucketCount())).get(currentKey) == null) {
                            this.retainedQueueSizeBuckets.get(BucketUtils.getBucket(currentKey.getQueueId(), this.getBucketCount())).put(currentKey, new AtomicInteger(retainedSize));
                        }
                    }
                }
            });
        }
        ClientQueuePersistenceSerializer.NEXT_PUBLISH_NUMBER.set(nextMessageIndex.get());
    }

    private void decrementSharedSubscriptionIndexFirstMessageWithoutPacketId(@NotNull String sharedSubId, @NotNull Long newIndex) {
        Long previous = (Long)this.sharedSubLastPacketWithoutIdCache.getIfPresent((Object)sharedSubId);
        if (previous == null || previous > newIndex) {
            this.sharedSubLastPacketWithoutIdCache.put((Object)sharedSubId, (Object)newIndex);
        }
    }

    private void incrementSharedSubscriptionIndexFirstMessageWithoutPacketId(@NotNull String sharedSubId, @NotNull Long newIndex) {
        Long previous = (Long)this.sharedSubLastPacketWithoutIdCache.getIfPresent((Object)sharedSubId);
        if (previous == null || previous < newIndex) {
            this.sharedSubLastPacketWithoutIdCache.put((Object)sharedSubId, (Object)newIndex);
        }
    }

    @Override
    public void add(@NotNull String queueId, boolean shared, @NotNull PUBLISH publish, long max, @NotNull MqttConfigurationService.QueuedMessagesStrategy strategy, boolean retained, int bucketIndex) {
        Preconditions.checkNotNull((Object)queueId, (Object)"Queue ID must not be null");
        Preconditions.checkNotNull((Object)publish, (Object)"Publish must not be null");
        Preconditions.checkNotNull((Object)((Object)strategy), (Object)"Strategy must not be null");
        ThreadPreConditions.startsWith("single-writer");
        ClientQueuePersistenceImpl.Key key = new ClientQueuePersistenceImpl.Key(queueId, shared);
        if (publish.getQoS() == QoS.AT_MOST_ONCE) {
            this.addQos0Publish(key, new PublishWithRetained(publish, retained), bucketIndex);
            return;
        }
        Bucket bucket = this.buckets[bucketIndex];
        AtomicInteger queueSize = this.getOrPutQueueSize(key, bucketIndex);
        AtomicInteger retainedQueueSize = this.getOrPutRetainedQueueSize(key, bucketIndex);
        int qos1And2QueueSize = queueSize.get() - this.qos0Size(key, bucketIndex) - retainedQueueSize.get();
        if (!retained && (long)qos1And2QueueSize >= max) {
            if (this.dropForStrategy(queueId, shared, retained, publish, strategy, key, bucket)) {
                return;
            }
        } else if (retained && retainedQueueSize.get() >= this.retainedMessageMax) {
            if (this.dropForStrategy(queueId, shared, retained, publish, strategy, key, bucket)) {
                return;
            }
        } else {
            queueSize.incrementAndGet();
            if (retained) {
                retainedQueueSize.incrementAndGet();
            }
        }
        ByteIterable keyBytes = this.serializer.serializeNewPublishKey(key);
        ByteIterable valueBytes = this.serializer.serializePublishWithoutPacketId(publish, retained);
        bucket.getEnvironment().executeInExclusiveTransaction(txn -> {
            txn.setCommitHook(() -> this.payloadPersistence.add(publish.getPayload(), publish.getPublishId()));
            bucket.getStore().put(txn, keyBytes, valueBytes);
        });
    }

    private boolean dropForStrategy(@NotNull String queueId, boolean shared, boolean retained, @NotNull PUBLISH publish, @NotNull MqttConfigurationService.QueuedMessagesStrategy strategy, @NotNull ClientQueuePersistenceImpl.Key key, @NotNull Bucket bucket) {
        if (strategy == MqttConfigurationService.QueuedMessagesStrategy.DISCARD) {
            this.logMessageDropped(publish, shared, queueId);
            return true;
        }
        boolean discarded = this.discardOldest(bucket, key, retained);
        if (!discarded) {
            this.logMessageDropped(publish, shared, queueId);
            return true;
        }
        return false;
    }

    @Override
    public void add(@NotNull String queueId, boolean shared, @NotNull List<PUBLISH> publishes, long max, @NotNull MqttConfigurationService.QueuedMessagesStrategy strategy, boolean retained, int bucketIndex) {
        Preconditions.checkNotNull((Object)queueId, (Object)"Queue ID must not be null");
        Preconditions.checkNotNull(publishes, (Object)"Publishes must not be null");
        Preconditions.checkNotNull((Object)((Object)strategy), (Object)"Strategy must not be null");
        ThreadPreConditions.startsWith("single-writer");
        ClientQueuePersistenceImpl.Key key = new ClientQueuePersistenceImpl.Key(queueId, shared);
        ImmutableList.Builder qos1and2Publishes = ImmutableList.builder();
        for (PUBLISH publish : publishes) {
            if (publish.getQoS() == QoS.AT_MOST_ONCE) {
                this.addQos0Publish(key, new PublishWithRetained(publish, retained), bucketIndex);
                continue;
            }
            qos1and2Publishes.add((Object)publish);
        }
        Bucket bucket = this.buckets[bucketIndex];
        AtomicInteger queueSize = this.getOrPutQueueSize(key, bucketIndex);
        AtomicInteger retainedQueueSize = this.getOrPutRetainedQueueSize(key, bucketIndex);
        int qos0Size = this.qos0Size(key, bucketIndex);
        bucket.getEnvironment().executeInExclusiveTransaction(txn -> {
            TransactionCommitActions commitActions = TransactionCommitActions.asCommitHookFor(txn);
            for (PUBLISH publish : qos1and2Publishes.build()) {
                int qos1And2QueueSize = queueSize.get() - qos0Size - retainedQueueSize.get();
                if ((long)qos1And2QueueSize >= max && !retained) {
                    if (strategy == MqttConfigurationService.QueuedMessagesStrategy.DISCARD) {
                        this.logMessageDropped(publish, shared, queueId);
                        continue;
                    }
                    boolean discarded = this.discardOldest(bucket, key, retained, txn, commitActions);
                    if (!discarded) {
                        this.logMessageDropped(publish, shared, queueId);
                        continue;
                    }
                } else if (retainedQueueSize.get() >= this.retainedMessageMax && retained) {
                    if (strategy == MqttConfigurationService.QueuedMessagesStrategy.DISCARD) {
                        this.logMessageDropped(publish, shared, queueId);
                        continue;
                    }
                    boolean discarded = this.discardOldest(bucket, key, retained, txn, commitActions);
                    if (!discarded) {
                        this.logMessageDropped(publish, shared, queueId);
                        continue;
                    }
                } else {
                    queueSize.incrementAndGet();
                    if (retained) {
                        retainedQueueSize.incrementAndGet();
                    }
                }
                ByteIterable keyBytes = this.serializer.serializeNewPublishKey(key);
                ByteIterable valueBytes = this.serializer.serializePublishWithoutPacketId(publish, retained);
                commitActions.add(() -> this.payloadPersistence.add(publish.getPayload(), publish.getPublishId()));
                bucket.getStore().put(txn, keyBytes, valueBytes);
            }
        });
    }

    private void addQos0Publish(@NotNull ClientQueuePersistenceImpl.Key key, @NotNull PublishWithRetained publishWithRetained, int bucketIndex) {
        AtomicInteger clientQos0Memory;
        long currentQos0MessagesMemory = this.qos0MessagesMemory.get();
        PUBLISH publish = publishWithRetained.publish;
        if (currentQos0MessagesMemory >= this.qos0MemoryLimit) {
            if (key.isShared()) {
                this.messageDroppedService.qos0MemoryExceededShared(key.getQueueId(), publish.getTopic(), 0, currentQos0MessagesMemory, this.qos0MemoryLimit);
            } else {
                this.messageDroppedService.qos0MemoryExceeded(key.getQueueId(), publish.getTopic(), 0, currentQos0MessagesMemory, this.qos0MemoryLimit);
            }
            return;
        }
        if (!key.isShared() && (clientQos0Memory = this.clientQos0MemoryMap.get(key.getQueueId())) != null && clientQos0Memory.get() >= this.qos0ClientMemoryLimit) {
            this.messageDroppedService.qos0MemoryExceeded(key.getQueueId(), publish.getTopic(), 0, clientQos0Memory.get(), this.qos0ClientMemoryLimit);
            return;
        }
        this.getOrPutQos0Messages(key, bucketIndex).add(publishWithRetained);
        this.getOrPutQueueSize(key, bucketIndex).incrementAndGet();
        if (publishWithRetained.retained) {
            this.getOrPutRetainedQueueSize(key, bucketIndex).incrementAndGet();
        }
        this.increaseQos0MessagesMemory(publish.getEstimatedSizeInMemory());
        this.increaseClientQos0MessagesMemory(key, publish.getEstimatedSizeInMemory());
        this.payloadPersistence.add(publish.getPayload(), publish.getPublishId());
        publish.setPayload(null);
    }

    private void logMessageDropped(@NotNull PUBLISH publish, boolean shared, @NotNull String queueId) {
        if (shared) {
            this.messageDroppedService.queueFullShared(queueId, publish.getTopic(), publish.getQoS().getQosNumber());
        } else {
            this.messageDroppedService.queueFull(queueId, publish.getTopic(), publish.getQoS().getQosNumber());
        }
    }

    private void increaseQos0MessagesMemory(int size) {
        if (size < 0) {
            this.qos0MessagesMemory.addAndGet(size - 24);
        } else {
            this.qos0MessagesMemory.addAndGet(size + 24);
        }
    }

    @VisibleForTesting
    void increaseClientQos0MessagesMemory(@NotNull ClientQueuePersistenceImpl.Key key, int size) {
        if (key.isShared()) {
            return;
        }
        AtomicInteger qos0MemoryPerClient = this.clientQos0MemoryMap.compute(key.getQueueId(), (clientId, clientQos0Memory) -> {
            if (clientQos0Memory == null) {
                if (size < 0) {
                    return new AtomicInteger(0);
                }
                return new AtomicInteger(size + 24);
            }
            if (size < 0) {
                clientQos0Memory.addAndGet(size - 24);
            } else {
                clientQos0Memory.addAndGet(size + 24);
            }
            return clientQos0Memory;
        });
        if (qos0MemoryPerClient.get() <= 0) {
            this.clientQos0MemoryMap.remove(key.getQueueId());
        }
    }

    private boolean discardOldest(@NotNull Bucket bucket, @NotNull ClientQueuePersistenceImpl.Key key, boolean retainedOnly) {
        return (Boolean)bucket.getEnvironment().computeInExclusiveTransaction(txn -> {
            TransactionCommitActions commitActions = TransactionCommitActions.asCommitHookFor(txn);
            return this.discardOldest(bucket, key, retainedOnly, txn, commitActions);
        });
    }

    private boolean discardOldest(@NotNull Bucket bucket, @NotNull ClientQueuePersistenceImpl.Key key, boolean retainedOnly, @NotNull Transaction txn, @NotNull TransactionCommitActions commitActions) {
        AtomicBoolean discarded = new AtomicBoolean();
        try (Cursor cursor = bucket.getStore().openCursor(txn);){
            this.iterateQueue(cursor, key, true, () -> {
                ByteIterable value = cursor.getValue();
                if (retainedOnly != this.serializer.deserializeRetained(value)) {
                    return true;
                }
                PUBLISH publish = (PUBLISH)this.serializer.deserializeValue(value);
                commitActions.add(() -> {
                    this.logMessageDropped(publish, key.isShared(), key.getQueueId());
                    this.payloadPersistence.decrementReferenceCounter(publish.getPublishId());
                });
                cursor.deleteCurrent();
                discarded.set(true);
                return false;
            });
        }
        return discarded.get();
    }

    private boolean setPayloadIfExistingElseDrop(@NotNull PUBLISH publish, @NotNull String queueId, boolean shared, int bucketIndex) {
        byte[] payload = this.payloadPersistence.get(publish.getPublishId());
        if (payload == null) {
            this.messageDroppedService.failed(queueId, publish.getTopic(), publish.getQoS().getQosNumber());
            if (publish.getQoS() != QoS.AT_MOST_ONCE) {
                if (shared) {
                    this.removeShared(queueId, publish.getUniqueId(), bucketIndex);
                } else {
                    this.remove(queueId, publish.getPacketIdentifier(), publish.getUniqueId(), bucketIndex);
                }
            }
            return false;
        }
        publish.setPayload(payload);
        if (publish.getQoS() == QoS.AT_MOST_ONCE) {
            this.payloadPersistence.decrementReferenceCounter(publish.getPublishId());
        }
        return true;
    }

    @Override
    @NotNull
    public ImmutableList<PUBLISH> readNew(@NotNull String queueId, boolean shared, @NotNull ImmutableIntArray packetIds, long bytesLimit, int bucketIndex) {
        Preconditions.checkNotNull((Object)queueId, (Object)"Queue ID must not be null");
        Preconditions.checkNotNull((Object)packetIds, (Object)"Packet IDs must not be null");
        ThreadPreConditions.startsWith("single-writer");
        ClientQueuePersistenceImpl.Key key = new ClientQueuePersistenceImpl.Key(queueId, shared);
        AtomicInteger queueSize = this.getOrPutQueueSize(key, bucketIndex);
        if (queueSize.get() == 0) {
            return ImmutableList.of();
        }
        LinkedList<PublishWithRetained> qos0Messages = this.getOrPutQos0Messages(key, bucketIndex);
        if (queueSize.get() == qos0Messages.size()) {
            ImmutableList.Builder publishes = ImmutableList.builder();
            int qos0MessagesFound = 0;
            int qos0Bytes = 0;
            while (qos0MessagesFound < packetIds.length() && bytesLimit > (long)qos0Bytes) {
                PUBLISH qos0Publish = this.pollQos0Message(key, bucketIndex);
                if (qos0Publish.isExpired()) {
                    this.payloadPersistence.decrementReferenceCounter(qos0Publish.getPublishId());
                } else if (this.setPayloadIfExistingElseDrop(qos0Publish, queueId, shared, bucketIndex)) {
                    publishes.add((Object)qos0Publish);
                    ++qos0MessagesFound;
                    qos0Bytes += qos0Publish.getEstimatedSizeInMemory();
                }
                if (!qos0Messages.isEmpty()) continue;
                break;
            }
            return publishes.build();
        }
        Bucket bucket = this.buckets[bucketIndex];
        return (ImmutableList)bucket.getEnvironment().computeInExclusiveTransaction(txn -> {
            try (Cursor cursor = bucket.getStore().openCursor(txn);){
                int countLimit = packetIds.length();
                int[] messageCount = new int[]{0};
                int[] packetIdIndex = new int[]{0};
                int[] bytes = new int[]{0};
                ImmutableList.Builder publishes = ImmutableList.builder();
                this.iterateQueue(cursor, key, true, () -> {
                    ByteIterable serializedValue = cursor.getValue();
                    PUBLISH publish = (PUBLISH)this.serializer.deserializeValue(serializedValue);
                    if (publish.isExpired()) {
                        cursor.deleteCurrent();
                        this.payloadPersistence.decrementReferenceCounter(publish.getPublishId());
                        this.getOrPutQueueSize(key, bucketIndex).decrementAndGet();
                        if (this.serializer.deserializeRetained(serializedValue)) {
                            this.getOrPutRetainedQueueSize(key, bucketIndex).decrementAndGet();
                        }
                    } else {
                        if (!this.setPayloadIfExistingElseDrop(publish, queueId, shared, bucketIndex)) {
                            return true;
                        }
                        int packetId = packetIds.get(packetIdIndex[0]);
                        publish.setPacketIdentifier(packetId);
                        bucket.getStore().put(txn, cursor.getKey(), this.serializer.serializeAndSetPacketId(serializedValue, packetId));
                        publishes.add((Object)publish);
                        packetIdIndex[0] = packetIdIndex[0] + 1;
                        messageCount[0] = messageCount[0] + 1;
                        bytes[0] = bytes[0] + publish.getEstimatedSizeInMemory();
                        if (messageCount[0] == countLimit || (long)bytes[0] > bytesLimit) {
                            return false;
                        }
                    }
                    if (!qos0Messages.isEmpty()) {
                        PUBLISH qos0Publish = this.pollQos0Message(key, bucketIndex);
                        if (qos0Publish.isExpired()) {
                            this.payloadPersistence.decrementReferenceCounter(qos0Publish.getPublishId());
                        } else if (this.setPayloadIfExistingElseDrop(qos0Publish, queueId, shared, bucketIndex)) {
                            publishes.add((Object)qos0Publish);
                            messageCount[0] = messageCount[0] + 1;
                            bytes[0] = bytes[0] + qos0Publish.getEstimatedSizeInMemory();
                        }
                    }
                    return messageCount[0] != countLimit && (long)bytes[0] <= bytesLimit;
                });
                ImmutableList immutableList = publishes.build();
                return immutableList;
            }
        });
    }

    @NotNull
    private PUBLISH pollQos0Message(@NotNull ClientQueuePersistenceImpl.Key key, int bucketIndex) {
        LinkedList<PublishWithRetained> qos0Messages = this.getOrPutQos0Messages(key, bucketIndex);
        PublishWithRetained publishWithRetained = qos0Messages.poll();
        PUBLISH qos0Publish = publishWithRetained.publish;
        this.getOrPutQueueSize(key, bucketIndex).decrementAndGet();
        if (publishWithRetained.retained) {
            this.getOrPutRetainedQueueSize(key, bucketIndex).decrementAndGet();
        }
        this.increaseQos0MessagesMemory(qos0Publish.getEstimatedSizeInMemory() * -1);
        this.increaseClientQos0MessagesMemory(key, qos0Publish.getEstimatedSizeInMemory() * -1);
        return qos0Publish;
    }

    @Override
    @NotNull
    public ImmutableList<MessageWithID> readInflight(@NotNull String client, boolean shared, int batchSize, long bytesLimit, int bucketIndex) {
        Preconditions.checkNotNull((Object)client, (Object)"client id must not be null");
        ThreadPreConditions.startsWith("single-writer");
        ClientQueuePersistenceImpl.Key key = new ClientQueuePersistenceImpl.Key(client, shared);
        Bucket bucket = this.buckets[bucketIndex];
        return (ImmutableList)bucket.getEnvironment().computeInReadonlyTransaction(txn -> {
            try (Cursor cursor = bucket.getStore().openCursor(txn);){
                int[] count = new int[]{0};
                int[] bytes = new int[]{0};
                ImmutableList.Builder messages = ImmutableList.builder();
                this.iterateQueue(cursor, key, false, () -> {
                    ByteIterable serializedValue = cursor.getValue();
                    MessageWithID message = this.serializer.deserializeValue(serializedValue);
                    if (message.getPacketIdentifier() == 0) {
                        return false;
                    }
                    if (message instanceof PUBLISH) {
                        PUBLISH publish = (PUBLISH)message;
                        if (!this.setPayloadIfExistingElseDrop(publish, client, shared, bucketIndex)) {
                            return true;
                        }
                        bytes[0] = bytes[0] + publish.getEstimatedSizeInMemory();
                        publish.setDuplicateDelivery(true);
                    }
                    messages.add((Object)message);
                    count[0] = count[0] + 1;
                    return count[0] != batchSize && (long)bytes[0] <= bytesLimit;
                });
                ImmutableList immutableList = messages.build();
                return immutableList;
            }
        });
    }

    @Override
    @Nullable
    public String replace(@NotNull String client, @NotNull PUBREL pubrel, int bucketIndex) {
        Preconditions.checkNotNull((Object)client, (Object)"client id must not be null");
        Preconditions.checkNotNull((Object)pubrel, (Object)"pubrel must not be null");
        ThreadPreConditions.startsWith("single-writer");
        ClientQueuePersistenceImpl.Key key = new ClientQueuePersistenceImpl.Key(client, false);
        Bucket bucket = this.buckets[bucketIndex];
        return (String)bucket.getEnvironment().computeInExclusiveTransaction(txn -> {
            try (Cursor cursor = bucket.getStore().openCursor(txn);){
                boolean[] packetIdFound = new boolean[1];
                String[] replacedId = new String[1];
                this.iterateQueue(cursor, key, false, () -> {
                    MessageWithID message = this.serializer.deserializeValue(cursor.getValue());
                    int packetId = message.getPacketIdentifier();
                    if (packetId == pubrel.getPacketIdentifier()) {
                        packetIdFound[0] = true;
                        boolean retained = this.serializer.deserializeRetained(cursor.getValue());
                        if (message instanceof PUBLISH) {
                            PUBLISH publish = (PUBLISH)message;
                            this.payloadPersistence.decrementReferenceCounter(publish.getPublishId());
                            pubrel.setMessageExpiryInterval(publish.getMessageExpiryInterval());
                            pubrel.setPublishTimestamp(publish.getTimestamp());
                            replacedId[0] = publish.getUniqueId();
                        } else if (message instanceof PUBREL) {
                            pubrel.setMessageExpiryInterval(((PUBREL)message).getMessageExpiryInterval());
                            pubrel.setPublishTimestamp(((PUBREL)message).getPublishTimestamp());
                        }
                        ByteIterable serializedPubRel = this.serializer.serializePubRel(pubrel, retained);
                        bucket.getStore().put(txn, cursor.getKey(), serializedPubRel);
                        return false;
                    }
                    return packetId != 0;
                });
                if (!packetIdFound[0]) {
                    if (InternalConfigurations.EXPIRE_INFLIGHT_PUBRELS_ENABLED) {
                        pubrel.setMessageExpiryInterval(InternalConfigurations.MAXIMUM_INFLIGHT_PUBREL_EXPIRY);
                        pubrel.setPublishTimestamp(System.currentTimeMillis());
                    }
                    this.getOrPutQueueSize(key, bucketIndex).incrementAndGet();
                    ByteIterable serializedPubRel = this.serializer.serializePubRel(pubrel, false);
                    bucket.getStore().put(txn, this.serializer.serializeUnknownPubRelKey(key), serializedPubRel);
                }
                String string = replacedId[0];
                return string;
            }
        });
    }

    @Override
    public String remove(@NotNull String client, int packetId, int bucketIndex) {
        return this.remove(client, packetId, null, bucketIndex);
    }

    @Override
    @Nullable
    public String remove(@NotNull String client, int packetId, @Nullable String uniqueId, int bucketIndex) {
        Preconditions.checkNotNull((Object)client, (Object)"client id must not be null");
        ThreadPreConditions.startsWith("single-writer");
        ClientQueuePersistenceImpl.Key key = new ClientQueuePersistenceImpl.Key(client, false);
        Bucket bucket = this.buckets[bucketIndex];
        return (String)bucket.getEnvironment().computeInExclusiveTransaction(txn -> {
            try (Cursor cursor = bucket.getStore().openCursor(txn);){
                String[] result = new String[]{null};
                this.iterateQueue(cursor, key, false, () -> {
                    MessageWithID message = this.serializer.deserializeValue(cursor.getValue());
                    if (message.getPacketIdentifier() == packetId) {
                        String removedId = null;
                        if (message instanceof PUBLISH) {
                            PUBLISH publish = (PUBLISH)message;
                            if (uniqueId != null && !uniqueId.equals(publish.getUniqueId())) {
                                return false;
                            }
                            this.payloadPersistence.decrementReferenceCounter(publish.getPublishId());
                            removedId = publish.getUniqueId();
                        }
                        this.getOrPutQueueSize(key, bucketIndex).decrementAndGet();
                        if (this.serializer.deserializeRetained(cursor.getValue())) {
                            this.getOrPutRetainedQueueSize(key, bucketIndex).decrementAndGet();
                        }
                        cursor.deleteCurrent();
                        result[0] = removedId;
                        return false;
                    }
                    return true;
                });
                String string = result[0];
                return string;
            }
        });
    }

    @Override
    public int size(@NotNull String queueId, boolean shared, int bucketIndex) {
        Preconditions.checkNotNull((Object)queueId, (Object)"Queue ID must not be null");
        ThreadPreConditions.startsWith("single-writer");
        ClientQueuePersistenceImpl.Key key = new ClientQueuePersistenceImpl.Key(queueId, shared);
        AtomicInteger queueSize = this.queueSizeBuckets.get(bucketIndex).get(key);
        return queueSize == null ? 0 : queueSize.get();
    }

    @Override
    public void clear(@NotNull String queueId, boolean shared, int bucketIndex) {
        Preconditions.checkNotNull((Object)queueId, (Object)"Queue ID must not be null");
        ThreadPreConditions.startsWith("single-writer");
        ClientQueuePersistenceImpl.Key key = new ClientQueuePersistenceImpl.Key(queueId, shared);
        Bucket bucket = this.buckets[bucketIndex];
        bucket.getEnvironment().executeInExclusiveTransaction(txn -> {
            try (Cursor cursor = bucket.getStore().openCursor(txn);){
                this.iterateQueue(cursor, key, false, () -> {
                    MessageWithID message = this.serializer.deserializeValue(cursor.getValue());
                    if (message instanceof PUBLISH) {
                        this.payloadPersistence.decrementReferenceCounter(((PUBLISH)message).getPublishId());
                    }
                    cursor.deleteCurrent();
                    return true;
                });
            }
        });
        LinkedList<PublishWithRetained> qos0Messages = this.getOrPutQos0Messages(key, bucketIndex);
        for (PublishWithRetained qos0Message : qos0Messages) {
            this.increaseQos0MessagesMemory(qos0Message.publish.getEstimatedSizeInMemory() * -1);
            this.increaseClientQos0MessagesMemory(key, qos0Message.publish.getEstimatedSizeInMemory() * -1);
            this.payloadPersistence.decrementReferenceCounter(qos0Message.publish.getPublishId());
        }
        this.qos0MessageBuckets.get(bucketIndex).remove(key);
        this.queueSizeBuckets.get(bucketIndex).remove(key);
        this.retainedQueueSizeBuckets.get(bucketIndex).remove(key);
    }

    @Override
    public void removeAllQos0Messages(@NotNull String queueId, boolean shared, int bucketIndex) {
        Preconditions.checkNotNull((Object)queueId, (Object)"Queue id must not be null");
        ThreadPreConditions.startsWith("single-writer");
        ClientQueuePersistenceImpl.Key key = new ClientQueuePersistenceImpl.Key(queueId, shared);
        LinkedList<PublishWithRetained> publishesWithRetained = this.getOrPutQos0Messages(key, bucketIndex);
        Iterator iterator = publishesWithRetained.iterator();
        while (iterator.hasNext()) {
            PublishWithRetained publishWithRetained = (PublishWithRetained)iterator.next();
            PUBLISH publish = publishWithRetained.publish;
            iterator.remove();
            this.payloadPersistence.decrementReferenceCounter(publish.getPublishId());
            this.getOrPutQueueSize(key, bucketIndex).decrementAndGet();
            if (publishWithRetained.retained) {
                this.getOrPutRetainedQueueSize(key, bucketIndex).decrementAndGet();
            }
            this.increaseQos0MessagesMemory(publish.getEstimatedSizeInMemory() * -1);
            this.increaseClientQos0MessagesMemory(key, publish.getEstimatedSizeInMemory() * -1);
        }
        this.qos0MessageBuckets.get(bucketIndex).remove(key);
    }

    @Override
    @NotNull
    public ImmutableSet<String> cleanUp(int bucketIndex) {
        ThreadPreConditions.startsWith("single-writer");
        if (this.stopped.get()) {
            return ImmutableSet.of();
        }
        ImmutableSet.Builder sharedQueues = ImmutableSet.builder();
        Map<ClientQueuePersistenceImpl.Key, AtomicInteger> bucketClients = this.queueSizeBuckets.get(bucketIndex);
        for (ClientQueuePersistenceImpl.Key bucketKey : bucketClients.keySet()) {
            if (bucketKey.isShared()) {
                sharedQueues.add((Object)bucketKey.getQueueId());
            }
            this.cleanExpiredMessages(bucketKey, bucketIndex);
        }
        return sharedQueues.build();
    }

    @Override
    public void removeShared(@NotNull String sharedSubscription, @NotNull String uniqueId, int bucketIndex) {
        Preconditions.checkNotNull((Object)sharedSubscription, (Object)"Shared subscription must not be null");
        Preconditions.checkNotNull((Object)uniqueId, (Object)"Unique id must not be null");
        ThreadPreConditions.startsWith("single-writer");
        ClientQueuePersistenceImpl.Key key = new ClientQueuePersistenceImpl.Key(sharedSubscription, true);
        Bucket bucket = this.buckets[bucketIndex];
        bucket.getEnvironment().executeInExclusiveTransaction(txn -> {
            try (Cursor cursor = bucket.getStore().openCursor(txn);){
                this.iterateQueue(cursor, key, false, () -> {
                    MessageWithID message = this.serializer.deserializeValue(cursor.getValue());
                    if (message instanceof PUBLISH) {
                        PUBLISH publish = (PUBLISH)message;
                        if (!uniqueId.equals(publish.getUniqueId())) {
                            return true;
                        }
                        this.payloadPersistence.decrementReferenceCounter(publish.getPublishId());
                        this.getOrPutQueueSize(key, bucketIndex).decrementAndGet();
                        if (this.serializer.deserializeRetained(cursor.getValue())) {
                            this.getOrPutRetainedQueueSize(key, bucketIndex).decrementAndGet();
                        }
                        cursor.deleteCurrent();
                    }
                    return false;
                });
            }
        });
    }

    @Override
    public void removeInFlightMarker(@NotNull String sharedSubscription, @NotNull String uniqueId, int bucketIndex) {
        Preconditions.checkNotNull((Object)sharedSubscription, (Object)"Shared subscription must not be null");
        Preconditions.checkNotNull((Object)uniqueId, (Object)"Unique id must not be null");
        ThreadPreConditions.startsWith("single-writer");
        ClientQueuePersistenceImpl.Key key = new ClientQueuePersistenceImpl.Key(sharedSubscription, true);
        Bucket bucket = this.buckets[bucketIndex];
        bucket.getEnvironment().executeInExclusiveTransaction(txn -> {
            try (Cursor cursor = bucket.getStore().openCursor(txn);){
                this.iterateQueue(cursor, key, false, () -> {
                    MessageWithID message = this.serializer.deserializeValue(cursor.getValue());
                    if (message instanceof PUBLISH) {
                        PUBLISH publish = (PUBLISH)message;
                        if (!uniqueId.equals(publish.getUniqueId())) {
                            return true;
                        }
                        long index = this.serializer.deserializeIndex(cursor.getKey());
                        this.decrementSharedSubscriptionIndexFirstMessageWithoutPacketId(sharedSubscription, index);
                        bucket.getStore().put(txn, cursor.getKey(), this.serializer.serializePublishWithoutPacketId(publish, false));
                    }
                    return false;
                });
            }
        });
    }

    @NotNull
    public ConcurrentHashMap<Integer, Map<ClientQueuePersistenceImpl.Key, AtomicInteger>> getQueueSizeBuckets() {
        return this.queueSizeBuckets;
    }

    @NotNull
    public ConcurrentHashMap<String, AtomicInteger> getClientQos0MemoryMap() {
        return this.clientQos0MemoryMap;
    }

    private void cleanExpiredMessages(@NotNull ClientQueuePersistenceImpl.Key key, int bucketIndex) {
        LinkedList<PublishWithRetained> qos0Messages = this.getOrPutQos0Messages(key, bucketIndex);
        Iterator iterator = qos0Messages.iterator();
        while (iterator.hasNext()) {
            PublishWithRetained publishWithRetained = (PublishWithRetained)iterator.next();
            PUBLISH qos0Message = publishWithRetained.publish;
            if (!qos0Message.isExpired()) continue;
            this.getOrPutQueueSize(key, bucketIndex).decrementAndGet();
            this.increaseQos0MessagesMemory(qos0Message.getEstimatedSizeInMemory() * -1);
            this.increaseClientQos0MessagesMemory(key, qos0Message.getEstimatedSizeInMemory() * -1);
            this.payloadPersistence.decrementReferenceCounter(qos0Message.getPublishId());
            if (publishWithRetained.retained) {
                this.getOrPutRetainedQueueSize(key, bucketIndex).decrementAndGet();
            }
            iterator.remove();
        }
        Bucket bucket = this.buckets[bucketIndex];
        bucket.getEnvironment().executeInExclusiveTransaction(txn -> {
            try (Cursor cursor = bucket.getStore().openCursor(txn);){
                this.iterateQueue(cursor, key, false, () -> {
                    ByteIterable serializedValue = cursor.getValue();
                    MessageWithID message = this.serializer.deserializeValue(serializedValue);
                    if (message instanceof PUBREL) {
                        PUBREL pubrel = (PUBREL)message;
                        if (!InternalConfigurations.EXPIRE_INFLIGHT_PUBRELS_ENABLED) {
                            return true;
                        }
                        if (!pubrel.hasExpired(InternalConfigurations.MAXIMUM_INFLIGHT_PUBREL_EXPIRY)) {
                            return true;
                        }
                        this.getOrPutQueueSize(key, bucketIndex).decrementAndGet();
                        if (this.serializer.deserializeRetained(serializedValue)) {
                            this.getOrPutRetainedQueueSize(key, bucketIndex).decrementAndGet();
                        }
                        cursor.deleteCurrent();
                    } else if (message instanceof PUBLISH) {
                        boolean drop;
                        PUBLISH publish = (PUBLISH)message;
                        boolean expireInflight = InternalConfigurations.EXPIRE_INFLIGHT_MESSAGES_ENABLED;
                        boolean isInflight = publish.getQoS() == QoS.EXACTLY_ONCE && publish.getPacketIdentifier() > 0;
                        boolean bl = drop = publish.isExpired() && (!isInflight || expireInflight);
                        if (drop) {
                            this.payloadPersistence.decrementReferenceCounter(publish.getPublishId());
                            this.getOrPutQueueSize(key, bucketIndex).decrementAndGet();
                            if (this.serializer.deserializeRetained(serializedValue)) {
                                this.getOrPutRetainedQueueSize(key, bucketIndex).decrementAndGet();
                            }
                            cursor.deleteCurrent();
                        }
                    }
                    return true;
                });
            }
        });
    }

    private int skipPrefix(@NotNull ByteIterable serializedKey, @NotNull Cursor cursor) {
        int comparison = this.serializer.compareClientId(serializedKey, cursor.getKey());
        while (comparison == 1) {
            comparison = this.compareNextClientId(serializedKey, cursor);
        }
        return comparison;
    }

    private int skipWithPacketId(@NotNull ByteIterable serializedKey, @NotNull Cursor cursor, int comparison) {
        while (comparison == 0 && this.serializer.deserializePacketId(cursor.getValue()) != 0) {
            comparison = this.compareNextClientId(serializedKey, cursor);
        }
        return comparison;
    }

    private int compareNextClientId(@NotNull ByteIterable serializedClientId, @NotNull Cursor cursor) {
        if (!cursor.getNext()) {
            return 2;
        }
        return this.serializer.compareClientId(serializedClientId, cursor.getKey());
    }

    private void iterateQueue(Cursor cursor, @NotNull ClientQueuePersistenceImpl.Key key, boolean skipWithId, @NotNull IterationCallback iterationCallback) {
        ByteIterable keyToSeek;
        Long indexToLookTo;
        ByteIterable serializedKey = this.serializer.serializeKey(key);
        if (skipWithId ? ((indexToLookTo = (Long)this.sharedSubLastPacketWithoutIdCache.getIfPresent((Object)key.getQueueId())) != null ? cursor.getSearchKeyRange(keyToSeek = this.serializer.serializeKey(key, indexToLookTo)) == null : cursor.getSearchKeyRange(serializedKey) == null) : cursor.getSearchKeyRange(serializedKey) == null) {
            return;
        }
        int comparison = this.skipPrefix(serializedKey, cursor);
        if (skipWithId) {
            comparison = this.skipWithPacketId(serializedKey, cursor, comparison);
            if (key.isShared()) {
                this.incrementSharedSubscriptionIndexFirstMessageWithoutPacketId(key.getQueueId(), this.serializer.deserializeIndex(cursor.getKey()));
            }
        }
        while (comparison == 0) {
            if (!iterationCallback.nextEntry()) {
                return;
            }
            comparison = this.compareNextClientId(serializedKey, cursor);
        }
    }

    @VisibleForTesting
    @NotNull
    public ImmutableList<ClientQueueEntry> getAll(@NotNull String queueId, boolean shared, int bucketIndex) {
        Preconditions.checkNotNull((Object)queueId, (Object)"Queue id must not be null");
        ThreadPreConditions.startsWith("single-writer");
        ClientQueuePersistenceImpl.Key key = new ClientQueuePersistenceImpl.Key(queueId, shared);
        Bucket bucket = this.buckets[bucketIndex];
        ImmutableList.Builder messageBuilder = (ImmutableList.Builder)bucket.getEnvironment().computeInExclusiveTransaction(txn -> {
            try (Cursor cursor = bucket.getStore().openCursor(txn);){
                ImmutableList.Builder entries = ImmutableList.builder();
                this.iterateQueue(cursor, key, false, () -> {
                    ByteIterable value = cursor.getValue();
                    MessageWithID messageWithID = this.serializer.deserializeValue(value);
                    if (messageWithID instanceof PUBLISH) {
                        PUBLISH publish = (PUBLISH)messageWithID;
                        publish.setPayload(this.payloadPersistence.get(publish.getPublishId()));
                    }
                    boolean retained = this.serializer.deserializeRetained(value);
                    entries.add((Object)new ClientQueueEntry(messageWithID, retained));
                    return true;
                });
                ImmutableList.Builder builder = entries;
                return builder;
            }
        });
        return messageBuilder.build();
    }

    @NotNull
    private AtomicInteger getOrPutQueueSize(@NotNull ClientQueuePersistenceImpl.Key key, int bucketIndex) {
        Map<ClientQueuePersistenceImpl.Key, AtomicInteger> queueSizeBucket = this.queueSizeBuckets.get(bucketIndex);
        return this.getOrPutQueueSizeFromBucket(key, queueSizeBucket);
    }

    @NotNull
    private AtomicInteger getOrPutRetainedQueueSize(@NotNull ClientQueuePersistenceImpl.Key key, int bucketIndex) {
        Map<ClientQueuePersistenceImpl.Key, AtomicInteger> queueSizeBucket = this.retainedQueueSizeBuckets.get(bucketIndex);
        return this.getOrPutQueueSizeFromBucket(key, queueSizeBucket);
    }

    @NotNull
    private AtomicInteger getOrPutQueueSizeFromBucket(@NotNull ClientQueuePersistenceImpl.Key key, @NotNull Map<ClientQueuePersistenceImpl.Key, AtomicInteger> queueSizeBucket) {
        AtomicInteger queueSize = queueSizeBucket.get(key);
        if (queueSize != null) {
            return queueSize;
        }
        AtomicInteger newQueueSize = new AtomicInteger();
        queueSizeBucket.put(key, newQueueSize);
        return newQueueSize;
    }

    @NotNull
    private LinkedList<PublishWithRetained> getOrPutQos0Messages(@NotNull ClientQueuePersistenceImpl.Key key, int bucketIndex) {
        Map<ClientQueuePersistenceImpl.Key, LinkedList<PublishWithRetained>> bucketMessages = this.qos0MessageBuckets.get(bucketIndex);
        LinkedList<PublishWithRetained> publishes = bucketMessages.get(key);
        if (publishes != null) {
            return publishes;
        }
        publishes = new LinkedList();
        bucketMessages.put(key, publishes);
        return publishes;
    }

    private int qos0Size(@NotNull ClientQueuePersistenceImpl.Key key, int bucketIndex) {
        Map<ClientQueuePersistenceImpl.Key, LinkedList<PublishWithRetained>> bucketMessages = this.qos0MessageBuckets.get(bucketIndex);
        LinkedList<PublishWithRetained> publishes = bucketMessages.get(key);
        if (publishes != null) {
            return publishes.size();
        }
        return 0;
    }

    private static class PublishWithRetained {
        @NotNull
        private final PUBLISH publish;
        private final boolean retained;

        private PublishWithRetained(@NotNull PUBLISH publish, boolean retained) {
            this.publish = publish;
            this.retained = retained;
        }
    }

    private static interface IterationCallback {
        public boolean nextEntry();
    }
}

