/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.persistence.clientsession;

import com.hivemq.codec.encoder.mqtt5.Mqtt5PayloadFormatIndicator;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.extension.sdk.api.annotations.Nullable;
import com.hivemq.mqtt.message.QoS;
import com.hivemq.mqtt.message.connect.MqttWillPublish;
import com.hivemq.mqtt.message.mqtt5.Mqtt5UserProperties;
import com.hivemq.persistence.Sizable;
import com.hivemq.util.ObjectMemoryEstimation;

public class ClientSessionWill
implements Sizable {
    @NotNull
    private final MqttWillPublish mqttWillPublish;
    private final long publishId;
    private int inMemorySize = -1;

    public ClientSessionWill(@NotNull MqttWillPublish mqttWillPublish, long publishId) {
        this.mqttWillPublish = mqttWillPublish;
        this.publishId = publishId;
    }

    @NotNull
    public MqttWillPublish getMqttWillPublish() {
        return this.mqttWillPublish;
    }

    @NotNull
    public long getPublishId() {
        return this.publishId;
    }

    public long getDelayInterval() {
        return this.mqttWillPublish.getDelayInterval();
    }

    @NotNull
    public String getHivemqId() {
        return this.mqttWillPublish.getHivemqId();
    }

    @NotNull
    public String getTopic() {
        return this.mqttWillPublish.getTopic();
    }

    public byte @Nullable [] getPayload() {
        return this.mqttWillPublish.getPayload();
    }

    @NotNull
    public QoS getQos() {
        return this.mqttWillPublish.getQos();
    }

    public boolean isRetain() {
        return this.mqttWillPublish.isRetain();
    }

    public long getMessageExpiryInterval() {
        return this.mqttWillPublish.getMessageExpiryInterval();
    }

    @Nullable
    public Mqtt5PayloadFormatIndicator getPayloadFormatIndicator() {
        return this.mqttWillPublish.getPayloadFormatIndicator();
    }

    @Nullable
    public String getContentType() {
        return this.mqttWillPublish.getContentType();
    }

    @Nullable
    public String getResponseTopic() {
        return this.mqttWillPublish.getResponseTopic();
    }

    @Nullable
    public @Nullable byte @Nullable [] getCorrelationData() {
        return this.mqttWillPublish.getCorrelationData();
    }

    @NotNull
    public Mqtt5UserProperties getUserProperties() {
        return this.mqttWillPublish.getUserProperties();
    }

    @NotNull
    public ClientSessionWill deepCopy() {
        return new ClientSessionWill(this.getMqttWillPublish().deepCopy(), this.getPublishId());
    }

    @Override
    public int getEstimatedSize() {
        if (this.inMemorySize != -1) {
            return this.inMemorySize;
        }
        int size = ObjectMemoryEstimation.objectShellSize();
        size += ObjectMemoryEstimation.intSize();
        size += ObjectMemoryEstimation.longWrapperSize();
        size += ObjectMemoryEstimation.objectRefSize();
        this.inMemorySize = size += this.mqttWillPublish.getEstimatedSize();
        return this.inMemorySize;
    }
}

