/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.persistence.ioc;

import com.google.inject.Injector;
import com.hivemq.bootstrap.ioc.SingletonModule;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.extension.sdk.api.annotations.Nullable;
import com.hivemq.persistence.clientqueue.ClientQueueLocalPersistence;
import com.hivemq.persistence.local.ClientSessionLocalPersistence;
import com.hivemq.persistence.local.ClientSessionSubscriptionLocalPersistence;
import com.hivemq.persistence.local.memory.ClientQueueMemoryLocalPersistence;
import com.hivemq.persistence.local.memory.ClientSessionMemoryLocalPersistence;
import com.hivemq.persistence.local.memory.ClientSessionSubscriptionMemoryLocalPersistence;
import com.hivemq.persistence.local.memory.RetainedMessageMemoryLocalPersistence;
import com.hivemq.persistence.retained.RetainedMessageLocalPersistence;
import javax.inject.Singleton;

class LocalPersistenceMemoryModule
extends SingletonModule<Class<LocalPersistenceMemoryModule>> {
    @Nullable
    private final Injector injector;

    public LocalPersistenceMemoryModule(@Nullable Injector injector) {
        super(LocalPersistenceMemoryModule.class);
        this.injector = injector;
    }

    protected void configure() {
        this.bindLocalPersistence(RetainedMessageLocalPersistence.class, RetainedMessageMemoryLocalPersistence.class);
        this.bindLocalPersistence(ClientSessionSubscriptionLocalPersistence.class, ClientSessionSubscriptionMemoryLocalPersistence.class);
        this.bindLocalPersistence(ClientSessionLocalPersistence.class, ClientSessionMemoryLocalPersistence.class);
        this.bindLocalPersistence(ClientQueueLocalPersistence.class, ClientQueueMemoryLocalPersistence.class);
    }

    private void bindLocalPersistence(@NotNull Class localPersistenceClass, @NotNull Class localPersistenceImplClass) {
        Object instance;
        Object object = instance = this.injector == null ? null : this.injector.getInstance(localPersistenceImplClass);
        if (instance != null) {
            this.bind(localPersistenceImplClass).toInstance(instance);
            this.bind(localPersistenceClass).toInstance(instance);
        } else {
            this.bind(localPersistenceClass).to(localPersistenceImplClass).in(Singleton.class);
        }
    }
}

