/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.persistence.ioc.provider.local;

import com.google.common.util.concurrent.ListeningScheduledExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.hivemq.bootstrap.ioc.lazysingleton.LazySingleton;
import com.hivemq.configuration.service.InternalConfigurations;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.extension.sdk.api.annotations.Nullable;
import com.hivemq.persistence.ioc.annotation.PayloadPersistence;
import com.hivemq.util.ThreadFactoryUtil;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import javax.inject.Provider;

@LazySingleton
public class PayloadPersistenceScheduledExecutorProvider
implements Provider<ListeningScheduledExecutorService> {
    @Nullable
    private ListeningScheduledExecutorService executorService;

    @LazySingleton
    @PayloadPersistence
    @NotNull
    public ListeningScheduledExecutorService get() {
        if (this.executorService == null) {
            ThreadFactory threadFactory = ThreadFactoryUtil.create("payload-persistence-cleanup-%d");
            int coreSize = InternalConfigurations.PAYLOAD_PERSISTENCE_CLEANUP_THREADS.get();
            ScheduledExecutorService scheduledExecutorService = Executors.newScheduledThreadPool(coreSize, threadFactory);
            this.executorService = MoreExecutors.listeningDecorator((ScheduledExecutorService)scheduledExecutorService);
        }
        return this.executorService;
    }
}

