/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.security.ssl;

import com.hivemq.configuration.service.entity.Tls;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.extension.sdk.api.annotations.Nullable;
import com.hivemq.security.exception.SslException;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManagerFactory;
import org.apache.commons.lang3.StringUtils;

public final class SslUtil {
    @NotNull
    public static KeyManagerFactory getKeyManagerFactory(@NotNull Tls tls) throws SslException {
        return SslUtil.createKeyManagerFactory(tls.getKeystoreType(), tls.getKeystorePath(), tls.getKeystorePassword(), tls.getPrivateKeyPassword());
    }

    @NotNull
    public static KeyManagerFactory createKeyManagerFactory(@NotNull String keyStoreType, @NotNull String keyStorePath, @NotNull String keyStorePassword, @NotNull String privateKeyPassword) {
        KeyManagerFactory keyManagerFactory;
        FileInputStream fileInputStream = new FileInputStream(keyStorePath);
        try {
            KeyStore keyStore = KeyStore.getInstance(keyStoreType);
            keyStore.load(fileInputStream, keyStorePassword.toCharArray());
            KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            kmf.init(keyStore, privateKeyPassword.toCharArray());
            keyManagerFactory = kmf;
        }
        catch (Throwable throwable) {
            try {
                try {
                    fileInputStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (UnrecoverableKeyException e1) {
                throw new SslException("Not able to recover key from KeyStore, please check your private-key-password and your keyStorePassword", e1);
            }
            catch (FileNotFoundException e) {
                throw new SslException("Cannot find KeyStore at path '" + keyStorePath + "'");
            }
            catch (IOException | KeyStoreException e) {
                throw new SslException(String.format("Not able to open or read KeyStore '%s' with type '%s'", keyStorePath, keyStoreType), e);
            }
            catch (NoSuchAlgorithmException | CertificateException e) {
                throw new SslException("Not able to read the certificate from KeyStore '" + keyStorePath + "'", e);
            }
        }
        fileInputStream.close();
        return keyManagerFactory;
    }

    @Nullable
    public static TrustManagerFactory getTrustManagerFactory(@NotNull Tls tls) throws SslException {
        return StringUtils.isNotBlank((CharSequence)tls.getTruststorePath()) && tls.getTruststoreType() != null && tls.getTruststorePassword() != null ? SslUtil.createTrustManagerFactory(tls.getTruststoreType(), tls.getTruststorePath(), tls.getTruststorePassword()) : null;
    }

    @NotNull
    public static TrustManagerFactory createTrustManagerFactory(@NotNull String trustStoreType, @NotNull String trustStorePath, @NotNull String trustStorePassword) {
        TrustManagerFactory trustManagerFactory;
        FileInputStream fileInputStream = new FileInputStream(trustStorePath);
        try {
            KeyStore keyStoreTrust = KeyStore.getInstance(trustStoreType);
            keyStoreTrust.load(fileInputStream, trustStorePassword.toCharArray());
            TrustManagerFactory tmFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            tmFactory.init(keyStoreTrust);
            trustManagerFactory = tmFactory;
        }
        catch (Throwable throwable) {
            try {
                try {
                    fileInputStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (FileNotFoundException e) {
                throw new SslException("Cannot find TrustStore at path '" + trustStorePath + "'");
            }
            catch (IOException | KeyStoreException e) {
                throw new SslException(String.format("Not able to open or read TrustStore '%s' with type '%s'", trustStorePath, trustStoreType), e);
            }
            catch (NoSuchAlgorithmException | CertificateException e) {
                throw new SslException("Not able to read the certificate from TrustStore '" + trustStorePath + "'", e);
            }
        }
        fileInputStream.close();
        return trustManagerFactory;
    }

    private SslUtil() {
    }
}

