/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.util;

import com.hivemq.exceptions.UnrecoverableException;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.extension.sdk.api.annotations.Nullable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class EnvVarUtil {
    private static final Logger log = LoggerFactory.getLogger(EnvVarUtil.class);
    @NotNull
    private static final String ENV_VAR_PATTERN = "\\$\\{(ENV:)*(.*?)}";

    @Nullable
    public String getValue(@NotNull String name) {
        String systemProperty = System.getProperty(name);
        if (systemProperty != null) {
            return systemProperty;
        }
        return System.getenv(name);
    }

    @NotNull
    public String replaceEnvironmentVariablePlaceholders(@NotNull String text) {
        StringBuffer resultString = new StringBuffer();
        Matcher matcher = Pattern.compile(ENV_VAR_PATTERN).matcher(text);
        while (matcher.find()) {
            if (matcher.groupCount() < 2) {
                log.warn("Found unexpected environment variable placeholder in config.xml");
                matcher.appendReplacement(resultString, "");
                continue;
            }
            String varName = matcher.group(2);
            String replacement = this.getValue(varName);
            if (replacement == null) {
                log.error("Environment Variable {} for HiveMQ config.xml is not set.", (Object)varName);
                throw new UnrecoverableException(false);
            }
            matcher.appendReplacement(resultString, this.escapeReplacement(replacement));
        }
        matcher.appendTail(resultString);
        return resultString.toString();
    }

    @NotNull
    private String escapeReplacement(@NotNull String replacement) {
        return replacement.replace("\\", "\\\\").replace("$", "\\$");
    }
}

