/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.util;

import com.google.common.base.Preconditions;
import com.google.common.base.Utf8;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import io.netty.buffer.ByteBuf;

public class Utf8Utils {
    public static boolean stringIsOneByteCharsOnly(CharSequence sequence) {
        int len = sequence.length();
        for (int i = 0; i < len; ++i) {
            char ch = sequence.charAt(i);
            if (ch <= '\u007f') continue;
            return false;
        }
        return true;
    }

    public static int encodedLength(CharSequence sequence) {
        int count = 0;
        int len = sequence.length();
        for (int i = 0; i < len; ++i) {
            char c = sequence.charAt(i);
            if (c <= '\u007f') {
                ++count;
                continue;
            }
            if (c <= '\u07ff') {
                count += 2;
                continue;
            }
            if (Character.isHighSurrogate(c)) {
                count += 4;
                ++i;
                continue;
            }
            count += 3;
        }
        return count;
    }

    public static boolean hasControlOrNonCharacter(byte @NotNull [] bytes) {
        Preconditions.checkNotNull((Object)bytes);
        for (int i = 0; i < bytes.length; ++i) {
            byte byte1 = bytes[i];
            if (byte1 >= 1 && byte1 <= 31 || byte1 == 127) {
                return true;
            }
            if (byte1 > 31) continue;
            if (byte1 < -32) {
                if (i == bytes.length - 1) {
                    return false;
                }
                if (byte1 != -62 || bytes[i + 1] > -97) continue;
                return true;
            }
            if (byte1 < -16) {
                if (i == bytes.length - 2) continue;
                if (byte1 == -17 && bytes[i + 1] == -73 && (bytes[i + 2] >= -112 || bytes[i + 2] <= -81)) {
                    return true;
                }
                if (byte1 != -17 || bytes[i + 1] != -65 || bytes[i + 2] != -66 && bytes[i + 2] != -65) continue;
                return true;
            }
            if (i == bytes.length - 3 || byte1 > -12) continue;
            byte byte2 = bytes[i + 1];
            byte byte3 = bytes[i + 2];
            byte byte4 = bytes[i + 3];
            if (byte3 != -65 || byte4 != -66 && byte4 != -65 || !(byte1 == -16 ? byte2 == -97 || byte2 == -81 || byte2 == -65 : byte2 == -113 || byte2 == -97 || byte2 == -81 || byte2 == -65)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasControlOrNonCharacter(@NotNull String text) {
        Preconditions.checkNotNull((Object)text);
        for (int i = 0; i < text.length(); ++i) {
            char character = text.charAt(i);
            if (character >= '\u0001' && character <= '\u001f' || character >= '\u007f' && character <= '\u009f') {
                return true;
            }
            if (character >= '\ufdd0' && character <= '\ufdef' || character == '\ufffe' || character == '\uffff') {
                return true;
            }
            if (i == text.length() - 1) {
                return false;
            }
            char next = text.charAt(i + 1);
            if (character == '\ud83f' && (next == '\udffe' || next == '\udfff')) {
                return true;
            }
            if (character == '\ud87f' && (next == '\udffe' || next == '\udfff')) {
                return true;
            }
            if (character == '\ud8bf' && (next == '\udffe' || next == '\udfff')) {
                return true;
            }
            if (character == '\ud8ff' && (next == '\udffe' || next == '\udfff')) {
                return true;
            }
            if (character == '\ud93f' && (next == '\udffe' || next == '\udfff')) {
                return true;
            }
            if (character == '\ud97f' && (next == '\udffe' || next == '\udfff')) {
                return true;
            }
            if (character == '\ud9bf' && (next == '\udffe' || next == '\udfff')) {
                return true;
            }
            if (character == '\ud9ff' && (next == '\udffe' || next == '\udfff')) {
                return true;
            }
            if (character == '\uda3f' && (next == '\udffe' || next == '\udfff')) {
                return true;
            }
            if (character == '\uda7f' && (next == '\udffe' || next == '\udfff')) {
                return true;
            }
            if (character == '\udabf' && (next == '\udffe' || next == '\udfff')) {
                return true;
            }
            if (character == '\udaff' && (next == '\udffe' || next == '\udfff')) {
                return true;
            }
            if (character == '\udb3f' && (next == '\udffe' || next == '\udfff')) {
                return true;
            }
            if (character == '\udb7f' && (next == '\udffe' || next == '\udfff')) {
                return true;
            }
            if (character == '\udbbf' && (next == '\udffe' || next == '\udfff')) {
                return true;
            }
            if (character != '\udbff' || next != '\udffe' && next != '\udfff') continue;
            return true;
        }
        return false;
    }

    public static boolean isWellFormed(@NotNull ByteBuf byteBuf, int utf8StringLength) {
        Preconditions.checkNotNull((Object)byteBuf);
        byteBuf.markReaderIndex();
        boolean wellFormed = Utf8Utils.isSliceWellFormed(byteBuf.slice(byteBuf.readerIndex(), utf8StringLength), utf8StringLength);
        byteBuf.resetReaderIndex();
        return wellFormed;
    }

    private static boolean isSliceWellFormed(ByteBuf byteBuf, int len) {
        Preconditions.checkPositionIndexes((int)0, (int)len, (int)byteBuf.readableBytes());
        for (int i = 0; i < len; ++i) {
            byteBuf.markReaderIndex();
            if (byteBuf.readByte() >= 0) continue;
            byteBuf.resetReaderIndex();
            return Utf8Utils.isWellFormedSlowPath(byteBuf);
        }
        return true;
    }

    private static boolean isWellFormedSlowPath(ByteBuf byteBuf) {
        while (true) {
            byte byte2;
            if (byteBuf.readableBytes() == 0) {
                return true;
            }
            byte byte1 = byteBuf.readByte();
            if (byte1 >= 0) continue;
            if (byte1 < -32) {
                if (byteBuf.readableBytes() == 0) {
                    return false;
                }
                if (byte1 >= -62 && byteBuf.readByte() <= -65) continue;
                return false;
            }
            if (byte1 < -16) {
                if (byteBuf.readableBytes() < 2) {
                    return false;
                }
                byte2 = byteBuf.readByte();
                if (!(byte2 > -65 || byte1 == -32 && byte2 < -96 || byte1 == -19 && -96 <= byte2) && byteBuf.readByte() <= -65) continue;
                return false;
            }
            if (byteBuf.readableBytes() < 3) {
                return false;
            }
            byte2 = byteBuf.readByte();
            if (byte2 > -65 || (byte1 << 28) + (byte2 - -112) >> 30 != 0 || byteBuf.readByte() > -65 || byteBuf.readByte() > -65) break;
        }
        return false;
    }

    public static boolean containsMustNotCharacters(@NotNull byte[] binary) {
        if (!Utf8.isWellFormed((byte[])binary)) {
            return true;
        }
        for (byte b : binary) {
            if (b != 0) continue;
            return true;
        }
        return false;
    }

    public static boolean containsMustNotCharacters(@NotNull String string) {
        boolean highSurrogate = false;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '\u0000') {
                return true;
            }
            if (highSurrogate == !Character.isLowSurrogate(c)) {
                return true;
            }
            highSurrogate = Character.isHighSurrogate(c);
        }
        return highSurrogate;
    }
}

