/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.core.dataStructures;

import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import org.jetbrains.annotations.NotNull;

public class NanoSet<E>
extends AbstractSet<E> {
    @NotNull
    private final E element;

    public NanoSet(@NotNull E element) {
        this.element = element;
    }

    @Override
    public Iterator<E> iterator() {
        return new NanoIterator(this);
    }

    @Override
    public int size() {
        return 1;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public boolean contains(Object o) {
        return this.element == o || this.element.equals(o);
    }

    @Override
    public boolean add(E e) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    private static class NanoIterator<E>
    implements Iterator<E> {
        private E element;

        private NanoIterator(NanoSet<E> set) {
            this.element = ((NanoSet)set).element;
        }

        @Override
        public boolean hasNext() {
            return this.element != null;
        }

        @Override
        public E next() {
            E result = this.element;
            this.element = null;
            return result;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

