/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.util;

import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import jetbrains.exodus.util.ByteArraySpinAllocator;
import org.jetbrains.annotations.NotNull;

public class IOUtil {
    public static final int READ_BUFFER_SIZE = 16384;
    public static final ByteArraySpinAllocator BUFFER_ALLOCATOR = new ByteArraySpinAllocator(16384);
    private static final String BLOCK_SIZE = "exodus.io.blockSize";
    private static final File[] NO_FILES = new File[0];

    private IOUtil() {
    }

    public static long getBlockSize() {
        return Long.getLong(BLOCK_SIZE, 4096L);
    }

    public static long getAdjustedFileLength(File file) {
        long blockSize = IOUtil.getBlockSize();
        return (file.length() + blockSize - 1L) / blockSize * blockSize;
    }

    public static long getDirectorySize(File dir, final String extension, boolean recursive) {
        long sum = 0L;
        if (recursive) {
            for (File childDir : IOUtil.listFiles(dir, new FileFilter(){

                @Override
                public boolean accept(File pathname) {
                    return pathname.isDirectory();
                }
            })) {
                sum += IOUtil.getDirectorySize(childDir, extension, recursive);
            }
        }
        for (File file : IOUtil.listFiles(dir, new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(extension);
            }
        })) {
            sum += IOUtil.getAdjustedFileLength(file);
        }
        return sum;
    }

    public static void copyStreams(@NotNull InputStream source, @NotNull OutputStream target, @NotNull ByteArraySpinAllocator bufferAllocator) throws IOException {
        IOUtil.copyStreams(source, Long.MAX_VALUE, target, bufferAllocator);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyStreams(@NotNull InputStream source, long sourceLen, @NotNull OutputStream target, @NotNull ByteArraySpinAllocator bufferAllocator) throws IOException {
        byte[] buffer = (byte[])bufferAllocator.alloc();
        try {
            int read;
            long totalRead = 0L;
            while (totalRead < sourceLen && (read = source.read(buffer)) >= 0) {
                if (read <= 0) continue;
                read = (int)Math.min(sourceLen - totalRead, (long)read);
                target.write(buffer, 0, read);
                totalRead += (long)read;
            }
        }
        finally {
            bufferAllocator.dispose(buffer);
        }
    }

    public static void deleteRecursively(File dir) {
        for (File file : IOUtil.listFiles(dir)) {
            if (file.isDirectory()) {
                IOUtil.deleteRecursively(file);
            }
            IOUtil.deleteFile(file);
        }
    }

    public static void deleteFile(File file) {
        if (!file.delete()) {
            file.deleteOnExit();
        }
    }

    @NotNull
    public static File[] listFiles(@NotNull File directory) {
        File[] result = directory.listFiles();
        return result == null ? NO_FILES : result;
    }

    @NotNull
    public static File[] listFiles(@NotNull File directory, @NotNull FilenameFilter filter) {
        File[] result = directory.listFiles(filter);
        return result == null ? NO_FILES : result;
    }

    @NotNull
    public static File[] listFiles(@NotNull File directory, @NotNull FileFilter filter) {
        File[] result = directory.listFiles(filter);
        return result == null ? NO_FILES : result;
    }

    public static int readFully(@NotNull InputStream input, @NotNull byte[] bytes) throws IOException {
        return IOUtil.readFully(input, bytes, bytes.length);
    }

    public static int readFully(@NotNull InputStream input, @NotNull byte[] bytes, int len) throws IOException {
        int off;
        int read;
        for (off = 0; off < len && (read = input.read(bytes, off, len - off)) >= 0; off += read) {
        }
        return off;
    }
}

