/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.aas.aggregator.observing;

import java.util.Collection;
import org.eclipse.basyx.aas.aggregator.api.IAASAggregator;
import org.eclipse.basyx.aas.aggregator.observing.IAASAggregatorObserverV2;
import org.eclipse.basyx.aas.metamodel.api.IAssetAdministrationShell;
import org.eclipse.basyx.aas.metamodel.map.AssetAdministrationShell;
import org.eclipse.basyx.submodel.metamodel.api.identifier.IIdentifier;
import org.eclipse.basyx.submodel.observer.Observable;
import org.eclipse.basyx.vab.exception.provider.ResourceNotFoundException;
import org.eclipse.basyx.vab.modelprovider.api.IModelProvider;

public class ObservableAASAggregatorV2
extends Observable<IAASAggregatorObserverV2>
implements IAASAggregator {
    private IAASAggregator aasAggregator;
    private String aasServerId = "aas-server";

    public ObservableAASAggregatorV2(IAASAggregator aggregator, String aasServerId) {
        this.aasAggregator = aggregator;
        this.aasServerId = aasServerId;
    }

    public String getAasServerId() {
        return this.aasServerId;
    }

    @Override
    public Collection<IAssetAdministrationShell> getAASList() {
        return this.aasAggregator.getAASList();
    }

    @Override
    public IAssetAdministrationShell getAAS(IIdentifier aasId) throws ResourceNotFoundException {
        return this.aasAggregator.getAAS(aasId);
    }

    @Override
    public IModelProvider getAASProvider(IIdentifier aasId) throws ResourceNotFoundException {
        return this.aasAggregator.getAASProvider(aasId);
    }

    @Override
    public void createAAS(AssetAdministrationShell aas) {
        this.aasAggregator.createAAS(aas);
        this.observers.stream().forEach(o -> o.aasCreated(aas, this.aasServerId));
    }

    @Override
    public void updateAAS(AssetAdministrationShell aas) throws ResourceNotFoundException {
        this.aasAggregator.updateAAS(aas);
        this.observers.stream().forEach(o -> o.aasUpdated(aas, this.aasServerId));
    }

    @Override
    public void deleteAAS(IIdentifier aasId) {
        IAssetAdministrationShell aas = this.aasAggregator.getAAS(aasId);
        this.aasAggregator.deleteAAS(aasId);
        this.observers.stream().forEach(o -> o.aasDeleted(aas, this.aasServerId));
    }
}

