/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.aas.factory.xml;

import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.basyx.aas.factory.xml.api.parts.AssetXMLConverter;
import org.eclipse.basyx.aas.factory.xml.converters.AssetAdministrationShellXMLConverter;
import org.eclipse.basyx.aas.metamodel.api.IAssetAdministrationShell;
import org.eclipse.basyx.aas.metamodel.api.parts.asset.IAsset;
import org.eclipse.basyx.aas.metamodel.map.AasEnv;
import org.eclipse.basyx.submodel.factory.xml.api.parts.ConceptDescriptionXMLConverter;
import org.eclipse.basyx.submodel.factory.xml.converters.SubmodelXMLConverter;
import org.eclipse.basyx.submodel.metamodel.api.ISubmodel;
import org.eclipse.basyx.submodel.metamodel.api.parts.IConceptDescription;
import org.eclipse.basyx.vab.factory.xml.XmlParser;
import org.xml.sax.SAXException;

public class XMLToMetamodelConverter {
    private AasEnv aasEnv;

    public XMLToMetamodelConverter(String xmlContent) throws ParserConfigurationException, SAXException, IOException {
        LinkedHashMap root = new LinkedHashMap();
        root.putAll((Map)XmlParser.buildXmlMap(xmlContent).get("aas:aasenv"));
        Map xmlAASs = (Map)root.get("aas:assetAdministrationShells");
        Map xmlConceptDescriptions = (Map)root.get("aas:conceptDescriptions");
        List<IConceptDescription> conceptDescriptions = ConceptDescriptionXMLConverter.parseConceptDescriptions(xmlConceptDescriptions);
        List<IAssetAdministrationShell> shells = AssetAdministrationShellXMLConverter.parseAssetAdministrationShells(xmlAASs, conceptDescriptions);
        Map xmlSubmodels = (Map)root.get("aas:submodels");
        List<ISubmodel> submodels = SubmodelXMLConverter.parseSubmodels(xmlSubmodels);
        Map xmlAssets = (Map)root.get("aas:assets");
        List<IAsset> assets = AssetXMLConverter.parseAssets(xmlAssets);
        this.aasEnv = new AasEnv(shells, assets, conceptDescriptions, submodels);
    }

    public AasEnv parseAasEnv() {
        return this.aasEnv;
    }

    public List<IAssetAdministrationShell> parseAAS() throws ParserConfigurationException, SAXException, IOException {
        return new ArrayList<IAssetAdministrationShell>(this.aasEnv.getAssetAdministrationShells());
    }

    public List<IAsset> parseAssets() throws ParserConfigurationException, SAXException, IOException {
        return new ArrayList<IAsset>(this.aasEnv.getAssets());
    }

    public List<ISubmodel> parseSubmodels() {
        return new ArrayList<ISubmodel>(this.aasEnv.getSubmodels());
    }

    public List<IConceptDescription> parseConceptDescriptions() {
        return new ArrayList<IConceptDescription>(this.aasEnv.getConceptDescriptions());
    }
}

