/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.extensions.aas.directory.tagged.proxy;

import java.util.Collection;
import java.util.Set;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import org.eclipse.basyx.aas.registration.proxy.AASRegistryProxy;
import org.eclipse.basyx.extensions.aas.directory.tagged.api.IAASTaggedDirectory;
import org.eclipse.basyx.extensions.aas.directory.tagged.api.TaggedAASDescriptor;
import org.eclipse.basyx.extensions.aas.directory.tagged.api.TaggedSubmodelDescriptor;
import org.eclipse.basyx.submodel.metamodel.api.identifier.IIdentifier;
import org.eclipse.basyx.vab.coder.json.connector.JSONConnector;
import org.eclipse.basyx.vab.modelprovider.VABElementProxy;
import org.eclipse.basyx.vab.modelprovider.VABPathTools;
import org.eclipse.basyx.vab.modelprovider.api.IModelProvider;
import org.eclipse.basyx.vab.protocol.http.connector.HTTPConnector;

public class TaggedDirectoryProxy
extends AASRegistryProxy
implements IAASTaggedDirectory {
    private IModelProvider taggedProvider;

    public TaggedDirectoryProxy(String registryUrl) {
        super(registryUrl);
        this.taggedProvider = TaggedDirectoryProxy.createTaggedProxy(new JSONConnector(new HTTPConnector(registryUrl)));
    }

    public TaggedDirectoryProxy(IModelProvider provider) {
        super(provider);
        this.taggedProvider = TaggedDirectoryProxy.createTaggedProxy(provider);
    }

    private static VABElementProxy createTaggedProxy(IModelProvider provider) {
        return new VABElementProxy("api/v1/directory", provider);
    }

    @Override
    public void register(TaggedAASDescriptor descriptor) {
        this.taggedProvider.createValue(VABPathTools.encodePathElement(descriptor.getIdentifier().getId()), descriptor);
    }

    @Override
    public void registerSubmodel(IIdentifier aas, TaggedSubmodelDescriptor smDescriptor) {
        this.taggedProvider.createValue(VABPathTools.encodePathElement(aas.getId() + "/submodels/" + smDescriptor.getIdentifier().getId()), smDescriptor);
    }

    @Override
    public Set<TaggedSubmodelDescriptor> lookupBothAasAndSubmodelTags(Set<String> aasTags, Set<String> submodelTags) {
        String aasTagsList = this.joinTagsAsString(aasTags);
        String submodelTagsList = this.joinTagsAsString(submodelTags);
        return this.performCombinedTagRequest(aasTagsList, submodelTagsList);
    }

    private Set<TaggedSubmodelDescriptor> performCombinedTagRequest(String aasTagList, String submodelTagList) {
        Collection desc = (Collection)this.taggedProvider.getValue("?tags=" + aasTagList + "&submodelTags=" + submodelTagList);
        return desc.stream().map(TaggedSubmodelDescriptor::createAsFacade).collect(Collectors.toSet());
    }

    @Override
    public Set<TaggedAASDescriptor> lookupTag(String tag) {
        return this.performTagRequest(tag);
    }

    @Override
    public Set<TaggedAASDescriptor> lookupTags(Set<String> tags) {
        return this.performTagRequest(this.joinTagsAsString(tags));
    }

    private Set<TaggedAASDescriptor> performTagRequest(String tagList) {
        Collection desc = (Collection)this.taggedProvider.getValue("?tags=" + tagList);
        return desc.stream().map(m -> TaggedAASDescriptor.createAsFacade(m)).collect(Collectors.toSet());
    }

    @Override
    public Set<TaggedSubmodelDescriptor> lookupSubmodelTag(String submodelTag) {
        return this.performSubmodelTagRequest(submodelTag);
    }

    @Override
    public Set<TaggedSubmodelDescriptor> lookupSubmodelTags(Set<String> tags) {
        return this.performSubmodelTagRequest(this.joinTagsAsString(tags));
    }

    private Set<TaggedSubmodelDescriptor> performSubmodelTagRequest(String submodelTagList) {
        Collection desc = (Collection)this.taggedProvider.getValue("?submodelTags=" + submodelTagList);
        return desc.stream().map(m -> TaggedSubmodelDescriptor.createAsFacade(m)).collect(Collectors.toSet());
    }

    private String joinTagsAsString(Set<String> tags) {
        StringJoiner joiner = new StringJoiner(",");
        tags.stream().forEach(joiner::add);
        return joiner.toString();
    }
}

