/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.extensions.aas.registration.mqtt;

import org.eclipse.basyx.aas.metamodel.map.descriptor.AASDescriptor;
import org.eclipse.basyx.aas.metamodel.map.descriptor.ModelDescriptor;
import org.eclipse.basyx.aas.metamodel.map.descriptor.SubmodelDescriptor;
import org.eclipse.basyx.aas.registration.observing.IAASRegistryServiceObserverV2;
import org.eclipse.basyx.extensions.aas.registration.mqtt.MqttV2AASRegistryTopicFactory;
import org.eclipse.basyx.extensions.shared.mqtt.MqttEventService;
import org.eclipse.basyx.submodel.metamodel.api.identifier.IIdentifier;
import org.eclipse.basyx.vab.coder.json.serialization.DefaultTypeFactory;
import org.eclipse.basyx.vab.coder.json.serialization.GSONTools;
import org.eclipse.basyx.vab.coder.json.serialization.Serializer;
import org.eclipse.paho.client.mqttv3.MqttClient;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MqttV2AASRegistryServiceObserver
extends MqttEventService
implements IAASRegistryServiceObserverV2 {
    private static Logger logger = LoggerFactory.getLogger(MqttV2AASRegistryServiceObserver.class);
    private MqttV2AASRegistryTopicFactory topicFactory;
    private Serializer payloadSerializer;

    public MqttV2AASRegistryServiceObserver(MqttClient client, MqttV2AASRegistryTopicFactory topicFactory) throws MqttException {
        this(client, topicFactory, MqttV2AASRegistryServiceObserver.createGSONTools());
    }

    public MqttV2AASRegistryServiceObserver(MqttClient client, MqttV2AASRegistryTopicFactory topicFactory, Serializer payloadSerializer) throws MqttException {
        super(client);
        this.topicFactory = topicFactory;
        this.payloadSerializer = payloadSerializer;
        logger.info("Create new MQTT AAS Registry Service Observer for endpoint " + client.getServerURI());
    }

    @Override
    public void aasRegistered(AASDescriptor aasDescriptor, String registryId) {
        this.sendMqttMessage(this.topicFactory.createCreateAASTopic(registryId), this.serializePayload(aasDescriptor));
    }

    @Override
    public void submodelRegistered(IIdentifier aasId, SubmodelDescriptor smDescriptor, String registryId) {
        this.sendMqttMessage(this.topicFactory.createCreateSubmodelTopic(registryId), this.serializePayload(smDescriptor));
        this.sendMqttMessage(this.topicFactory.createCreateSubmodelTopicWithAASId(aasId.getId(), registryId), this.serializePayload(smDescriptor));
    }

    @Override
    public void aasUpdated(AASDescriptor aasDescriptor, String registryId) {
        this.sendMqttMessage(this.topicFactory.createUpdateAASTopic(registryId), this.serializePayload(aasDescriptor));
    }

    @Override
    public void submodelUpdated(IIdentifier aasId, SubmodelDescriptor smDescriptor, String registryId) {
        this.sendMqttMessage(this.topicFactory.createUpdateSubmodelTopic(registryId), this.serializePayload(smDescriptor));
        this.sendMqttMessage(this.topicFactory.createUpdateSubmodelTopicWithAASId(aasId.getId(), registryId), this.serializePayload(smDescriptor));
    }

    @Override
    public void aasDeleted(AASDescriptor aasDescriptor, String registryId) {
        this.sendMqttMessage(this.topicFactory.createDeleteAASTopic(registryId), this.serializePayload(aasDescriptor));
    }

    @Override
    public void submodelDeleted(IIdentifier aasId, SubmodelDescriptor smDescriptor, String registryId) {
        this.sendMqttMessage(this.topicFactory.createDeleteSubmodelTopic(registryId), this.serializePayload(smDescriptor));
        this.sendMqttMessage(this.topicFactory.createDeleteSubmodelTopicWithAASId(aasId.getId(), registryId), this.serializePayload(smDescriptor));
    }

    private String serializePayload(ModelDescriptor descriptor) {
        return this.payloadSerializer.serialize(descriptor);
    }

    private static GSONTools createGSONTools() {
        return new GSONTools(new DefaultTypeFactory(), false, false);
    }
}

