/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.submodel.factory.xml.converters.submodelelement.entity;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.eclipse.basyx.submodel.factory.xml.XMLHelper;
import org.eclipse.basyx.submodel.factory.xml.converters.reference.ReferenceXMLConverter;
import org.eclipse.basyx.submodel.factory.xml.converters.submodelelement.SubmodelElementXMLConverter;
import org.eclipse.basyx.submodel.metamodel.api.reference.IReference;
import org.eclipse.basyx.submodel.metamodel.api.submodelelement.ISubmodelElement;
import org.eclipse.basyx.submodel.metamodel.api.submodelelement.entity.EntityType;
import org.eclipse.basyx.submodel.metamodel.api.submodelelement.entity.IEntity;
import org.eclipse.basyx.submodel.metamodel.map.reference.Reference;
import org.eclipse.basyx.submodel.metamodel.map.submodelelement.entity.Entity;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class EntityXMLConverter
extends SubmodelElementXMLConverter {
    public static final String ENTITY = "aas:entity";
    public static final String ENTITY_TYPE = "aas:entityType";
    public static final String STATEMENTS = "aas:statements";
    public static final String ASSET_REF = "aas:assetRef";

    public static Entity parseEntity(Map<String, Object> xmlObject) {
        String entityTypeString = XMLHelper.getString(xmlObject.get(ENTITY_TYPE));
        EntityType entityType = EntityType.fromString(entityTypeString);
        Map xmlAssetRef = (Map)xmlObject.get(ASSET_REF);
        Reference assetRef = ReferenceXMLConverter.parseReference(xmlAssetRef);
        Map xmlStatement = (Map)xmlObject.get(STATEMENTS);
        List<ISubmodelElement> statements = EntityXMLConverter.getSubmodelElements(xmlStatement);
        Entity entity = new Entity(entityType, statements, assetRef);
        EntityXMLConverter.populateSubmodelElement(xmlObject, entity);
        return entity;
    }

    public static Element buildEntity(Document document, IEntity entity) {
        Collection<ISubmodelElement> statement;
        EntityType entityTypeObj;
        String entityType;
        Element entityRoot = document.createElement(ENTITY);
        EntityXMLConverter.populateSubmodelElement(document, entityRoot, entity);
        IReference assetRef = entity.getAsset();
        if (assetRef != null) {
            Element assetRefRoot = document.createElement(ASSET_REF);
            assetRefRoot.appendChild(ReferenceXMLConverter.buildReferenceXML(document, assetRef));
            entityRoot.appendChild(assetRefRoot);
        }
        String string = entityType = (entityTypeObj = entity.getEntityType()) == null ? null : ((Object)entityTypeObj).toString();
        if (entityType != null) {
            Element entityTypeRoot = document.createElement(ENTITY_TYPE);
            entityTypeRoot.appendChild(document.createTextNode(entityType));
            entityRoot.appendChild(entityTypeRoot);
        }
        if ((statement = entity.getStatements()) != null) {
            Element statementsRoot = document.createElement(STATEMENTS);
            entityRoot.appendChild(statementsRoot);
            EntityXMLConverter.buildSubmodelElements(document, statementsRoot, statement);
        }
        return entityRoot;
    }
}

