/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.submodel.metamodel.map.reference;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.basyx.aas.metamodel.exception.MetamodelConstructionException;
import org.eclipse.basyx.submodel.metamodel.api.identifier.IIdentifier;
import org.eclipse.basyx.submodel.metamodel.api.qualifier.IIdentifiable;
import org.eclipse.basyx.submodel.metamodel.api.reference.IKey;
import org.eclipse.basyx.submodel.metamodel.api.reference.IReference;
import org.eclipse.basyx.submodel.metamodel.api.reference.enums.KeyElements;
import org.eclipse.basyx.submodel.metamodel.map.reference.Key;
import org.eclipse.basyx.vab.model.VABModelMap;

public class Reference
extends VABModelMap<Object>
implements IReference {
    public static final String KEY = "keys";

    public Reference() {
        this.setKeys(new ArrayList<IKey>());
    }

    public Reference(IIdentifiable identifiable, KeyElements keyElement, boolean local) {
        this(identifiable.getIdentification(), keyElement, local);
    }

    public Reference(IIdentifier identifier, KeyElements keyElement, boolean local) {
        this(new Key(keyElement, local, identifier.getId(), identifier.getIdType()));
    }

    public Reference(List<IKey> keys) {
        this.setKeys(keys);
    }

    public Reference(Key key) {
        this(Collections.singletonList(key));
    }

    public static Reference createAsFacade(Map<String, Object> map) {
        if (map == null) {
            return null;
        }
        if (!Reference.isValid(map)) {
            throw new MetamodelConstructionException(Reference.class, map);
        }
        Reference ret = new Reference();
        ret.setMap(map);
        return ret;
    }

    public static boolean isValid(Map<String, Object> map) {
        if (map != null && map.containsKey(KEY)) {
            Collection keysCollection = (Collection)map.get(KEY);
            for (Map key : keysCollection) {
                if (Key.isValid(key)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static Reference createAsFacadeNonStrict(Map<String, Object> map) {
        if (map == null) {
            return null;
        }
        Reference ret = new Reference();
        ret.setMap(map);
        return ret;
    }

    public static boolean isReference(Object value) {
        if (!(value instanceof Map)) {
            return false;
        }
        Map map = (Map)value;
        if (!(map.get(KEY) instanceof Collection)) {
            return false;
        }
        return ((Collection)map.get(KEY)).stream().allMatch(Key::isKey);
    }

    @Override
    public List<IKey> getKeys() {
        ArrayList<IKey> ret = new ArrayList<IKey>();
        Collection coll = (Collection)this.get(KEY);
        for (Map m : coll) {
            ret.add(Key.createAsFacade(m));
        }
        return ret;
    }

    public void setKeys(List<IKey> keys) {
        ArrayList<Key> copy = new ArrayList<Key>();
        for (IKey key : keys) {
            copy.add(new Key(key.getType(), key.isLocal(), key.getValue(), key.getIdType()));
        }
        this.put(KEY, copy);
    }

    @Override
    public String toString() {
        return "Reference [getKeys()=" + this.getKeys() + "]";
    }
}

