/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.submodel.restapi;

import java.util.Map;
import org.eclipse.basyx.submodel.metamodel.map.submodelelement.dataelement.property.Property;
import org.eclipse.basyx.submodel.metamodel.map.submodelelement.dataelement.property.valuetype.ValueTypeHelper;
import org.eclipse.basyx.vab.exception.provider.MalformedRequestException;
import org.eclipse.basyx.vab.exception.provider.ProviderException;
import org.eclipse.basyx.vab.modelprovider.VABPathTools;
import org.eclipse.basyx.vab.modelprovider.api.IModelProvider;

public class PropertyProvider
implements IModelProvider {
    private IModelProvider proxy;

    public PropertyProvider(IModelProvider proxy) {
        this.proxy = proxy;
    }

    @Override
    public Object getValue(String path) throws ProviderException {
        if (this.isValuePath(path = VABPathTools.stripSlashes(path))) {
            return ValueTypeHelper.prepareForSerialization(this.getProperty().getValue());
        }
        if (path.isEmpty()) {
            return this.getProperty();
        }
        throw new MalformedRequestException("Unknown path: " + path);
    }

    private Property getProperty() {
        return Property.createAsFacade((Map)this.proxy.getValue(""));
    }

    @Override
    public void setValue(String path, Object newValue) throws ProviderException {
        if (!this.isValuePath(path = VABPathTools.stripSlashes(path))) {
            throw new MalformedRequestException("Given Set path '" + path + "' does not end in /value");
        }
        this.updatePropertyValue(newValue);
    }

    private boolean isValuePath(String path) {
        return path.equals("value");
    }

    private void updatePropertyValue(Object newValue) {
        this.proxy.setValue("value", newValue);
        if (this.isValueTypeSet()) {
            return;
        }
        this.updateValueType(newValue);
    }

    private void updateValueType(Object newValue) {
        this.proxy.setValue("valueType", ValueTypeHelper.getType(newValue).toString());
    }

    private boolean isValueTypeSet() {
        return this.proxy.getValue("valueType") != "";
    }

    @Override
    public void createValue(String path, Object newEntity) throws ProviderException {
        throw new MalformedRequestException("Create not allowed at path '" + path + "'");
    }

    @Override
    public void deleteValue(String path) throws ProviderException {
        throw new MalformedRequestException("Delete not allowed at path '" + path + "'");
    }

    @Override
    public void deleteValue(String path, Object obj) throws ProviderException {
        throw new MalformedRequestException("Delete not allowed at path '" + path + "'");
    }

    @Override
    public Object invokeOperation(String path, Object ... parameter) throws ProviderException {
        throw new MalformedRequestException("Invoke not allowed at path '" + path + "'");
    }
}

