/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.submodel.types.digitalnameplate.submodelelementcollections.markings;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.basyx.aas.metamodel.exception.MetamodelConstructionException;
import org.eclipse.basyx.submodel.metamodel.api.identifier.IdentifierType;
import org.eclipse.basyx.submodel.metamodel.api.reference.enums.KeyElements;
import org.eclipse.basyx.submodel.metamodel.api.reference.enums.KeyType;
import org.eclipse.basyx.submodel.metamodel.api.submodelelement.ISubmodelElement;
import org.eclipse.basyx.submodel.metamodel.api.submodelelement.dataelement.IFile;
import org.eclipse.basyx.submodel.metamodel.api.submodelelement.dataelement.IProperty;
import org.eclipse.basyx.submodel.metamodel.facade.SubmodelElementMapCollectionConverter;
import org.eclipse.basyx.submodel.metamodel.map.reference.Key;
import org.eclipse.basyx.submodel.metamodel.map.reference.Reference;
import org.eclipse.basyx.submodel.metamodel.map.submodelelement.SubmodelElementCollection;
import org.eclipse.basyx.submodel.metamodel.map.submodelelement.dataelement.File;
import org.eclipse.basyx.submodel.metamodel.map.submodelelement.dataelement.property.Property;
import org.eclipse.basyx.submodel.metamodel.map.submodelelement.dataelement.property.valuetype.ValueType;
import org.eclipse.basyx.submodel.types.helper.SubmodelElementRetrievalHelper;

public class Marking
extends SubmodelElementCollection {
    public static final String MARKINGNAMEID = "MarkingName";
    public static final String MARKINGFILEID = "MarkingFile";
    public static final String MARKINGADDITIONALTEXTPREFIX = "MarkingAdditionalText";
    public static final Reference SEMANTICID = new Reference(new Key(KeyElements.CONCEPTDESCRIPTION, false, "https://admin-shell.io/zvei/nameplate/0/1/Nameplate/Markings/Marking", KeyType.IRI));

    private Marking() {
    }

    public Marking(String idShort, Property markingName, File markingFile) {
        super(idShort);
        this.setSemanticId(SEMANTICID);
        this.setMarkingAdditionalText(new ArrayList<Property>());
        this.setMarkingName(markingName);
        this.setMarkingFile(markingFile);
    }

    public Marking(String idShort, String markingName, File markingFile) {
        super(idShort);
        this.setSemanticId(SEMANTICID);
        this.setMarkingAdditionalText(new ArrayList<Property>());
        this.setMarkingName(markingName);
        this.setMarkingFile(markingFile);
    }

    public static Marking createAsFacade(Map<String, Object> obj) {
        if (obj == null) {
            return null;
        }
        if (!Marking.isValid(obj)) {
            throw new MetamodelConstructionException(Marking.class, obj);
        }
        Marking marking = new Marking();
        marking.setMap(SubmodelElementMapCollectionConverter.mapToSmECollection(obj));
        return marking;
    }

    private static Marking createAsFacadeNonStrict(Map<String, Object> obj) {
        if (obj == null) {
            return null;
        }
        Marking marking = new Marking();
        marking.setMap(SubmodelElementMapCollectionConverter.mapToSmECollection(obj));
        return marking;
    }

    public static boolean isValid(Map<String, Object> obj) {
        Marking marking = Marking.createAsFacadeNonStrict(obj);
        return SubmodelElementCollection.isValid(obj) && Property.isValid((Map)((Object)marking.getMarkingName())) && File.isValid((Map)((Object)marking.getMarkingFile()));
    }

    public void setMarkingName(Property markingName) {
        this.addSubmodelElement(markingName);
    }

    public void setMarkingName(String markingName) {
        Property markingNameProp = new Property(MARKINGNAMEID, ValueType.String);
        markingNameProp.setSemanticId(new Reference(new Key(KeyElements.CONCEPTDESCRIPTION, false, "https://admin-shell.io/zvei/nameplate/1/0/Nameplate/Markings/Marking/MarkingName", IdentifierType.IRDI)));
        markingNameProp.setValue(markingName);
        this.setMarkingName(markingNameProp);
    }

    public IProperty getMarkingName() {
        return Property.createAsFacade((Map)((Object)this.getSubmodelElement(MARKINGNAMEID)));
    }

    public void setMarkingFile(File markingFile) {
        this.addSubmodelElement(markingFile);
    }

    public IFile getMarkingFile() {
        return File.createAsFacade((Map)((Object)this.getSubmodelElement(MARKINGFILEID)));
    }

    public void setMarkingAdditionalText(List<Property> markingAdditionalText) {
        if (markingAdditionalText != null && markingAdditionalText.size() > 0) {
            for (Property markingAdditionalSingle : markingAdditionalText) {
                this.addSubmodelElement(markingAdditionalSingle);
            }
        }
    }

    public List<IProperty> getMarkingAdditionalText() {
        ArrayList<IProperty> ret = new ArrayList<IProperty>();
        List<ISubmodelElement> elements = SubmodelElementRetrievalHelper.getSubmodelElementsByIdPrefix(MARKINGADDITIONALTEXTPREFIX, this.getSubmodelElements());
        for (ISubmodelElement element : elements) {
            ret.add((IProperty)element);
        }
        return ret;
    }
}

