/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.vab.coder.json.serialization;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.Base64;
import java.util.Collection;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.eclipse.basyx.vab.coder.json.serialization.GSONToolsFactory;
import org.eclipse.basyx.vab.coder.json.serialization.Serializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GSONTools
implements Serializer {
    private static Logger logger = LoggerFactory.getLogger(GSONTools.class);
    public static final String OPERATION = "operation";
    public static final String LAMBDA = "lambda";
    public static final String BASYXFUNCTIONTYPE = "_basyxFunctionType";
    public static final String BASYXINVOCABLE = "_basyxInvocable";
    public static final String BASYXFUNCTIONVALUE = "_basyxFunctionValue";
    protected static JsonParser parser = new JsonParser();
    protected GSONToolsFactory toolsFactory = null;
    private boolean removeNull = true;
    private boolean removeEmpty = false;

    public GSONTools(GSONToolsFactory factory) {
        this.toolsFactory = factory;
    }

    public GSONTools(GSONToolsFactory factory, boolean removeNull, boolean removeEmpty) {
        this(factory);
        this.removeNull = removeNull;
        this.removeEmpty = removeEmpty;
    }

    public void setFactory(GSONToolsFactory newFactoryInstance) {
        this.toolsFactory = newFactoryInstance;
    }

    @Override
    public Object deserialize(String str) {
        JsonElement elem = parser.parse(str);
        return this.deserializeJsonElement(elem);
    }

    @Override
    public String serialize(Object obj) {
        JsonElement elem = this.serializeObject(obj);
        if (this.removeNull) {
            Gson gson = new Gson();
            return gson.toJson(elem);
        }
        return elem.toString();
    }

    private JsonElement serializeObject(Object obj) {
        if (obj == null) {
            return JsonNull.INSTANCE;
        }
        if (obj.getClass().isPrimitive() || GSONTools.isWrapperType(obj.getClass()) || obj instanceof String || obj instanceof Number) {
            return this.serializePrimitive(obj);
        }
        if (obj instanceof Map) {
            return this.serializeMap((Map)obj);
        }
        if (obj instanceof Collection) {
            return this.serializeCollection((Collection)obj);
        }
        if (this.isFunction(obj)) {
            return this.serializeFunction(obj);
        }
        throw new RuntimeException("Unknown element!");
    }

    private Object deserializeJsonElement(JsonElement elem) {
        if (elem.isJsonPrimitive()) {
            return this.deserializeJsonPrimitive(elem.getAsJsonPrimitive());
        }
        if (elem.isJsonObject()) {
            return this.deserializeJsonObject(elem.getAsJsonObject());
        }
        if (elem.isJsonArray()) {
            return this.deserializeJsonArray(elem.getAsJsonArray());
        }
        return null;
    }

    private static boolean isWrapperType(Class<?> clazz) {
        return clazz.equals(Boolean.class) || clazz.equals(Integer.class) || clazz.equals(Character.class) || clazz.equals(Byte.class) || clazz.equals(Short.class) || clazz.equals(Double.class) || clazz.equals(Long.class) || clazz.equals(Float.class);
    }

    private Object deserializeJsonPrimitive(JsonPrimitive primitive) {
        if (primitive.isNumber()) {
            if (primitive.getAsString().contains(".")) {
                return primitive.getAsDouble();
            }
            BigInteger tmp = primitive.getAsBigInteger();
            if (BigInteger.valueOf(Integer.MAX_VALUE).compareTo(tmp) >= 0 && BigInteger.valueOf(Integer.MIN_VALUE).compareTo(tmp) <= 0) {
                return primitive.getAsInt();
            }
            if (BigInteger.valueOf(Long.MAX_VALUE).compareTo(tmp) >= 0 && BigInteger.valueOf(Long.MIN_VALUE).compareTo(tmp) <= 0) {
                return primitive.getAsLong();
            }
            return tmp;
        }
        if (primitive.isBoolean()) {
            return primitive.getAsBoolean();
        }
        return primitive.getAsString();
    }

    private JsonPrimitive serializePrimitive(Object primitive) {
        if (primitive instanceof Number) {
            return new JsonPrimitive((Number)primitive);
        }
        if (primitive instanceof Boolean) {
            return new JsonPrimitive((Boolean)primitive);
        }
        return new JsonPrimitive((String)primitive);
    }

    private Object deserializeJsonObject(JsonObject map) {
        if (map.has(BASYXFUNCTIONTYPE)) {
            String functionType = map.get(BASYXFUNCTIONTYPE).getAsString();
            if (functionType.equals(OPERATION)) {
                return BASYXINVOCABLE;
            }
            if (functionType.equals(LAMBDA)) {
                return this.deserializeObjectFromString(map.get(BASYXFUNCTIONVALUE).getAsString());
            }
            throw new RuntimeException("Unknown function type " + functionType + "!");
        }
        return this.deserializeObject(map);
    }

    private Map<String, Object> deserializeObject(JsonObject map) {
        Map<String, Object> ret = this.toolsFactory.createMap();
        for (String k : map.keySet()) {
            ret.put(k, this.deserializeJsonElement(map.get(k)));
        }
        return ret;
    }

    private JsonObject serializeMap(Map<String, Object> map) {
        JsonObject obj = new JsonObject();
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            Object value = entry.getValue();
            if (this.removeEmpty && value instanceof Collection && ((Collection)value).isEmpty()) continue;
            obj.add(entry.getKey(), this.serializeObject(value));
        }
        return obj;
    }

    private Collection<Object> deserializeJsonArray(JsonArray array) {
        Collection<Object> list = this.toolsFactory.createCollection();
        for (JsonElement element : array) {
            list.add(this.deserializeJsonElement(element));
        }
        return list;
    }

    private boolean isFunction(Object value) {
        return value instanceof Supplier || value instanceof Function || value instanceof Consumer || value instanceof BiConsumer || value instanceof Runnable;
    }

    private JsonArray serializeCollection(Collection<Object> collection) {
        JsonArray array = new JsonArray();
        collection.stream().map(this::serializeObject).forEach(arg_0 -> ((JsonArray)array).add(arg_0));
        return array;
    }

    private JsonObject serializeFunction(Object function) {
        if (function instanceof Serializable) {
            return this.serializeSerializableOperation((Serializable)function);
        }
        return this.serializeNotSerializableOperation(function);
    }

    protected Object deserializeObjectFromString(String s) {
        Object result = null;
        byte[] data = Base64.getDecoder().decode(s);
        ByteArrayInputStream byteStream = new ByteArrayInputStream(data);
        try (ObjectInputStream stream = new ObjectInputStream(byteStream);){
            result = stream.readObject();
        }
        catch (IOException | ClassNotFoundException e) {
            logger.error("Exception in deserializeObjectFromString", (Throwable)e);
        }
        return result;
    }

    protected String serializeObjectToString(Serializable obj) {
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        try (ObjectOutputStream oos = new ObjectOutputStream(outStream);){
            oos.writeObject(obj);
        }
        catch (IOException e) {
            logger.error("Exception in serializeObjectToString", (Throwable)e);
        }
        byte[] data = outStream.toByteArray();
        return Base64.getEncoder().encodeToString(data);
    }

    private JsonObject serializeSerializableOperation(Serializable value) {
        JsonObject target = new JsonObject();
        target.add(BASYXFUNCTIONTYPE, (JsonElement)new JsonPrimitive(LAMBDA));
        String serialized = this.serializeObjectToString(value);
        target.add(BASYXFUNCTIONVALUE, (JsonElement)new JsonPrimitive(serialized));
        return target;
    }

    private JsonObject serializeNotSerializableOperation(Object function) {
        JsonObject target = new JsonObject();
        target.add(BASYXFUNCTIONTYPE, (JsonElement)new JsonPrimitive(OPERATION));
        return target;
    }
}

