/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.vab.protocol.opcua.connector;

import java.security.KeyPair;
import java.security.cert.X509Certificate;
import org.eclipse.basyx.vab.protocol.opcua.types.MessageSecurityMode;
import org.eclipse.basyx.vab.protocol.opcua.types.SecurityPolicy;

public final class ClientConfiguration
implements Cloneable {
    private SecurityPolicy securityPolicy = SecurityPolicy.None;
    private MessageSecurityMode messageSecurityMode = MessageSecurityMode.None;
    private String applicationName;
    private String applicationUri;
    private KeyPair keyPair;
    private X509Certificate certificate;

    public ClientConfiguration clone() {
        try {
            return (ClientConfiguration)super.clone();
        }
        catch (CloneNotSupportedException impossible) {
            throw new AssertionError((Object)impossible);
        }
    }

    public KeyPair getKeyPair() {
        return this.keyPair;
    }

    public X509Certificate getCertificate() {
        return this.certificate;
    }

    public ClientConfiguration setKeyPairAndCertificate(KeyPair keyPair, X509Certificate certificate) {
        if (keyPair == null ^ certificate == null) {
            throw new IllegalArgumentException("Either both keyPair and certificate are null or neither.");
        }
        this.keyPair = keyPair;
        this.certificate = certificate;
        return this;
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public ClientConfiguration setApplicationName(String applicationName) {
        this.applicationName = applicationName;
        return this;
    }

    public String getApplicationUri() {
        return this.applicationUri;
    }

    public ClientConfiguration setApplicationUri(String applicationUri) {
        this.applicationUri = applicationUri;
        return this;
    }

    public MessageSecurityMode getMessageSecurityMode() {
        return this.messageSecurityMode;
    }

    public ClientConfiguration setMessageSecurityMode(MessageSecurityMode messageSecurityMode) {
        if (messageSecurityMode == null) {
            throw new IllegalArgumentException("messageSecurityMode can not be null.");
        }
        this.messageSecurityMode = messageSecurityMode;
        return this;
    }

    public SecurityPolicy getSecurityPolicy() {
        return this.securityPolicy;
    }

    public ClientConfiguration setSecurityPolicy(SecurityPolicy securityPolicy) {
        if (securityPolicy == null) {
            throw new IllegalArgumentException("securityPolicy can not be null.");
        }
        this.securityPolicy = securityPolicy;
        return this;
    }
}

